/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildCommand;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildGroup;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildIOType;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildResource;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.FileMacroExplicitSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.macros.IFileContextData;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStep
implements IBuildStep {
    private List<BuildIOType> fInputTypes = new ArrayList<BuildIOType>();
    private List<BuildIOType> fOutputTypes = new ArrayList<BuildIOType>();
    private ITool fTool;
    private BuildGroup fBuildGroup;
    private boolean fNeedsRebuild;
    private boolean fIsRemoved;
    private BuildDescription fBuildDescription;
    private IInputType fInputType;
    private ITool fLibTool;
    private boolean fAssignToCalculated;

    protected BuildStep(BuildDescription des, ITool tool, IInputType inputType) {
        this.fTool = tool;
        this.fInputType = inputType;
        this.fBuildDescription = des;
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("step " + DbgUtil.stepName(this) + " created");
        }
        des.stepCreated(this);
    }

    @Override
    public IBuildIOType[] getInputIOTypes() {
        return this.fInputTypes.toArray(new BuildIOType[this.fInputTypes.size()]);
    }

    @Override
    public IBuildIOType[] getOutputIOTypes() {
        return this.fOutputTypes.toArray(new BuildIOType[this.fOutputTypes.size()]);
    }

    @Override
    public boolean needsRebuild() {
        if (this.fNeedsRebuild || this.fTool != null && this.fTool.needsRebuild() || this.fLibTool != null && this.fLibTool.needsRebuild()) {
            return true;
        }
        return this.fBuildGroup != null && this.fBuildGroup.needsRebuild();
    }

    public void setRebuildState(boolean rebuild) {
        this.fNeedsRebuild = rebuild;
    }

    public BuildResource[] removeIOType(BuildIOType type) {
        BuildResource[] rcs = type.remove();
        if (type.isInput()) {
            this.fInputTypes.remove(type);
        } else {
            this.fOutputTypes.remove(type);
        }
        return rcs;
    }

    BuildResource[][] remove() {
        BuildResource[][] rcs = this.clear();
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("step  " + DbgUtil.stepName(this) + " removed");
        }
        this.fBuildDescription.stepRemoved(this);
        this.fBuildDescription = null;
        return rcs;
    }

    BuildResource[][] clear() {
        BuildResource[][] rcs = new BuildResource[][]{(BuildResource[])this.getInputResources(), (BuildResource[])this.getOutputResources()};
        BuildIOType[] types = (BuildIOType[])this.getInputIOTypes();
        int i = 0;
        while (i < types.length) {
            this.removeIOType(types[i]);
            ++i;
        }
        types = (BuildIOType[])this.getOutputIOTypes();
        i = 0;
        while (i < types.length) {
            this.removeIOType(types[i]);
            ++i;
        }
        return rcs;
    }

    public void removeResource(BuildIOType type, BuildResource rc, boolean rmTypeIfEmpty) {
        type.removeResource(rc);
        if (rmTypeIfEmpty && type.getResources().length == 0) {
            this.removeIOType(type);
        }
    }

    public BuildIOType createIOType(boolean input, boolean primary, IBuildObject ioType) {
        if (input) {
            if (this.fBuildDescription.getInputStep() == this) {
                throw new IllegalArgumentException("input step can not have inputs");
            }
        } else if (this.fBuildDescription.getOutputStep() == this) {
            throw new IllegalArgumentException("input step can not have outputs");
        }
        BuildIOType arg = new BuildIOType(this, input, primary, ioType);
        if (input) {
            this.fInputTypes.add(arg);
        } else {
            this.fOutputTypes.add(arg);
        }
        return arg;
    }

    public void setTool(ITool tool) {
        this.fTool = tool;
    }

    public ITool getTool() {
        return this.fTool;
    }

    public BuildIOType[] getPrimaryTypes(boolean input) {
        List<BuildIOType> types = input ? this.fInputTypes : this.fOutputTypes;
        ArrayList<BuildIOType> list = new ArrayList<BuildIOType>();
        for (BuildIOType arg : types) {
            if (!arg.isPrimary()) continue;
            list.add(arg);
        }
        return list.toArray(new BuildIOType[list.size()]);
    }

    public BuildIOType getIOTypeForType(IBuildObject ioType, boolean input) {
        List<BuildIOType> list;
        List<BuildIOType> list2 = list = input ? this.fInputTypes : this.fOutputTypes;
        if (ioType != null) {
            for (BuildIOType arg : list) {
                if (arg.getIoType() != ioType) continue;
                return arg;
            }
        } else if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    protected void setGroup(BuildGroup group) {
        this.fBuildGroup = group;
    }

    @Override
    public IBuildResource[] getInputResources() {
        return this.getResources(true);
    }

    @Override
    public IBuildResource[] getOutputResources() {
        return this.getResources(false);
    }

    public IBuildResource[] getResources(boolean input) {
        List<BuildIOType> list = input ? this.fInputTypes : this.fOutputTypes;
        HashSet<IBuildResource> set = new HashSet<IBuildResource>();
        for (BuildIOType arg : list) {
            IBuildResource[] rcs = arg.getResources();
            int j = 0;
            while (j < rcs.length) {
                set.add(rcs[j]);
                ++j;
            }
        }
        return set.toArray(new BuildResource[set.size()]);
    }

    @Override
    public IBuildCommand[] getCommands(IPath cwd, Map inputArgValues, Map outputArgValues, boolean resolveAll) {
        if (cwd == null) {
            cwd = this.calcCWD();
        }
        if (this.fTool == null) {
            int i;
            String step = null;
            String appendToLastStep = null;
            if (this == this.fBuildDescription.getInputStep()) {
                step = this.fBuildDescription.getConfiguration().getPrebuildStep();
            } else if (this == this.fBuildDescription.getOutputStep()) {
                step = this.fBuildDescription.getConfiguration().getPostbuildStep();
            } else if (this == this.fBuildDescription.getCleanStep()) {
                step = this.fBuildDescription.getConfiguration().getCleanCommand();
                IBuildResource[] generated = this.fBuildDescription.getResources(true);
                if (generated.length != 0) {
                    StringBuffer buf = new StringBuffer();
                    i = 0;
                    while (i < generated.length) {
                        buf.append(' ');
                        IPath rel = BuildDescriptionManager.getRelPath(cwd, generated[i].getLocation());
                        buf.append(rel.toString());
                        ++i;
                    }
                    appendToLastStep = buf.toString();
                }
            }
            if (step != null && (step = step.trim()).length() > 0 && (step = this.resolveMacros(step, resolveAll)) != null && (step = step.trim()).length() > 0) {
                String[] commands = step.split(";");
                if (appendToLastStep != null && commands.length != 0) {
                    commands[commands.length - 1] = String.valueOf(commands[commands.length - 1]) + appendToLastStep;
                }
                ArrayList<IBuildCommand> list = new ArrayList<IBuildCommand>();
                i = 0;
                while (i < commands.length) {
                    IBuildCommand[] cmds = this.createCommandsFromString(commands[i], cwd, this.getEnvironment());
                    int j = 0;
                    while (j < cmds.length) {
                        list.add(cmds[j]);
                        ++j;
                    }
                    ++i;
                }
                return list.toArray(new BuildCommand[list.size()]);
            }
            return new IBuildCommand[0];
        }
        this.performAsignToOption(cwd);
        BuildResource inRc = this.getRcForMacros(true);
        BuildResource outRc = this.getRcForMacros(false);
        IPath inRcPath = inRc != null ? BuildDescriptionManager.getRelPath(cwd, inRc.getLocation()) : null;
        IPath outRcPath = outRc != null ? BuildDescriptionManager.getRelPath(cwd, outRc.getLocation()) : null;
        IManagedCommandLineGenerator gen = this.fTool.getCommandLineGenerator();
        FileContextData data = new FileContextData(inRcPath, outRcPath, null, this.fTool);
        String outPrefix = this.fTool.getOutputPrefix();
        outPrefix = this.resolveMacros(outPrefix, data, true);
        outRcPath = this.rmNamePrefix(outRcPath, outPrefix);
        IManagedCommandLineInfo info = gen.generateCommandLineInfo(this.fTool, this.fTool.getToolCommand(), this.getCommandFlags(inRcPath, outRcPath, resolveAll), this.fTool.getOutputFlag(), outPrefix, this.listToString(this.resourcesToStrings(cwd, this.getPrimaryResources(false), outPrefix), " "), this.getInputResources(cwd, this.getPrimaryResources(true)), this.fTool.getCommandLinePattern());
        return this.createCommandsFromString(this.resolveMacros(info.getCommandLine(), data, true), cwd, this.getEnvironment());
    }

    private IPath rmNamePrefix(IPath path, String prefix) {
        String name;
        if (prefix != null && prefix.length() != 0 && (name = path.lastSegment()).startsWith(prefix)) {
            name = name.substring(prefix.length());
            path = path.removeLastSegments(1).append(name);
        }
        return path;
    }

    private String[] getInputResources(IPath cwd, BuildResource[] rcs) {
        String[] resources = this.resourcesToStrings(cwd, rcs, null);
        String[] libs = null;
        IOption[] opts = this.fTool.getOptions();
        int i = 0;
        while (i < opts.length) {
            try {
                String[] l;
                IOption opt = opts[i];
                if (opt.getValueType() == 6 && (l = opts[i].getLibraries()) != null) {
                    libs = new String[l.length];
                    int j = 0;
                    while (j < l.length) {
                        libs[j] = String.valueOf(opt.getCommand()) + l[j];
                        ++j;
                    }
                }
            }
            catch (BuildException buildException) {}
            ++i;
        }
        if (libs != null) {
            String[] irs = new String[resources.length + libs.length];
            System.arraycopy(resources, 0, irs, 0, resources.length);
            System.arraycopy(libs, 0, irs, resources.length, libs.length);
            return irs;
        }
        return resources;
    }

    private IPath calcCWD() {
        IPath cwd = this.fBuildDescription.getDefaultBuildDirLocation();
        if (!cwd.isAbsolute()) {
            cwd = this.fBuildDescription.getConfiguration().getOwner().getProject().getLocation().append(cwd);
        }
        return cwd;
    }

    protected Map<String, String> getEnvironment() {
        return this.fBuildDescription.getEnvironment();
    }

    protected IBuildCommand[] createCommandsFromString(String cmd, IPath cwd, Map<String, String> env) {
        char[] arr = cmd.toCharArray();
        char expect = '\u0000';
        char prev = '\u0000';
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            char ch = arr[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (expect == ch) {
                        expect = '\u0000';
                        break;
                    }
                    if (expect == '\u0000') {
                        expect = ch;
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case ' ': {
                    if (expect == '\u0000') {
                        if (prev == ' ') break;
                        list.add(buf.toString());
                        buf.delete(0, buf.length());
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            prev = ch;
            ++i;
        }
        if (buf.length() > 0) {
            list.add(buf.toString());
        }
        Path c = new Path((String)list.remove(0));
        String[] args = list.toArray(new String[list.size()]);
        return new IBuildCommand[]{new BuildCommand((IPath)c, args, env, cwd, this)};
    }

    private BuildResource[] getPrimaryResources(boolean input) {
        BuildIOType[] types = this.getPrimaryTypes(input);
        if (types.length == 0) {
            types = input ? (BuildIOType[])this.getInputIOTypes() : (BuildIOType[])this.getOutputIOTypes();
        }
        ArrayList<BuildResource> list = new ArrayList<BuildResource>();
        int i = 0;
        while (i < types.length) {
            BuildResource[] rcs = (BuildResource[])types[i].getResources();
            int j = 0;
            while (j < rcs.length) {
                list.add(rcs[j]);
                ++j;
            }
            ++i;
        }
        return list.toArray(new BuildResource[list.size()]);
    }

    private String[] resourcesToStrings(IPath cwd, BuildResource[] rcs, String prefixToRm) {
        ArrayList<String> list = new ArrayList<String>(rcs.length);
        int i = 0;
        while (i < rcs.length) {
            IPath path = BuildDescriptionManager.getRelPath(cwd, rcs[i].getLocation());
            path = this.rmNamePrefix(path, prefixToRm);
            list.add(path.toOSString());
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private String resolveMacros(String str, IFileContextData fileData, boolean resolveAll) {
        String result = str;
        try {
            if (resolveAll) {
                IConfiguration cfg = this.getBuildDescription().getConfiguration();
                IBuilder builder = cfg.getBuilder();
                SupplierBasedCdtVariableSubstitutor sub = this.createSubstitutor(cfg, builder, fileData);
                result = CdtVariableResolver.resolveToString((String)str, (IVariableSubstitutor)sub);
            } else {
                result = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(str, "", " ", 1, fileData);
            }
        }
        catch (CdtVariableException cdtVariableException) {}
        return result;
    }

    private String resolveMacros(String str, boolean resolveAll) {
        String result = str;
        try {
            IConfiguration cfg = this.getBuildDescription().getConfiguration();
            result = resolveAll ? ManagedBuildManager.getBuildMacroProvider().resolveValue(str, "", " ", 3, cfg) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(str, "", " ", 3, cfg);
        }
        catch (CdtVariableException cdtVariableException) {}
        return result;
    }

    private SupplierBasedCdtVariableSubstitutor createSubstitutor(IConfiguration cfg, IBuilder builder, IFileContextData fileData) {
        BuildMacroProvider prov = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
        IMacroContextInfo info = prov.getMacroContextInfo(1, fileData);
        FileMacroExplicitSubstitutor sub = new FileMacroExplicitSubstitutor(info, cfg, builder, "", " ");
        return sub;
    }

    private String[] getCommandFlags(IPath inRcPath, IPath outRcPath, boolean resolveAll) {
        try {
            if (resolveAll) {
                IConfiguration cfg = this.getBuildDescription().getConfiguration();
                IBuilder builder = cfg.getBuilder();
                return ((Tool)this.fTool).getToolCommandFlags(inRcPath, outRcPath, this.createSubstitutor(cfg, builder, new FileContextData(inRcPath, outRcPath, null, this.fTool)), BuildMacroProvider.getDefault());
            }
            return this.fTool.getToolCommandFlags(inRcPath, outRcPath);
        }
        catch (BuildException buildException) {
            return new String[0];
        }
    }

    private String listToString(String[] list, String delimiter) {
        if (list == null || list.length == 0) {
            return new String();
        }
        StringBuffer buf = new StringBuffer(list[0]);
        int i = 1;
        while (i < list.length) {
            buf.append(delimiter).append(list[i]);
            ++i;
        }
        return buf.toString();
    }

    private BuildResource getRcForMacros(boolean input) {
        IBuildResource[] rcs;
        int i;
        IBuildIOType[] types = this.getPrimaryTypes(input);
        if (types.length != 0) {
            i = 0;
            while (i < types.length) {
                rcs = types[i].getResources();
                if (rcs.length != 0) {
                    return (BuildResource)rcs[0];
                }
                ++i;
            }
        }
        IBuildIOType[] iBuildIOTypeArray = types = input ? this.getInputIOTypes() : this.getOutputIOTypes();
        if (types.length != 0) {
            i = 0;
            while (i < types.length) {
                rcs = types[i].getResources();
                if (rcs.length != 0) {
                    return (BuildResource)rcs[0];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean isRemoved() {
        return this.fIsRemoved;
    }

    public void setRemoved() {
        this.fIsRemoved = true;
        this.fNeedsRebuild = false;
    }

    @Override
    public IBuildDescription getBuildDescription() {
        return this.fBuildDescription;
    }

    boolean isMultiAction() {
        BuildIOType arg;
        BuildIOType[] args = this.getPrimaryTypes(true);
        BuildIOType buildIOType = arg = args.length > 0 ? args[0] : null;
        if (arg != null) {
            if (arg.getIoType() != null) {
                return ((IInputType)arg.getIoType()).getMultipleOfType();
            }
            return this.fTool != null && this.fTool == ((Configuration)this.fBuildDescription.getConfiguration()).calculateTargetTool();
        }
        return false;
    }

    public IInputType getInputType() {
        return this.fInputType;
    }

    public void setLibTool(ITool libTool) {
        this.fLibTool = libTool;
    }

    public ITool getLibTool() {
        return this.fLibTool;
    }

    protected void performAsignToOption(IPath cwd) {
        if (this.fTool == null && !this.fAssignToCalculated) {
            return;
        }
        this.fAssignToCalculated = true;
        IConfiguration cfg = this.fBuildDescription.getConfiguration();
        for (BuildIOType bType : this.fInputTypes) {
            IInputType type = (IInputType)bType.getIoType();
            if (type == null) continue;
            IOption option = this.fTool.getOptionBySuperClassId(type.getOptionId());
            IOption assignToOption = this.fTool.getOptionBySuperClassId(type.getAssignToOptionId());
            if (assignToOption == null || option != null) continue;
            try {
                int j;
                BuildResource[] bRcs = (BuildResource[])bType.getResources();
                int optType = assignToOption.getValueType();
                if (optType == 2) {
                    String optVal = "";
                    j = 0;
                    while (j < bRcs.length) {
                        if (j != 0) {
                            optVal = String.valueOf(optVal) + " ";
                        }
                        optVal = String.valueOf(optVal) + BuildDescriptionManager.getRelPath(cwd, bRcs[j].getLocation()).toOSString();
                        ++j;
                    }
                    ManagedBuildManager.setOption(cfg, (IHoldsOptions)this.fTool, assignToOption, optVal);
                    continue;
                }
                if (optType == 3 || optType == 6 || optType == 7 || optType == 4 || optType == 5 || optType == 8 || optType == 9 || optType == 10 || optType == 11 || optType == -4 || optType == -5 || optType == -8 || optType == -9 || optType == -10 || optType == -11) {
                    String[] paths = new String[bRcs.length];
                    j = 0;
                    while (j < bRcs.length) {
                        paths[j] = BuildDescriptionManager.getRelPath(cwd, bRcs[j].getLocation()).toOSString();
                        ++j;
                    }
                    ManagedBuildManager.setOption(cfg, (IHoldsOptions)this.fTool, assignToOption, paths);
                    continue;
                }
                if (optType == 0) {
                    if (bRcs.length > 0) {
                        ManagedBuildManager.setOption(cfg, (IHoldsOptions)this.fTool, assignToOption, true);
                        continue;
                    }
                    ManagedBuildManager.setOption(cfg, (IHoldsOptions)this.fTool, assignToOption, false);
                    continue;
                }
                if (optType != 1 || bRcs.length <= 0) continue;
                ManagedBuildManager.setOption(cfg, (IHoldsOptions)this.fTool, assignToOption, BuildDescriptionManager.getRelPath(cwd, bRcs[0].getLocation()).toOSString());
            }
            catch (BuildException buildException) {}
        }
    }
}

