/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IBuildModelBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IResourceRebuildStateContainer;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBuilder
implements IBuildModelBuilder {
    private static final String PATH_ENV = "PATH";
    private static final String PROPERTY_DELIMITER = "path.separator";
    private static final String PROPERTY_OS_NAME = "os.name";
    private static final String PROPERTY_OS_VALUE = "windows";
    static final String DELIMITER_UNIX = ":";
    static final String DELIMITER_WINDOWS = ";";
    private IBuildCommand fCmd;
    private Process fProcess;
    private String fErrMsg;
    private static final String BUILDER_MSG_HEADER = "InternalBuilder.msg.header";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");

    public CommandBuilder(IBuildCommand cmd, IResourceRebuildStateContainer cr) {
        this.fCmd = cmd;
    }

    protected OutputStream wrap(OutputStream out) {
        return new OutputStreamWrapper(out);
    }

    @Override
    public int build(OutputStream out, OutputStream err, IProgressMonitor monitor) {
        monitor.beginTask("", this.getNumCommands());
        monitor.subTask("");
        ICommandLauncher launcher = this.createLauncher();
        int status = 0;
        launcher.showCommand(true);
        try {
            this.fProcess = launcher.execute(this.fCmd.getCommand(), this.fCmd.getArgs(), this.mapToStringArray(this.fCmd.getEnvironment()), this.fCmd.getCWD(), monitor);
        }
        catch (CoreException e1) {
            if (DbgUtil.DEBUG) {
                DbgUtil.trace("Error launching command: " + e1.getMessage());
            }
            monitor.done();
            return -2;
        }
        if (this.fProcess != null) {
            try {
                this.fProcess.getOutputStream().close();
            }
            catch (IOException iOException) {}
        }
        int st = launcher.waitAndRead(this.wrap(out), this.wrap(err), (IProgressMonitor)new SubProgressMonitor(monitor, this.getNumCommands()));
        switch (st) {
            case 0: {
                if (this.fProcess.exitValue() == 0) break;
                status = -1;
                break;
            }
            case 1: {
                status = -3;
                this.fErrMsg = launcher.getErrorMessage();
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace("command cancelled: " + this.fErrMsg);
                }
                this.printMessage(this.fErrMsg, out);
                break;
            }
            default: {
                status = -2;
                this.fErrMsg = launcher.getErrorMessage();
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace("error launching the command: " + this.fErrMsg);
                }
                String program = this.fCmd.getCommand().toOSString();
                String envPath = this.fCmd.getEnvironment().get(PATH_ENV);
                if (envPath == null) {
                    envPath = System.getenv(PATH_ENV);
                }
                if (PathUtil.findProgramLocation((String)program, (String)envPath) == null) {
                    this.printMessage(this.fErrMsg, out);
                    String errMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.program.not.in.path", program);
                    this.printErrorMessage(String.valueOf(errMsg) + NEWLINE, out);
                    this.printMessage(null, "PATH=[" + envPath + "]", out);
                    break;
                }
                this.printErrorMessage(this.fErrMsg, out);
            }
        }
        monitor.done();
        return status;
    }

    protected ICommandLauncher createLauncher() {
        return new CommandSearchLauncher();
    }

    public String getErrMsg() {
        return this.fErrMsg;
    }

    private String[] mapToStringArray(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            list.add(String.valueOf(entry.getKey()) + '=' + entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    private void printMessage(String prefix, String msg, OutputStream os) {
        if (os != null) {
            if (prefix == null) {
                prefix = "";
            }
            msg = String.valueOf(prefix) + msg + NEWLINE;
            try {
                os.write(msg.getBytes());
                os.flush();
            }
            catch (IOException iOException) {}
        }
    }

    protected void printMessage(String msg, OutputStream os) {
        if (os != null) {
            msg = ManagedMakeMessages.getFormattedString(BUILDER_MSG_HEADER, msg);
            this.printMessage(null, msg, os);
        }
    }

    private void printErrorMessage(String msg, OutputStream os) {
        if (os != null) {
            String errorPrefix = ManagedMakeMessages.getResourceString("ManagedMakeBuilder.error.prefix");
            this.printMessage(errorPrefix, msg, os);
        }
    }

    public int getNumCommands() {
        return 1;
    }

    protected String getCommandLine() {
        StringBuffer buf = new StringBuffer();
        if (this.fCmd != null) {
            buf.append(this.fCmd.getCommand().toOSString());
            String[] args = this.fCmd.getArgs();
            int i = 0;
            while (i < args.length) {
                buf.append(' ');
                buf.append(args[i]);
                ++i;
            }
            buf.append(NEWLINE);
        }
        return buf.toString();
    }

    private String getExecutable(String command, Map<String, String> environment) {
        if (new Path(command).isAbsolute()) {
            return command;
        }
        return this.searchExecutable(command, this.getPaths(environment));
    }

    private String[] getPaths(Map<String, String> env) {
        String pathsStr = env.get(PATH_ENV);
        if (pathsStr == null) {
            Set<Map.Entry<String, String>> entrySet = env.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (!PATH_ENV.equalsIgnoreCase(entry.getKey())) continue;
                pathsStr = entry.getValue();
                break;
            }
        }
        if (pathsStr != null) {
            String delimiter = this.getDelimiter();
            return pathsStr.split(delimiter);
        }
        return null;
    }

    private String getDelimiter() {
        String delimiter = System.getProperty(PROPERTY_DELIMITER);
        if (delimiter == null) {
            delimiter = this.isWindows() ? DELIMITER_WINDOWS : DELIMITER_UNIX;
        }
        return delimiter;
    }

    private String searchExecutable(String command, String[] paths) {
        if (paths == null) {
            return null;
        }
        int i = 0;
        while (i < paths.length) {
            File file = new File(paths[i], command.toString());
            if (file.isFile()) {
                return file.toString();
            }
            ++i;
        }
        return null;
    }

    private boolean isWindows() {
        String prop = System.getProperty(PROPERTY_OS_NAME);
        return prop != null ? prop.toLowerCase().startsWith(PROPERTY_OS_VALUE) : false;
    }

    private class CommandSearchLauncher
    extends CommandLauncher {
        private CommandSearchLauncher() {
        }

        protected String[] constructCommandArray(String command, String[] commandArgs) {
            String cmd;
            String[] args = new String[1 + commandArgs.length];
            if (!CommandBuilder.this.isWindows() && (cmd = CommandBuilder.this.getExecutable(command, CommandBuilder.this.fCmd.getEnvironment())) != null) {
                command = cmd;
            }
            args[0] = command;
            System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
            return args;
        }

        protected void printCommandLine(OutputStream os) {
            if (os != null) {
                String cmd = CommandBuilder.this.getCommandLine();
                try {
                    os.write(cmd.getBytes());
                    os.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected class OutputStreamWrapper
    extends OutputStream {
        private OutputStream fOut;

        public OutputStreamWrapper(OutputStream out) {
            this.fOut = out;
        }

        public void write(int b) throws IOException {
            this.fOut.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.fOut.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.fOut.write(b, off, len);
        }

        public void flush() throws IOException {
            this.fOut.flush();
        }

        public void close() throws IOException {
        }
    }
}

