/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolListModificationInfo;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildFileData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConfiguration
extends ResourceInfo
implements IFileInfo {
    private static final String EMPTY_STRING = new String();
    private static final String REBUILD_STATE = "rebuildState";
    private List<ITool> toolList;
    private Map<String, ITool> toolMap;
    private Integer rcbsApplicability;
    private String toolsToInvoke;
    private boolean isExtensionResourceConfig = false;
    private boolean resolved = true;

    public ResourceConfiguration(IConfiguration parent, IManagedConfigElement element, String managedBuildRevision) {
        super(parent, element, true);
        this.isExtensionResourceConfig = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionResourceConfiguration(this);
        IManagedConfigElement[] tools = element.getChildren("tool");
        int n = 0;
        while (n < tools.length) {
            Tool toolChild = new Tool((IBuildObject)this, tools[n], this.getManagedBuildRevision());
            this.getToolList().add(toolChild);
            this.getToolMap().put(toolChild.getId(), toolChild);
            ++n;
        }
        this.setDirty(false);
    }

    public ResourceConfiguration(IConfiguration parent, ICStorageElement element, String managedBuildRevision) {
        super(parent, element, true);
        this.isExtensionResourceConfig = false;
        this.setResourceData((CResourceData)new BuildFileData(this));
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        ICStorageElement[] configElements = element.getChildren();
        int i = 0;
        while (i < configElements.length) {
            ICStorageElement configElement = configElements[i];
            if (configElement.getName().equals("tool")) {
                Tool tool = new Tool((IBuildObject)this, configElement, this.getManagedBuildRevision());
                this.addTool(tool);
            }
            ++i;
        }
        String rebuild = PropertyManager.getInstance().getProperty(this, REBUILD_STATE);
        if (rebuild == null || Boolean.valueOf(rebuild).booleanValue()) {
            this.setRebuildState(true);
        }
        this.setDirty(false);
    }

    public ResourceConfiguration(FolderInfo folderInfo, ITool baseTool, String id, String resourceName, IPath path) {
        super(folderInfo, path, id, resourceName);
        this.isExtensionResourceConfig = folderInfo.isExtensionElement();
        if (!this.isExtensionResourceConfig) {
            this.setResourceData((CResourceData)new BuildFileData(this));
        }
        if (folderInfo.getParent() != null) {
            this.setManagedBuildRevision(folderInfo.getParent().getManagedBuildRevision());
        }
        this.setDirty(false);
        this.toolsToInvoke = EMPTY_STRING;
        this.rcbsApplicability = new Integer(4);
        String extString = path.getFileExtension();
        if (baseTool != null && baseTool.getParentResourceInfo() != folderInfo) {
            baseTool = null;
        }
        ITool[] tools = folderInfo.getFilteredTools();
        String subId = new String();
        int i = 0;
        while (i < tools.length) {
            if (tools[i].buildsFileType(extString)) {
                baseTool = tools[i];
                break;
            }
            ++i;
        }
        if (baseTool != null) {
            subId = ManagedBuildManager.calculateChildId(baseTool.getId(), null);
            this.createTool(baseTool, subId, baseTool.getName(), false);
            this.setRebuildState(true);
        }
    }

    public ResourceConfiguration(IConfiguration cfg, ResourceConfiguration cloneConfig, String id, Map<IPath, Map<String, String>> superClassIdMap, boolean cloneChildren) {
        super(cfg, cloneConfig, id);
        boolean copyIds;
        this.isExtensionResourceConfig = cfg.isExtensionElement();
        if (!cloneConfig.isExtensionResourceConfig) {
            cloneChildren = true;
        }
        if (!this.isExtensionResourceConfig) {
            this.setResourceData((CResourceData)new BuildFileData(this));
        }
        this.setManagedBuildRevision(cloneConfig.getManagedBuildRevision());
        if (cloneConfig.toolsToInvoke != null) {
            this.toolsToInvoke = new String(cloneConfig.toolsToInvoke);
        }
        if (cloneConfig.rcbsApplicability != null) {
            this.rcbsApplicability = new Integer(cloneConfig.rcbsApplicability);
        }
        boolean bl = copyIds = cloneChildren && id.equals(cloneConfig.id);
        if (cloneConfig.toolList != null) {
            for (ITool toolChild : cloneConfig.getToolList()) {
                String subId = null;
                Map<String, String> curIdMap = superClassIdMap.get(cloneConfig.getPath());
                ITool extTool = ManagedBuildManager.getExtensionTool(toolChild);
                if (curIdMap != null && extTool != null) {
                    subId = curIdMap.get(extTool.getId());
                }
                String subName = toolChild.getName();
                if (subId == null) {
                    subId = extTool != null ? (copyIds ? toolChild.getId() : ManagedBuildManager.calculateChildId(extTool.getId(), null)) : (copyIds ? toolChild.getId() : ManagedBuildManager.calculateChildId(toolChild.getId(), null));
                }
                ITool toolSuperClass = null;
                String superId = null;
                ITool otherSuperTool = toolChild.getSuperClass();
                if (otherSuperTool != null) {
                    if (otherSuperTool.isExtensionElement()) {
                        toolSuperClass = otherSuperTool;
                    } else {
                        IResourceInfo otherRcInfo = otherSuperTool.getParentResourceInfo();
                        IResourceInfo thisRcInfo = cfg.getResourceInfo(otherRcInfo.getPath(), true);
                        ITool otherExtTool = ManagedBuildManager.getExtensionTool(otherSuperTool);
                        if (otherExtTool != null) {
                            if (thisRcInfo != null) {
                                ITool[] tools = thisRcInfo.getTools();
                                int i = 0;
                                while (i < tools.length) {
                                    ITool thisExtTool = ManagedBuildManager.getExtensionTool(tools[i]);
                                    if (otherExtTool.equals(thisExtTool)) {
                                        toolSuperClass = tools[i];
                                        superId = toolSuperClass.getId();
                                        break;
                                    }
                                    ++i;
                                }
                            } else {
                                superId = copyIds ? otherSuperTool.getId() : ManagedBuildManager.calculateChildId(otherExtTool.getId(), null);
                                Map<String, String> idMap = superClassIdMap.get(otherRcInfo.getPath());
                                if (idMap == null) {
                                    idMap = new HashMap<String, String>();
                                    superClassIdMap.put(otherRcInfo.getPath(), idMap);
                                }
                                idMap.put(otherExtTool.getId(), superId);
                            }
                        }
                    }
                }
                Tool newTool = null;
                newTool = toolSuperClass != null ? new Tool((IBuildObject)this, toolSuperClass, subId, subName, (Tool)toolChild) : new Tool((IBuildObject)this, superId, subId, subName, (Tool)toolChild);
                this.addTool(newTool);
            }
        }
        if (copyIds) {
            this.isDirty = cloneConfig.isDirty;
            this.needsRebuild = cloneConfig.needsRebuild;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public ResourceConfiguration(ResourceConfiguration baseInfo, IPath path, String id, String name) {
        super(baseInfo, path, id, name);
        this.isExtensionResourceConfig = false;
        this.setResourceData((CResourceData)new BuildFileData(this));
        this.setManagedBuildRevision(baseInfo.getManagedBuildRevision());
        this.toolsToInvoke = baseInfo.toolsToInvoke;
        this.rcbsApplicability = new Integer(4);
        if (baseInfo.toolList != null) {
            for (ITool toolChild : baseInfo.getToolList()) {
                ITool superTool = toolChild.getSuperClass();
                String baseId = superTool != null ? superTool.getId() : toolChild.getId();
                String subId = ManagedBuildManager.calculateChildId(baseId, null);
                String subName = toolChild.getName();
                Tool newTool = new Tool((IBuildObject)this, superTool, subId, subName, (Tool)toolChild);
                this.addTool(newTool);
            }
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.toolsToInvoke = SafeStringInterner.safeIntern((String)element.getAttribute("toolsToInvoke"));
        String rcbsApplicabilityStr = element.getAttribute("rcbsApplicability");
        if (rcbsApplicabilityStr == null || rcbsApplicabilityStr.equals("disable")) {
            this.rcbsApplicability = new Integer(4);
        } else if (rcbsApplicabilityStr.equals("before")) {
            this.rcbsApplicability = new Integer(2);
        } else if (rcbsApplicabilityStr.equals("after")) {
            this.rcbsApplicability = new Integer(3);
        } else if (rcbsApplicabilityStr.equals("override")) {
            this.rcbsApplicability = new Integer(1);
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        if (element.getAttribute("toolsToInvoke") != null) {
            this.toolsToInvoke = SafeStringInterner.safeIntern((String)element.getAttribute("toolsToInvoke"));
        }
        if (element.getAttribute("rcbsApplicability") != null) {
            String rcbsApplicabilityStr = element.getAttribute("rcbsApplicability");
            if (rcbsApplicabilityStr == null || rcbsApplicabilityStr.equals("disable")) {
                this.rcbsApplicability = new Integer(4);
            } else if (rcbsApplicabilityStr.equals("before")) {
                this.rcbsApplicability = new Integer(2);
            } else if (rcbsApplicabilityStr.equals("after")) {
                this.rcbsApplicability = new Integer(3);
            } else if (rcbsApplicabilityStr.equals("override")) {
                this.rcbsApplicability = new Integer(1);
            }
        }
    }

    @Override
    public void serialize(ICStorageElement element) {
        super.serialize(element);
        if (this.toolsToInvoke != null) {
            element.setAttribute("toolsToInvoke", this.toolsToInvoke);
        }
        if (this.rcbsApplicability != null) {
            String str;
            switch (this.getRcbsApplicability()) {
                case 2: {
                    str = "before";
                    break;
                }
                case 3: {
                    str = "after";
                    break;
                }
                case 1: {
                    str = "override";
                    break;
                }
                case 4: {
                    str = "disable";
                    break;
                }
                default: {
                    str = "disable";
                }
            }
            element.setAttribute("rcbsApplicability", str);
        }
        List<ITool> toolElements = this.getToolList();
        for (ITool tool : toolElements) {
            ICStorageElement toolElement = element.createChild("tool");
            ((Tool)tool).serialize(toolElement);
        }
        this.setDirty(false);
    }

    @Override
    public ITool[] getTools() {
        List<ITool> toolList = this.getToolList();
        ITool[] tools = new ITool[toolList.size()];
        int i = 0;
        for (ITool tool : toolList) {
            tools[i++] = tool;
        }
        return tools;
    }

    @Override
    public ITool getTool(String id) {
        Tool tool = (Tool)this.getToolMap().get(id);
        return tool;
    }

    private List<ITool> getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList<ITool>();
        }
        return this.toolList;
    }

    private Map<String, ITool> getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap<String, ITool>();
        }
        return this.toolMap;
    }

    public void addTool(Tool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
        this.setRebuildState(true);
    }

    @Override
    public void removeTool(ITool tool) {
        this.getToolList().remove(tool);
        this.getToolMap().remove(tool);
        this.setRebuildState(true);
    }

    @Override
    public String getResourcePath() {
        IPath path = this.getParent().getOwner().getProject().getFullPath();
        path = path.append(this.getPath());
        return path.toString();
    }

    @Override
    public int getRcbsApplicability() {
        if (this.rcbsApplicability == null) {
            return 4;
        }
        return this.rcbsApplicability;
    }

    @Override
    public ITool[] getToolsToInvoke() {
        ITool[] tools;
        String t_ToolsToInvoke = EMPTY_STRING;
        String rcbsToolId = EMPTY_STRING;
        int rcbsToolIdx = -1;
        ITool[] resConfigTools = this.getTools();
        if (resConfigTools.length == 0) {
            this.toolsToInvoke = EMPTY_STRING;
            ITool[] tools2 = new ITool[]{};
            return tools2;
        }
        int i = 0;
        while (i < resConfigTools.length) {
            if (resConfigTools[i].getCustomBuildStep() && !resConfigTools[i].isExtensionElement()) {
                rcbsToolId = resConfigTools[i].getId();
                rcbsToolIdx = i;
                break;
            }
            ++i;
        }
        if (!rcbsToolId.equals(EMPTY_STRING)) {
            switch (this.rcbsApplicability) {
                case 1: {
                    this.toolsToInvoke = rcbsToolId;
                    tools = new ITool[]{resConfigTools[rcbsToolIdx]};
                    break;
                }
                case 3: {
                    int j = 0;
                    tools = new ITool[resConfigTools.length];
                    i = 0;
                    while (i < resConfigTools.length) {
                        if (resConfigTools[i].getId() != rcbsToolId) {
                            t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                            tools[j++] = resConfigTools[i];
                        }
                        ++i;
                    }
                    t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + rcbsToolId;
                    tools[j++] = resConfigTools[rcbsToolIdx];
                    this.toolsToInvoke = t_ToolsToInvoke;
                    break;
                }
                case 2: {
                    int j = 0;
                    tools = new ITool[resConfigTools.length];
                    t_ToolsToInvoke = String.valueOf(rcbsToolId) + ";";
                    tools[j++] = resConfigTools[rcbsToolIdx];
                    i = 0;
                    while (i < resConfigTools.length) {
                        if (resConfigTools[i].getId() != rcbsToolId) {
                            t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                            tools[j++] = resConfigTools[i];
                        }
                        ++i;
                    }
                    int len = t_ToolsToInvoke.length();
                    this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
                    break;
                }
                case 4: {
                    if (resConfigTools.length == 1) {
                        tools = new ITool[]{};
                        this.toolsToInvoke = EMPTY_STRING;
                        break;
                    }
                    int j = 0;
                    tools = new ITool[resConfigTools.length - 1];
                    i = 0;
                    while (i < resConfigTools.length) {
                        if (resConfigTools[i].getId() != rcbsToolId) {
                            t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                            tools[j++] = resConfigTools[i];
                        }
                        ++i;
                    }
                    int len = t_ToolsToInvoke.length();
                    this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
                    break;
                }
                default: {
                    tools = new ITool[resConfigTools.length];
                    i = 0;
                    while (i < resConfigTools.length) {
                        t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                        tools[i] = resConfigTools[i];
                        ++i;
                    }
                    int len = t_ToolsToInvoke.length();
                    this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
                    break;
                }
            }
        } else {
            tools = new ITool[resConfigTools.length];
            i = 0;
            while (i < resConfigTools.length) {
                t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                tools[i] = resConfigTools[i];
                ++i;
            }
            int len = t_ToolsToInvoke.length();
            this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
        }
        return tools;
    }

    @Override
    public void setRcbsApplicability(int newValue) {
        if (this.rcbsApplicability == null || this.rcbsApplicability != newValue) {
            this.rcbsApplicability = new Integer(newValue);
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public void setResourcePath(String path) {
        if (path == null) {
            return;
        }
        IPath p = new Path(path).removeFirstSegments(1);
        this.setPath(p);
    }

    public boolean isExtensionResourceConfiguration() {
        return this.isExtensionResourceConfig;
    }

    @Override
    public boolean isDirty() {
        if (this.isExtensionResourceConfig) {
            return false;
        }
        if (super.isDirty()) {
            return true;
        }
        for (ITool toolChild : this.getToolList()) {
            if (!toolChild.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDirty(boolean isDirty) {
        if (this.isExtensionResourceConfig) {
            return;
        }
        super.setDirty(isDirty);
        if (!isDirty) {
            for (ITool toolChild : this.getToolList()) {
                toolChild.setDirty(false);
            }
        }
    }

    @Override
    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            for (ITool toolChild : this.getToolList()) {
                ((Tool)toolChild).resolveReferences();
            }
        }
    }

    @Override
    public ITool createTool(ITool superClass, String id, String name, boolean isExtensionElement) {
        Tool tool = new Tool(this, superClass, id, name, isExtensionElement);
        this.addTool(tool);
        this.setDirty(true);
        return tool;
    }

    public void reset() {
        ITool[] tools = this.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IOption[] opts = tool.getOptions();
            int j = 0;
            while (j < opts.length) {
                tool.removeOption(opts[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setToolCommand(ITool tool, String command) {
        tool.setToolCommand(command);
    }

    @Override
    public IResource getOwner() {
        return this.getParent().getOwner();
    }

    @Override
    public Version getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
    }

    @Override
    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        for (ITool tool : this.getToolList()) {
            ((Tool)tool).updateManagedBuildRevision(revision);
        }
    }

    @Override
    public boolean needsRebuild() {
        if (super.needsRebuild()) {
            return true;
        }
        ITool[] tools = this.getToolsToInvoke();
        int i = 0;
        while (i < tools.length) {
            if (tools[i].needsRebuild()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionResourceConfiguration() && rebuild) {
            return;
        }
        if (this.needsRebuild() != rebuild) {
            super.setRebuildState(rebuild);
            this.saveRebuildState();
        }
        if (!rebuild) {
            ITool[] tools = this.getToolsToInvoke();
            int i = 0;
            while (i < tools.length) {
                tools[i].setRebuildState(false);
                ++i;
            }
        }
    }

    private void saveRebuildState() {
        PropertyManager.getInstance().setProperty(this, REBUILD_STATE, Boolean.toString(this.needsRebuild()));
    }

    @Override
    public final int getKind() {
        return 8;
    }

    @Override
    public CFileData getFileData() {
        return (CFileData)this.getResourceData();
    }

    @Override
    public CLanguageData[] getCLanguageDatas() {
        ITool[] tools = this.getTools();
        ArrayList<CLanguageData> list = new ArrayList<CLanguageData>();
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            CLanguageData[] datas = tool.getCLanguageDatas();
            int j = 0;
            while (j < datas.length) {
                list.add(datas[j]);
                ++j;
            }
            ++n2;
        }
        return list.toArray(new BuildLanguageData[list.size()]);
    }

    public IToolChain getBaseToolChain() {
        ITool[] tools = this.getToolsToInvoke();
        ITool baseTool = null;
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            ITool superTool = tool.getSuperClass();
            if (superTool != null) {
                baseTool = superTool;
                if (!superTool.isExtensionElement()) break;
            }
            ++i;
        }
        IToolChain baseTc = null;
        if (baseTool != null) {
            IBuildObject parent = baseTool.getParent();
            if (parent instanceof IToolChain) {
                baseTc = (IToolChain)parent;
            } else if (parent instanceof ResourceConfiguration) {
                baseTc = ((ResourceConfiguration)parent).getBaseToolChain();
            }
        }
        return baseTc;
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionResourceConfig;
    }

    @Override
    public boolean supportsBuild(boolean managed) {
        ITool[] tools = this.getToolsToInvoke();
        int i = 0;
        while (i < tools.length) {
            if (!tools[i].supportsBuild(managed)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Set<String> contributeErrorParsers(Set<String> set) {
        return this.contributeErrorParsers(this.getToolsToInvoke(), set);
    }

    @Override
    public void resetErrorParsers() {
        this.resetErrorParsers(this.getToolsToInvoke());
    }

    @Override
    void removeErrorParsers(Set<String> set) {
        this.removeErrorParsers(this.getToolsToInvoke(), set);
    }

    @Override
    void resolveProjectReferences(boolean onLoad) {
        for (ITool tool : this.getToolList()) {
            ((Tool)tool).resolveProjectReferences(onLoad);
        }
    }

    @Override
    public boolean hasCustomSettings() {
        ITool[] otherTools;
        ResourceInfo parentRc = this.getParentResourceInfo();
        if (parentRc instanceof FolderInfo) {
            ITool otherTool;
            IPath path = this.getPath();
            String ext = path.getFileExtension();
            if (ext == null) {
                ext = "";
            }
            if ((otherTool = ((FolderInfo)parentRc).getToolFromInputExtension(ext)) == null) {
                return true;
            }
            ITool[] tti = this.getToolsToInvoke();
            if (tti.length != 1) {
                return true;
            }
            return ((Tool)tti[0]).hasCustomSettings((Tool)otherTool);
        }
        ITool[] tools = this.getTools();
        if (tools.length != (otherTools = ((IFileInfo)((Object)parentRc)).getTools()).length) {
            return true;
        }
        int i = 0;
        while (i < tools.length) {
            Tool tool = (Tool)tools[i];
            Tool otherTool = (Tool)otherTools[i];
            if (tool.hasCustomSettings(otherTool)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setTools(ITool[] tools) {
        ToolListModificationInfo info = this.getToolListModificationInfo(tools);
        info.apply();
    }

    @Override
    public boolean isFolderInfo() {
        return false;
    }

    @Override
    void applyToolsInternal(ITool[] resultingTools, ToolListModificationInfo info) {
        List<ITool> list = this.getToolList();
        Map<String, ITool> map = this.getToolMap();
        list.clear();
        map.clear();
        list.addAll(Arrays.asList(resultingTools));
        int i = 0;
        while (i < resultingTools.length) {
            ITool tool = resultingTools[i];
            map.put(tool.getId(), tool);
            ++i;
        }
        this.setRebuildState(true);
    }

    @Override
    public boolean isSupported() {
        IConfiguration cfg;
        IFolderInfo foInfo = this.getParentFolderInfo();
        if (foInfo == null && (cfg = this.getParent()) != null) {
            foInfo = cfg.getRootFolderInfo();
        }
        if (foInfo != null) {
            return foInfo.isSupported();
        }
        return false;
    }
}

