/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IModificationStatus;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ModificationStatus;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.MultiStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolListModificationInfo {
    private ToolInfo[] fResultingTools;
    private ToolInfo[] fAddedTools;
    private ToolInfo[] fRemovedTools;
    private IResourceInfo fRcInfo;

    ToolListModificationInfo(IResourceInfo rcInfo, ToolInfo[] resultingTools, ToolInfo[] added, ToolInfo[] removed, ToolInfo[] remaining) {
        this.fResultingTools = resultingTools;
        this.fRemovedTools = removed;
        this.fAddedTools = added;
        this.fRcInfo = rcInfo;
    }

    public IResourceInfo getResourceInfo() {
        return this.fRcInfo;
    }

    public List<ITool> getResultingToolList(List<ITool> list) {
        if (list == null) {
            list = new ArrayList<ITool>(this.fResultingTools.length);
        }
        int i = 0;
        while (i < this.fResultingTools.length) {
            list.add(this.fResultingTools[i].getResultingTool());
            ++i;
        }
        return list;
    }

    public ITool[] getResultingTools() {
        ITool[] tools = new ITool[this.fResultingTools.length];
        int i = 0;
        while (i < this.fResultingTools.length) {
            tools[i] = this.fResultingTools[i].getResultingTool();
            ++i;
        }
        return tools;
    }

    public ITool[] getRemovedTools() {
        return ToolListModificationInfo.toToolArray(this.fRemovedTools, true);
    }

    public ITool[] getAddedTools(boolean resulting) {
        return ToolListModificationInfo.toToolArray(this.fAddedTools, !resulting);
    }

    public ITool[] getRemainedTools() {
        return ToolListModificationInfo.toToolArray(this.fAddedTools, true);
    }

    private static ITool[] toToolArray(ToolInfo[] infos, boolean initialTools) {
        ITool[] tools = new ITool[infos.length];
        int i = 0;
        while (i < infos.length) {
            tools[i] = initialTools ? infos[i].getInitialTool() : infos[i].getResultingTool();
            ++i;
        }
        return tools;
    }

    private static ITool[][] toToolArray(ToolInfo[][] infos, boolean initialTools) {
        ITool[][] tools = new ITool[infos.length][];
        int i = 0;
        while (i < infos.length) {
            tools[i] = ToolListModificationInfo.toToolArray(infos[i], initialTools);
            ++i;
        }
        return tools;
    }

    public MultiStatus getModificationStatus() {
        IModificationStatus status;
        int i;
        ArrayList<ModificationStatus> statusList = new ArrayList<ModificationStatus>();
        ToolInfo[][] conflictInfos = this.calculateConflictingTools(this.fResultingTools);
        ITool[][] conflicting = ToolListModificationInfo.toToolArray(conflictInfos, true);
        HashMap<String, String> unspecifiedRequiredProps = new HashMap<String, String>();
        HashMap<String, String> unspecifiedProps = new HashMap<String, String>();
        HashSet<String> undefinedSet = new HashSet<String>();
        IConfiguration cfg = this.fRcInfo.getParent();
        ITool[] nonManagedTools = null;
        if (cfg.isManagedBuildOn() && cfg.supportsBuild(true)) {
            ArrayList<ITool> list = new ArrayList<ITool>();
            i = 0;
            while (i < this.fResultingTools.length) {
                if (!this.fResultingTools[i].getInitialTool().supportsBuild(true)) {
                    list.add(this.fResultingTools[i].getInitialTool());
                }
                ++i;
            }
            if (list.size() != 0) {
                nonManagedTools = list.toArray(new Tool[list.size()]);
            }
        }
        if ((status = new ModificationStatus(unspecifiedRequiredProps, unspecifiedProps, undefinedSet, conflicting, nonManagedTools)).getSeverity() != 0) {
            statusList.add((ModificationStatus)status);
        }
        i = 0;
        while (i < this.fResultingTools.length) {
            status = this.fResultingTools[i].getModificationStatus();
            if (status.getSeverity() != 0) {
                statusList.add((ModificationStatus)status);
            }
            ++i;
        }
        if (statusList.size() != 0) {
            return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, "", null);
        }
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, "", null);
    }

    private ToolInfo[][] calculateConflictingTools(ToolInfo[] infos) {
        infos = this.filterInfos(infos);
        return this.doCalculateConflictingTools(infos);
    }

    private ToolInfo[] filterInfos(ToolInfo[] infos) {
        if (this.fRcInfo instanceof FolderInfo) {
            Map<ITool, ToolInfo> map = ToolListModificationInfo.createInitialToolToToolInfoMap(infos);
            ITool[] tools = new ArrayList<ITool>(map.keySet()).toArray(new ITool[map.size()]);
            if ((tools = ((FolderInfo)this.fRcInfo).filterTools(tools, this.fRcInfo.getParent().getManagedProject())).length < infos.length) {
                infos = new ToolInfo[tools.length];
                int i = 0;
                while (i < infos.length) {
                    infos[i] = map.get(tools[i]);
                    ++i;
                }
            }
        }
        return infos;
    }

    private static Map<ITool, ToolInfo> createInitialToolToToolInfoMap(ToolInfo[] infos) {
        LinkedHashMap<ITool, ToolInfo> map = new LinkedHashMap<ITool, ToolInfo>();
        int i = 0;
        while (i < infos.length) {
            map.put(infos[i].getInitialTool(), infos[i]);
            ++i;
        }
        return map;
    }

    private ToolInfo[][] doCalculateConflictingTools(ToolInfo[] infos) {
        HashSet set = new HashSet();
        set.addAll(Arrays.asList(infos));
        ArrayList<ToolInfo[]> result = new ArrayList<ToolInfo[]>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ToolInfo ti = (ToolInfo)iter.next();
            ITool t = ti.getInitialTool();
            iter.remove();
            HashSet tmp = (HashSet)set.clone();
            ArrayList<ITool> list = new ArrayList<ITool>();
            Iterator tmpIt = tmp.iterator();
            while (tmpIt.hasNext()) {
                ToolInfo otherTi = (ToolInfo)tmpIt.next();
                ITool other = otherTi.getInitialTool();
                String[] conflicts = this.getConflictingInputExts(t, other);
                if (conflicts.length == 0) continue;
                list.add(other);
                tmpIt.remove();
            }
            if (list.size() != 0) {
                list.add(t);
                ToolInfo[] arr = list.toArray(new ToolInfo[list.size()]);
                result.add(arr);
            }
            set = tmp;
            iter = set.iterator();
        }
        return (ToolInfo[][])result.toArray((T[])new ToolInfo[result.size()][]);
    }

    private String[] getConflictingInputExts(ITool tool1, ITool tool2) {
        IProject project = this.fRcInfo.getParent().getOwner().getProject();
        String[] ext1 = ((Tool)tool1).getAllInputExtensions(project);
        String[] ext2 = ((Tool)tool2).getAllInputExtensions(project);
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(ext1));
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < ext2.length) {
            if (set1.remove(ext2[i])) {
                result.add(ext2[i]);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public void apply() {
        ((ResourceInfo)this.fRcInfo).doApply(this);
    }
}

