/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolListModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IFileInfoModification;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoModification
extends ToolListModification
implements IFileInfoModification {
    private String fFileExt;
    private Set<IPath> fApplPathSet;
    private IProject fProject;

    public FileInfoModification(ResourceConfiguration rcInfo) {
        super((ResourceInfo)rcInfo, rcInfo.getTools());
    }

    public FileInfoModification(ResourceConfiguration rcInfo, FileInfoModification base) {
        super((ResourceInfo)rcInfo, base);
    }

    @Override
    protected boolean canRemove(ITool realTool) {
        return true;
    }

    @Override
    protected boolean canAdd(Tool tool) {
        String ext = this.getFileExtension();
        return tool.buildsFileType(ext, this.getProject());
    }

    @Override
    protected boolean canReplace(Tool fromTool, Tool toTool) {
        String ext = this.getFileExtension();
        return toTool.buildsFileType(ext, this.getProject());
    }

    @Override
    protected Set<IPath> getToolApplicabilityPathSet(Tool realTool, boolean isProject) {
        if (this.fApplPathSet == null) {
            HashSet<IPath> s = new HashSet<IPath>(1);
            s.add(this.getResourceInfo().getPath());
            this.fApplPathSet = Collections.unmodifiableSet(s);
        }
        return this.fApplPathSet;
    }

    @Override
    protected Set<Tool> getExtensionConflictToolSet(Tool tool, Tool[] toos) {
        return Collections.emptySet();
    }

    @Override
    protected Tool[] filterTools(Tool[] tools) {
        return tools;
    }

    private String getFileExtension() {
        if (this.fFileExt == null) {
            this.fFileExt = this.getResourceInfo().getPath().getFileExtension();
            if (this.fFileExt == null) {
                this.fFileExt = "";
            }
        }
        return this.fFileExt;
    }

    private IProject getProject() {
        if (this.fProject == null) {
            this.fProject = this.getResourceInfo().getParent().getOwner().getProject();
        }
        return this.fProject;
    }

    @Override
    public void restoreDefaults() {
        ResourceConfiguration rcInfo = (ResourceConfiguration)this.getResourceInfo();
        IFolderInfo parentFo = rcInfo.getParentFolderInfo();
        String ext = rcInfo.getPath().getFileExtension();
        if (ext == null) {
            ext = "";
        }
        ITool tool = parentFo.getToolFromInputExtension(ext);
        ITool realTool = ManagedBuildManager.getRealTool(tool);
        boolean add = true;
        ITool[] curTools = this.getProjectTools();
        int i = 0;
        while (i < curTools.length) {
            ITool cur = curTools[i];
            if (ManagedBuildManager.getRealTool(cur) == realTool) {
                add = false;
            } else if (!cur.getCustomBuildStep()) {
                this.changeProjectTools(cur, null);
            }
            ++i;
        }
        if (add && tool != null) {
            this.changeProjectTools(null, tool);
        }
    }
}

