/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.language;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.resources.IFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLanguageConfiguration {
    private static final String ALL_CONFIGURATIONS = "";
    private Map<String, Map<String, String>> fConfigurationContentTypeMappings = new TreeMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> fFileConfigurationMappings = new TreeMap<String, Map<String, String>>();

    public String getLanguageForContentType(ICConfigurationDescription configuration, String contentTypeId) {
        String configurationId = this.getId(configuration);
        Map<String, String> contentTypeMappings = this.fConfigurationContentTypeMappings.get(configurationId);
        if (contentTypeMappings == null) {
            return null;
        }
        return contentTypeMappings.get(contentTypeId);
    }

    public String getLanguageForFile(ICConfigurationDescription configuration, IFile file) {
        return this.getLanguageForFile(configuration, file.getProjectRelativePath().toPortableString());
    }

    public String getLanguageForFile(ICConfigurationDescription configuration, String path) {
        Map<String, String> configurationMappings = this.fFileConfigurationMappings.get(path);
        if (configurationMappings == null) {
            return null;
        }
        String configurationId = this.getId(configuration);
        return configurationMappings.get(configurationId);
    }

    public void addContentTypeMapping(ICConfigurationDescription configuration, String contentType, String language) {
        String configurationId = this.getId(configuration);
        Map<String, String> contentTypeMappings = this.fConfigurationContentTypeMappings.get(configurationId);
        if (contentTypeMappings == null) {
            contentTypeMappings = new TreeMap<String, String>();
            this.fConfigurationContentTypeMappings.put(configurationId, contentTypeMappings);
        }
        contentTypeMappings.put(contentType, language);
    }

    public void removeContentTypeMapping(ICConfigurationDescription configuration, String contentType) {
        String configurationId = this.getId(configuration);
        Map<String, String> contentTypeMappings = this.fConfigurationContentTypeMappings.get(configurationId);
        if (contentTypeMappings == null) {
            return;
        }
        contentTypeMappings.remove(contentType);
        if (contentTypeMappings.size() == 0) {
            this.fConfigurationContentTypeMappings.remove(configurationId);
        }
    }

    public void addFileMapping(ICConfigurationDescription configuration, IFile file, String language) {
        this.addFileMapping(configuration, file.getProjectRelativePath().toPortableString(), language);
    }

    public void addFileMapping(ICConfigurationDescription configuration, String filePath, String language) {
        Map<String, String> configurationMappings = this.fFileConfigurationMappings.get(filePath);
        if (configurationMappings == null) {
            configurationMappings = new TreeMap<String, String>();
            this.fFileConfigurationMappings.put(filePath, configurationMappings);
        }
        String configurationId = this.getId(configuration);
        configurationMappings.put(configurationId, language);
    }

    public void removeFileMapping(ICConfigurationDescription configuration, IFile file) {
        this.removeFileMapping(configuration, file.getProjectRelativePath().toPortableString());
    }

    public void removeFileMapping(ICConfigurationDescription configuration, String filePath) {
        Map<String, String> fileMappings = this.fFileConfigurationMappings.get(filePath);
        if (fileMappings == null) {
            return;
        }
        String configurationId = this.getId(configuration);
        fileMappings.remove(configurationId);
        if (fileMappings.size() == 0) {
            this.fFileConfigurationMappings.remove(configurationId);
        }
    }

    public void removeAllFileMappings(String filePath) {
        this.fFileConfigurationMappings.remove(filePath);
    }

    public void removeAllFileMappings(IFile file) {
        this.removeAllFileMappings(file.getProjectRelativePath().toPortableString());
    }

    public Map<String, Map<String, String>> getContentTypeMappings() {
        return this.copyLanguageMappings(this.fConfigurationContentTypeMappings, false);
    }

    public void setContentTypeMappings(Map<String, Map<String, String>> mappings) {
        this.fConfigurationContentTypeMappings = this.copyLanguageMappings(mappings, false);
    }

    public Map<String, Map<String, String>> getFileMappings() {
        return this.copyLanguageMappings(this.fFileConfigurationMappings, false);
    }

    public void setFileMappings(IFile file, Map<String, String> mappings) {
        this.fFileConfigurationMappings.put(file.getProjectRelativePath().toPortableString(), new TreeMap<String, String>(mappings));
    }

    private Map<String, Map<String, String>> copyLanguageMappings(Map<String, Map<String, String>> mappings, boolean isReadOnly) {
        Map<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : mappings.entrySet()) {
            Map<String, String> map = entry.getValue();
            map = isReadOnly ? Collections.unmodifiableMap(map) : new TreeMap<String, String>(map);
            result.put(entry.getKey(), map);
        }
        if (isReadOnly) {
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    public void setFileMappings(Map<String, Map<String, String>> mappings) {
        this.fFileConfigurationMappings = this.copyLanguageMappings(mappings, false);
    }

    private String getId(ICConfigurationDescription configuration) {
        if (configuration == null) {
            return ALL_CONFIGURATIONS;
        }
        return configuration.getId();
    }
}

