/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CoreMacroSupplierBase;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.osgi.framework.Bundle;

public class CdtMacroSupplier
extends CoreMacroSupplierBase {
    private static CdtMacroSupplier fInstance;
    public static final String DOT = ".";
    public static final String EMPTY_STRING = "";
    private static final String[] fConfigurationMacros;
    private static final String[] fWorkspaceMacros;
    private static final String[] fCDTEclipseMacros;

    static {
        fConfigurationMacros = new String[]{"ConfigName", "ConfigDescription", "ProjName", "ProjDirPath"};
        fWorkspaceMacros = new String[]{"WorkspaceDirPath", "DirectoryDelimiter", "PathDelimiter"};
        fCDTEclipseMacros = new String[]{"EclipseVersion", "CDTVersion", "HostOsName", "HostArchName", "OsType", "ArchType"};
    }

    public String[] getMacroNames(int contextType) {
        return this.getMacroNames(contextType, true);
    }

    private String[] getMacroNames(int contextType, boolean clone) {
        String[] names = null;
        switch (contextType) {
            case 3: {
                names = fConfigurationMacros;
                break;
            }
            case 5: {
                names = fWorkspaceMacros;
                break;
            }
            case 6: {
                names = fCDTEclipseMacros;
                break;
            }
        }
        if (names != null) {
            return clone ? (String[])names.clone() : names;
        }
        return null;
    }

    private CdtMacroSupplier() {
    }

    public static CdtMacroSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new CdtMacroSupplier();
        }
        return fInstance;
    }

    public ICdtVariable getMacro(String macroName, int contextType, Object contextData) {
        ICdtVariable macro = null;
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof ICConfigurationDescription)) break;
                macro = this.getMacro(macroName, (ICConfigurationDescription)contextData);
                break;
            }
            case 5: {
                if (contextData != null && !(contextData instanceof IWorkspace)) break;
                macro = this.getMacro(macroName, (IWorkspace)contextData);
                break;
            }
            case 6: {
                if (contextData != null) break;
                macro = this.getMacro(macroName);
                break;
            }
        }
        return macro;
    }

    private IProject getProject(ICConfigurationDescription cfgDes) {
        ICProjectDescription des = cfgDes.getProjectDescription();
        return des != null ? des.getProject() : null;
    }

    public ICdtVariable getMacro(String macroName, ICConfigurationDescription cfg) {
        IProject project;
        CdtVariable macro = null;
        if ("ConfigName".equals(macroName)) {
            macro = new CdtVariable(macroName, 1, cfg.getName());
        } else if ("ConfigDescription".equals(macroName)) {
            macro = new CdtVariable(macroName, 1, cfg.getDescription());
        } else if ("ProjName".equals(macroName)) {
            IProject project2 = this.getProject(cfg);
            if (project2 != null) {
                macro = new CdtVariable(macroName, 1, project2.getName());
            }
        } else if ("ProjDirPath".equals(macroName) && (project = this.getProject(cfg)) != null && project.getLocation() != null) {
            macro = new CdtVariable(macroName, 1, project.getLocation().toString());
        }
        return macro;
    }

    public ICdtVariable getMacro(String macroName, IWorkspace wsp) {
        if (wsp == null) {
            wsp = ResourcesPlugin.getWorkspace();
        }
        CdtVariable macro = null;
        if ("WorkspaceDirPath".equals(macroName)) {
            macro = new CdtVariable(macroName, 5, wsp.getRoot().getLocation().toOSString());
        } else if ("DirectoryDelimiter".equals(macroName)) {
            macro = this.isWin32() ? new CdtVariable(macroName, 1, "\\") : new CdtVariable(macroName, 1, "/");
        } else if ("PathDelimiter".equals(macroName)) {
            macro = this.isWin32() ? new CdtVariable(macroName, 1, ";") : new CdtVariable(macroName, 1, ":");
        }
        return macro;
    }

    private boolean isWin32() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows ");
    }

    public ICdtVariable getMacro(String macroName) {
        CdtVariable macro = null;
        if ("EclipseVersion".equals(macroName)) {
            Bundle bundle = Platform.getBundle("org.eclipse.platform");
            String version = bundle != null ? (String)bundle.getHeaders().get("Bundle-Version") : null;
            macro = new CdtVariable(macroName, 1, version);
        } else if ("CDTVersion".equals(macroName)) {
            String version = (String)CCorePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
            macro = new CdtVariable(macroName, 1, version);
        } else if ("HostOsName".equals(macroName)) {
            String os = System.getProperty("os.name");
            macro = new CdtVariable(macroName, 1, os);
        } else if ("HostArchName".equals(macroName)) {
            String arch = System.getProperty("os.arch");
            macro = new CdtVariable(macroName, 1, arch);
        } else if ("OsType".equals(macroName)) {
            String os = Platform.getOS();
            macro = new CdtVariable(macroName, 1, os);
        } else if ("ArchType".equals(macroName)) {
            String arch = Platform.getOSArch();
            macro = new CdtVariable(macroName, 1, arch);
        }
        return macro;
    }

    public ICdtVariable[] getMacros(int contextType, Object contextData) {
        String[] names = this.getMacroNames(contextType, false);
        if (names != null) {
            ICdtVariable[] macros = new ICdtVariable[names.length];
            int num = 0;
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                ICdtVariable macro = this.getMacro(name, contextType, contextData);
                if (macro != null) {
                    macros[num++] = macro;
                }
                ++n2;
            }
            if (macros.length != num) {
                ICdtVariable[] tmp = new ICdtVariable[num];
                if (num > 0) {
                    System.arraycopy(macros, 0, tmp, 0, num);
                }
                macros = tmp;
            }
            return macros;
        }
        return null;
    }
}

