/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTDeclarationStatement
extends ASTNode
implements IASTDeclarationStatement,
IASTAmbiguityParent {
    private IASTDeclaration declaration;

    public CASTDeclarationStatement() {
    }

    public CASTDeclarationStatement(IASTDeclaration declaration) {
        this.setDeclaration(declaration);
    }

    public CASTDeclarationStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTDeclarationStatement copy(IASTNode.CopyStyle style) {
        CASTDeclarationStatement copy = new CASTDeclarationStatement();
        copy.setDeclaration(this.declaration == null ? null : this.declaration.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        this.declaration = declaration;
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(DECLARATION);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declaration != null && !this.declaration.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.declaration) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.declaration = (IASTDeclaration)other;
        }
    }
}

