/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTModificationMap {
    private HashMap<IASTNode, List<ASTModification>> fModifications = new HashMap();

    public void addModification(ASTModification mod) {
        IASTNode targetNode = mod.getKind() == ASTModification.ModificationKind.INSERT_BEFORE ? mod.getTargetNode().getParent() : mod.getTargetNode();
        List<ASTModification> mods = this.fModifications.get(targetNode);
        if (mods == null || mods.isEmpty()) {
            mods = new ArrayList<ASTModification>();
            mods.add(mod);
            this.fModifications.put(targetNode, mods);
        } else {
            switch (mod.getKind()) {
                case REPLACE: {
                    if (mods.get(mods.size() - 1).getKind() != ASTModification.ModificationKind.INSERT_BEFORE) {
                        throw new IllegalArgumentException("Attempt to replace a node that has been modified");
                    }
                    mods.add(mod);
                    break;
                }
                case APPEND_CHILD: {
                    if (mods.get(mods.size() - 1).getKind() == ASTModification.ModificationKind.REPLACE) {
                        throw new IllegalArgumentException("Attempt to modify a node that has been replaced");
                    }
                    mods.add(mod);
                    break;
                }
                case INSERT_BEFORE: {
                    int i = mods.size() - 1;
                    while (i >= 0) {
                        if (mods.get(i).getKind() == ASTModification.ModificationKind.INSERT_BEFORE) break;
                        --i;
                    }
                    mods.add(i + 1, mod);
                }
            }
        }
    }

    public List<ASTModification> getModificationsForNode(IASTNode node) {
        List<ASTModification> modList = this.fModifications.get(node);
        if (modList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(modList);
    }

    public Collection<IASTNode> getModifiedNodes() {
        return Collections.unmodifiableCollection(this.fModifications.keySet());
    }
}

