/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodeByImageLocation
extends ASTGenericVisitor {
    private final int fOffset;
    private final int fLength;
    private final ASTNodeSpecification<?> fNodeSpec;

    public FindNodeByImageLocation(int offset, int length, ASTNodeSpecification<?> nodeSpec) {
        super(!nodeSpec.requiresClass(IASTName.class));
        this.fNodeSpec = nodeSpec;
        this.fOffset = offset;
        this.fLength = length;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
    }

    @Override
    protected int genericVisit(IASTNode node) {
        return this.processNode(node);
    }

    private int processNode(IASTNode node) {
        if (node instanceof ASTNode) {
            IASTImageLocation imageLocation;
            ASTNode astNode = (ASTNode)node;
            if (astNode.getOffset() > this.fOffset + this.fLength || astNode.getOffset() + astNode.getLength() < this.fOffset) {
                return 1;
            }
            if (this.fNodeSpec.isAcceptableNode(astNode) && (imageLocation = astNode.getImageLocation()) != null && imageLocation.getLocationKind() == 3) {
                this.fNodeSpec.visit(astNode, imageLocation);
            }
        }
        return 3;
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        if (declaration instanceof ASTNode && ((ASTNode)((Object)declaration)).getOffset() > this.fOffset + this.fLength) {
            return 2;
        }
        return this.processNode(declaration);
    }

    @Override
    public int visit(IASTName name) {
        if (name.toString() != null) {
            return this.processNode(name);
        }
        return 3;
    }
}

