/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.parser.scanner.TokenUtil;

public class Token
implements IToken,
Cloneable {
    private int fKind;
    private int fOffset;
    private int fEndOffset;
    private IToken fNextToken;
    Object fSource;

    Token(int kind, Object source, int offset, int endOffset) {
        this.fKind = kind;
        this.fOffset = offset;
        this.fEndOffset = endOffset;
        this.fSource = source;
    }

    public final int getType() {
        return this.fKind;
    }

    public final int getOffset() {
        return this.fOffset;
    }

    public final int getEndOffset() {
        return this.fEndOffset;
    }

    public final int getLength() {
        return this.fEndOffset - this.fOffset;
    }

    public final IToken getNext() {
        return this.fNextToken;
    }

    public final void setType(int kind) {
        this.fKind = kind;
    }

    public final void setNext(IToken t) {
        this.fNextToken = t;
    }

    public void setOffset(int offset, int endOffset) {
        this.fOffset = offset;
        this.fEndOffset = endOffset;
    }

    public void shiftOffset(int shift) {
        this.fOffset += shift;
        this.fEndOffset += shift;
    }

    public char[] getCharImage() {
        return TokenUtil.getImage(this.getType());
    }

    public String toString() {
        return this.getImage();
    }

    public final boolean isOperator() {
        return TokenUtil.isOperator(this.fKind);
    }

    public String getImage() {
        return new String(this.getCharImage());
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

