/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.cdt.utils.xcoff.AR;
import org.eclipse.cdt.utils.xcoff.XCoff32;
import org.eclipse.cdt.utils.xcoff.parser.XCoffSymbol;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCOFFBinaryObject
extends BinaryObjectAdapter {
    Addr2line addr2line;
    BinaryObjectAdapter.BinaryObjectInfo info;
    IBinaryParser.ISymbol[] symbols;
    long starttime;
    private AR.MemberHeader header;
    private IAddressFactory addressFactory;

    public XCOFFBinaryObject(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    public XCOFFBinaryObject(IBinaryParser parser, IPath path, AR.MemberHeader header) {
        super(parser, path, 1);
        this.header = header;
    }

    @Override
    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            try {
                this.loadAll();
            }
            catch (IOException iOException) {
                this.symbols = this.NO_SYMBOLS;
            }
        }
        return this.symbols;
    }

    @Override
    protected BinaryObjectAdapter.BinaryObjectInfo getBinaryObjectInfo() {
        if (this.hasChanged() || this.info == null) {
            try {
                this.loadInfo();
            }
            catch (IOException iOException) {
                this.info = new BinaryObjectAdapter.BinaryObjectInfo(this);
            }
        }
        return this.info;
    }

    @Override
    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return super.getName();
    }

    @Override
    public InputStream getContents() throws IOException {
        InputStream stream = null;
        if (this.getPath() != null && this.header != null) {
            return new ByteArrayInputStream(this.header.getObjectData());
        }
        Objdump objdump = this.getObjdump();
        if (objdump != null) {
            byte[] contents = objdump.getOutput();
            stream = new ByteArrayInputStream(contents);
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    protected XCoff32 getXCoff32() throws IOException {
        if (this.header != null) {
            return new XCoff32(this.getPath().toOSString(), this.header.getObjectDataOffset());
        }
        return new XCoff32(this.getPath().toOSString());
    }

    protected void loadAll() throws IOException {
        XCoff32 xcoff = null;
        try {
            xcoff = this.getXCoff32();
            this.loadInfo(xcoff);
            this.loadSymbols(xcoff);
        }
        finally {
            if (xcoff != null) {
                xcoff.dispose();
            }
        }
    }

    protected void loadInfo() throws IOException {
        XCoff32 xcoff = null;
        try {
            xcoff = this.getXCoff32();
            this.loadInfo(xcoff);
        }
        finally {
            if (xcoff != null) {
                xcoff.dispose();
            }
        }
    }

    protected void loadInfo(XCoff32 xcoff) throws IOException {
        this.info = new BinaryObjectAdapter.BinaryObjectInfo(this);
        XCoff32.Attribute attribute = xcoff.getAttributes();
        this.info.isLittleEndian = attribute.isLittleEndian();
        this.info.hasDebug = attribute.hasDebug();
        this.info.cpu = attribute.getCPU();
    }

    protected void loadSymbols(XCoff32 xcoff) throws IOException {
        ArrayList<XCoffSymbol> list = new ArrayList<XCoffSymbol>();
        XCoff32.Symbol[] peSyms = xcoff.getSymbols();
        byte[] table = xcoff.getStringTable();
        this.addSymbols(peSyms, table, list);
        this.symbols = list.toArray(this.NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
    }

    protected void addSymbols(XCoff32.Symbol[] peSyms, byte[] table, List<XCoffSymbol> list) {
        CPPFilt cppfilt = this.getCPPFilt();
        Addr2line addr2line = this.getAddr2line(false);
        XCoff32.Symbol[] symbolArray = peSyms;
        int n = peSyms.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            XCoff32.Symbol peSym = symbolArray[n2];
            if ((peSym.isFunction() || peSym.isVariable()) && (name = peSym.getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                int type = peSym.isFunction() ? 1 : 2;
                Addr32 addr = new Addr32(peSym.n_value);
                int size = 4;
                if (cppfilt != null) {
                    try {
                        name = cppfilt.getFunction(name);
                    }
                    catch (IOException iOException) {
                        cppfilt = null;
                    }
                }
                if (addr2line != null) {
                    try {
                        String filename = addr2line.getFileName(addr);
                        if (filename != null && filename.equals("??")) {
                            filename = null;
                        }
                        Path file = filename != null ? new Path(filename) : Path.EMPTY;
                        int startLine = addr2line.getLineNumber(addr);
                        int endLine = addr2line.getLineNumber(addr.add(size - 1));
                        list.add(new XCoffSymbol(this, name, type, addr, size, (IPath)file, startLine, endLine));
                    }
                    catch (IOException iOException) {
                        addr2line = null;
                        list.add(new XCoffSymbol(this, name, type, addr, size));
                    }
                } else {
                    list.add(new XCoffSymbol(this, name, type, addr, size));
                }
            }
            ++n2;
        }
        if (cppfilt != null) {
            cppfilt.dispose();
        }
        if (addr2line != null) {
            addr2line.dispose();
        }
    }

    public Addr2line getAddr2line(boolean autodisposing) {
        if (!autodisposing) {
            return this.getAddr2line();
        }
        if (this.addr2line == null) {
            this.addr2line = this.getAddr2line();
            if (this.addr2line != null) {
                this.starttime = System.currentTimeMillis();
                Runnable worker = new Runnable(){

                    public void run() {
                        long diff = System.currentTimeMillis() - XCOFFBinaryObject.this.starttime;
                        while (diff < 10000L) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            diff = System.currentTimeMillis() - XCOFFBinaryObject.this.starttime;
                        }
                        XCOFFBinaryObject.this.stopAddr2Line();
                    }
                };
                new Thread(worker, "Addr2line Reaper").start();
            }
        } else {
            this.starttime = System.currentTimeMillis();
        }
        return this.addr2line;
    }

    synchronized void stopAddr2Line() {
        if (this.addr2line != null) {
            this.addr2line.dispose();
        }
        this.addr2line = null;
    }

    private Addr2line getAddr2line() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getAddr2line(this.getPath());
        }
        return null;
    }

    private CPPFilt getCPPFilt() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getCPPFilt();
        }
        return null;
    }

    private Objdump getObjdump() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getObjdump(this.getPath());
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Addr2line.class) {
            return this.getAddr2line();
        }
        if (adapter == CPPFilt.class) {
            return this.getCPPFilt();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IAddressFactory getAddressFactory() {
        if (this.addressFactory == null) {
            this.addressFactory = new Addr32Factory();
        }
        return this.addressFactory;
    }
}

