/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;

@Immutable
public abstract class DsfCommandRunnable
extends DsfRunnable {
    private final IRunControl.IExecutionDMContext fContext;
    private final DsfServicesTracker fTracker;
    private final IDebugCommandRequest fRequest;

    public IRunControl.IExecutionDMContext getContext() {
        return this.fContext;
    }

    public IRunControl getRunControl() {
        return (IRunControl)this.fTracker.getService(IRunControl.class);
    }

    public SteppingController getSteppingController() {
        if (this.fContext != null) {
            return (SteppingController)this.fContext.getAdapter(SteppingController.class);
        }
        return null;
    }

    public IProcesses getProcessService() {
        return (IProcesses)this.fTracker.getService(IProcesses.class);
    }

    public DsfCommandRunnable(DsfServicesTracker servicesTracker, Object element, IDebugCommandRequest request) {
        this.fTracker = servicesTracker;
        if (element instanceof IDMVMContext) {
            IDMVMContext vmc = (IDMVMContext)element;
            this.fContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IRunControl.IExecutionDMContext.class);
        } else {
            this.fContext = null;
        }
        this.fRequest = request;
    }

    public final void run() {
        if (this.fRequest.isCanceled()) {
            this.fRequest.done();
            return;
        }
        if (this.getContext() == null) {
            this.fRequest.setStatus(this.makeError("Selected object does not support run control.", null));
        } else if (this.getRunControl() == null || this.getSteppingController() == null) {
            this.fRequest.setStatus(this.makeError("Run Control not available", null));
        } else {
            this.doExecute();
        }
        this.fRequest.done();
    }

    protected abstract void doExecute();

    protected IStatus makeError(String message, Throwable e) {
        return new Status(4, "org.eclipse.cdt.dsf.ui", -1, message, e);
    }
}

