/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service.command;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.command.GDBBackendCLIProcess;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControlDMContext;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.mi.service.command.AbstractMIControl;
import org.eclipse.cdt.dsf.mi.service.command.CLIEventProcessor_7_0;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.mi.service.command.MIRunControlEventProcessor_7_0;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIListFeaturesInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBControl_7_0
extends AbstractMIControl
implements IGDBControl {
    private GDBControlDMContext fControlDmc;
    private IGDBBackend fMIBackend;
    private MIRunControlEventProcessor_7_0 fMIEventProcessor;
    private CLIEventProcessor_7_0 fCLICommandProcessor;
    private AbstractCLIProcess fCLIProcess;
    private List<String> fFeatures = new ArrayList<String>();
    private boolean fTerminated;

    public GDBControl_7_0(DsfSession session, ILaunchConfiguration config, CommandFactory factory) {
        super(session, true, factory);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleSuccess() {
                GDBControl_7_0.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fMIBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fControlDmc = new GDBControlDMContext(this.getSession().getId(), this.getId());
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new CommandMonitoringStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandProcessorsStep(InitializationShutdownStep.Direction.INITIALIZING), new ListFeaturesStep(InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new ListFeaturesStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandProcessorsStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandMonitoringStep(InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                GDBControl_7_0.super.shutdown(requestMonitor);
            }
        }){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    public String getId() {
        return this.fMIBackend.getId();
    }

    @Override
    public MIControlDMContext getControlDMContext() {
        return this.fControlDmc;
    }

    public ICommandControlService.ICommandControlDMContext getContext() {
        return this.fControlDmc;
    }

    @Override
    public void terminate(final RequestMonitor rm) {
        if (this.fTerminated) {
            rm.done();
            return;
        }
        this.fTerminated = true;
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && !runControl.isTargetAcceptingCommands()) {
            this.fMIBackend.interrupt();
        }
        final ScheduledFuture forceQuitTask = this.getExecutor().schedule((Runnable)new DsfRunnable(){

            public void run() {
                GDBControl_7_0.this.fMIBackend.destroy();
                rm.done();
            }

            protected boolean isExecutionRequired() {
                return false;
            }
        }, 2L, TimeUnit.SECONDS);
        this.queueCommand(this.getCommandFactory().createMIGDBExit(this.fControlDmc), new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleCompleted() {
                if (this.isSuccess()) {
                    forceQuitTask.cancel(false);
                    rm.done();
                }
            }
        });
    }

    private void listFeatures(RequestMonitor requestMonitor) {
        this.queueCommand(this.getCommandFactory().createMIListFeatures(this.fControlDmc), new DataRequestMonitor<MIListFeaturesInfo>((Executor)this.getExecutor(), requestMonitor){

            public void handleSuccess() {
                GDBControl_7_0.this.fFeatures = ((MIListFeaturesInfo)this.getData()).getFeatures();
                super.handleSuccess();
            }
        });
    }

    @Override
    public AbstractCLIProcess getCLIProcess() {
        return this.fCLIProcess;
    }

    @Override
    public void setTracingStream(OutputStream tracingStream) {
        this.setMITracingStream(tracingStream);
    }

    @Override
    public void setEnvironment(Properties props, boolean clear, RequestMonitor rm) {
        int count = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        if (clear) {
            ++count;
            this.queueCommand(this.getCommandFactory().createCLIUnsetEnv(this.getContext()), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            ++count;
            String name = (String)property.getKey();
            String value = (String)property.getValue();
            this.queueCommand(this.getCommandFactory().createMIGDBSetEnv(this.getContext(), name, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        countingRm.setDoneCount(count);
    }

    @Override
    public void completeInitialization(final RequestMonitor rm) {
        ILaunch launch = (ILaunch)this.getSession().getModelAdapter(ILaunch.class);
        Map attributes = null;
        try {
            attributes = launch.getLaunchConfiguration().getAttributes();
        }
        catch (CoreException coreException) {}
        RequestMonitorWithProgress progressRm = rm instanceof RequestMonitorWithProgress ? (RequestMonitorWithProgress)rm : new RequestMonitorWithProgress((Executor)this.getExecutor(), (IProgressMonitor)new NullProgressMonitor()){

            protected void handleCompleted() {
                rm.setStatus(this.getStatus());
                rm.done();
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)this.getCompleteInitializationSequence(attributes, progressRm));
    }

    protected Sequence getCompleteInitializationSequence(Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        return new FinalLaunchSequence(this.getSession(), attributes, rm);
    }

    @Override
    public List<String> getFeatures() {
        return this.fFeatures;
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.stopCommandProcessing();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIBackend.BackendStateChangedEvent e) {
        if (e.getState() == IMIBackend.State.TERMINATED && e.getBackendId().equals(this.fMIBackend.getId())) {
            this.getSession().dispatchEvent((Object)new GDBControlShutdownDMEvent(this.fControlDmc), this.getProperties());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
    }

    @Override
    public void enablePrettyPrintingForMIVariableObjects(RequestMonitor rm) {
        this.queueCommand(this.getCommandFactory().createMIEnablePrettyPrinting(this.fControlDmc), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public void setPrintPythonErrors(boolean enabled, RequestMonitor rm) {
        String gdbVersion;
        IDsfDebugServicesFactory factory;
        ILaunch launch = (ILaunch)this.getSession().getModelAdapter(ILaunch.class);
        if (launch instanceof GdbLaunch && (factory = ((GdbLaunch)launch).getServiceFactory()) instanceof GdbDebugServicesFactory && "7.3.50".compareTo(gdbVersion = ((GdbDebugServicesFactory)factory).getVersion()) <= 0) {
            rm.done();
            return;
        }
        String subCommand = "set python print-stack " + (enabled ? "on" : "off");
        this.queueCommand(this.getCommandFactory().createCLIMaintenance(this.fControlDmc, subCommand), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    protected class CommandMonitoringStep
    extends InitializationShutdownStep {
        CommandMonitoringStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        protected void initialize(RequestMonitor requestMonitor) {
            GDBControl_7_0.this.startCommandProcessing(GDBControl_7_0.this.fMIBackend.getMIInputStream(), GDBControl_7_0.this.fMIBackend.getMIOutputStream());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl_7_0.this.stopCommandProcessing();
            requestMonitor.done();
        }
    }

    protected class CommandProcessorsStep
    extends InitializationShutdownStep {
        CommandProcessorsStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            try {
                GDBControl_7_0.this.fCLIProcess = new GDBBackendCLIProcess(GDBControl_7_0.this, GDBControl_7_0.this.fMIBackend);
            }
            catch (IOException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Failed to create CLI Process", (Throwable)e));
                requestMonitor.done();
                return;
            }
            GDBControl_7_0.this.fCLICommandProcessor = new CLIEventProcessor_7_0(GDBControl_7_0.this, GDBControl_7_0.this.fControlDmc);
            GDBControl_7_0.this.fMIEventProcessor = new MIRunControlEventProcessor_7_0(GDBControl_7_0.this, GDBControl_7_0.this.fControlDmc);
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl_7_0.this.fCLICommandProcessor.dispose();
            GDBControl_7_0.this.fMIEventProcessor.dispose();
            GDBControl_7_0.this.fCLIProcess.dispose();
            requestMonitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GDBControlInitializedDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlInitializedDMEvent {
        public GDBControlInitializedDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GDBControlShutdownDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlShutdownDMEvent {
        public GDBControlShutdownDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class InitializationShutdownStep
    extends Sequence.Step {
        private Direction fDirection;

        public InitializationShutdownStep(Direction direction) {
            this.fDirection = direction;
        }

        public final void execute(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.initialize(requestMonitor);
            } else {
                this.shutdown(requestMonitor);
            }
        }

        public final void rollBack(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.shutdown(requestMonitor);
            } else {
                super.rollBack(requestMonitor);
            }
        }

        protected void initialize(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            INITIALIZING,
            SHUTTING_DOWN;

        }
    }

    protected class ListFeaturesStep
    extends InitializationShutdownStep {
        ListFeaturesStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        protected void initialize(RequestMonitor requestMonitor) {
            GDBControl_7_0.this.listFeatures(requestMonitor);
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }
    }

    protected class RegisterStep
    extends InitializationShutdownStep {
        RegisterStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            GDBControl_7_0.this.getSession().addServiceEventListener((Object)GDBControl_7_0.this, null);
            GDBControl_7_0.this.register(new String[]{ICommandControl.class.getName(), ICommandControlService.class.getName(), IMICommandControl.class.getName(), AbstractMIControl.class.getName(), IGDBControl.class.getName()}, new Hashtable());
            GDBControl_7_0.this.getSession().dispatchEvent((Object)new GDBControlInitializedDMEvent(GDBControl_7_0.this.fControlDmc), GDBControl_7_0.this.getProperties());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl_7_0.this.unregister();
            GDBControl_7_0.this.getSession().removeServiceEventListener((Object)GDBControl_7_0.this);
            requestMonitor.done();
        }
    }
}

