/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIncludesOperation
implements IWorkspaceRunnable {
    private final ITranslationUnit fTranslationUnit;
    private final int fBeforeOffset;
    private final IRequiredInclude[] fIncludes;
    private final String[] fUsings;
    private String fNewLine;
    private IBuffer fBuffer;
    private List<ICElement> fExistingIncludes;
    private List<ICElement> fExistingUsings;
    private InsertEdit fIncludesInsert;
    private InsertEdit fUsingsInsert;
    private int fIncludesPos = -1;

    public AddIncludesOperation(ITranslationUnit tu, int beforeOffset, IRequiredInclude[] includes, String[] usings) {
        this.fTranslationUnit = tu;
        this.fBeforeOffset = beforeOffset;
        this.fIncludes = includes;
        this.fUsings = usings;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(CEditorMessages.AddIncludesOperation_description, 3);
            this.fBuffer = this.fTranslationUnit.getBuffer();
            this.fNewLine = this.getLineSeparator();
            this.fExistingIncludes = this.fTranslationUnit.getChildrenOfType(75);
            this.fIncludesInsert = this.getIncludesInsert();
            monitor.worked(1);
            if (this.fUsings != null && this.fUsings.length > 0) {
                this.fExistingUsings = this.fTranslationUnit.getChildrenOfType(62);
            }
            this.fUsingsInsert = this.getUsingsInsert();
            monitor.worked(1);
            if (this.fIncludesInsert != null) {
                this.fBuffer.replace(this.fIncludesInsert.getOffset(), 0, this.fIncludesInsert.getText());
            }
            if (this.fUsingsInsert != null) {
                int offset = this.fUsingsInsert.getOffset();
                if (this.fIncludesInsert != null && offset >= this.fIncludesInsert.getOffset()) {
                    offset += this.fIncludesInsert.getText().length();
                }
                this.fBuffer.replace(offset, 0, this.fUsingsInsert.getText());
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private InsertEdit getIncludesInsert() throws CoreException {
        if (this.fIncludes == null || this.fIncludes.length == 0) {
            return null;
        }
        ArrayList<IRequiredInclude> toAdd = new ArrayList<IRequiredInclude>();
        IRequiredInclude[] iRequiredIncludeArray = this.fIncludes;
        int n = this.fIncludes.length;
        int n2 = 0;
        while (n2 < n) {
            IRequiredInclude include = iRequiredIncludeArray[n2];
            String name = include.getIncludeName();
            boolean found = false;
            for (ICElement element : this.fExistingIncludes) {
                ISourceRange range = ((ISourceReference)element).getSourceRange();
                if (range.getStartPos() + range.getLength() > this.fBeforeOffset) break;
                if (!name.equals(element.getElementName())) continue;
                found = true;
                break;
            }
            if (!found) {
                toAdd.add(include);
            }
            ++n2;
        }
        if (toAdd.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (IRequiredInclude include : toAdd) {
            if (include.isStandard()) {
                buf.append("#include <" + include.getIncludeName() + ">").append(this.fNewLine);
                continue;
            }
            buf.append("#include \"" + include.getIncludeName() + "\"").append(this.fNewLine);
        }
        int pos = this.getIncludeInsertionPosition();
        return new InsertEdit(pos, buf.toString());
    }

    private int getIncludeInsertionPosition() throws CModelException {
        if (this.fIncludesPos < 0) {
            this.fIncludesPos = this.fExistingIncludes.isEmpty() ? this.getOffsetAfterLeadingMacroDefinitions() : this.getOffsetAfterLast(this.fExistingIncludes);
        }
        return this.fIncludesPos;
    }

    private InsertEdit getUsingsInsert() throws CoreException {
        int pos2;
        if (this.fUsings == null || this.fUsings.length == 0) {
            return null;
        }
        ArrayList<String> toAdd = new ArrayList<String>(this.fUsings.length);
        String[] stringArray = this.fUsings;
        int n = this.fUsings.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            boolean found = false;
            for (ICElement element : this.fExistingUsings) {
                ISourceRange range = ((ISourceReference)element).getSourceRange();
                if (range.getStartPos() + range.getLength() > this.fBeforeOffset) break;
                if (!name.equals(element.getElementName())) continue;
                found = true;
                break;
            }
            if (!found) {
                toAdd.add(name);
            }
            ++n2;
        }
        if (toAdd.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (String using : toAdd) {
            buf.append("using ").append(using).append(';').append(this.fNewLine);
        }
        int pos = this.getOffsetAfterLast(this.fExistingUsings);
        if (pos <= (pos2 = this.getIncludeInsertionPosition())) {
            pos = pos2;
            buf.insert(0, this.fNewLine);
        }
        return new InsertEdit(pos, buf.toString());
    }

    private int getOffsetAfterLast(List<ICElement> elements) throws CModelException {
        int i = elements.size();
        while (--i >= 0) {
            ISourceRange range = ((ISourceReference)elements.get(i)).getSourceRange();
            int end = range.getStartPos() + range.getLength();
            if (end > this.fBeforeOffset) continue;
            return this.findNewLine(range.getStartPos() + range.getLength());
        }
        return 0;
    }

    private int getOffsetAfterLeadingMacroDefinitions() throws CModelException {
        ISourceRange found = null;
        ICElement[] iCElementArray = this.fTranslationUnit.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceRange range;
            ISourceReference sourceRef;
            ICElement child = iCElementArray[n2];
            if (!(child instanceof IMacro) || !(child instanceof ISourceReference) || !(sourceRef = (ISourceReference)child).isActive() || (range = sourceRef.getSourceRange()).getStartPos() + range.getLength() > this.fBeforeOffset) break;
            found = range;
            ++n2;
        }
        if (found != null) {
            return this.findNewLine(found.getStartPos() + found.getLength());
        }
        return 0;
    }

    private int findNewLine(int pos) {
        while (this.fBuffer.getChar(pos) != '\n') {
            ++pos;
        }
        if (this.fBuffer.getChar(pos) == '\r') {
            ++pos;
        }
        return pos + 1;
    }

    private String getLineSeparator() {
        try {
            String delim;
            IDocument doc;
            if (this.fBuffer instanceof IAdaptable && (doc = (IDocument)((IAdaptable)this.fBuffer).getAdapter(IDocument.class)) != null && (delim = doc.getLineDelimiter(0)) != null) {
                return delim;
            }
        }
        catch (BadLocationException badLocationException) {}
        return System.getProperty("line.separator", "\n");
    }
}

