/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.internal.ui.callhierarchy.CHViewPart;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CHHistoryListAction
extends Action {
    private CHViewPart fView;

    public CHHistoryListAction(CHViewPart view) {
        this.fView = view;
        this.setText(CHMessages.CHHistoryListAction_OpenHistory_label);
    }

    public void run() {
        ICElement[] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(this.fView.getSite().getShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            this.fView.setInput(dialog.getResult());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField<ICElement> fHistoryList;
        private IStatus fHistoryStatus;
        private ICElement fResult;

        private HistoryListDialog(Shell shell, ICElement[] historyEntries) {
            super(shell);
            this.setHelpAvailable(false);
            this.setTitle(CHMessages.CHHistoryListAction_HistoryDialog_title);
            String[] buttonLabels = new String[]{CHMessages.CHHistoryListAction_Remove_label};
            IListAdapter<ICElement> adapter = new IListAdapter<ICElement>(){

                @Override
                public void customButtonPressed(ListDialogField<ICElement> field, int index) {
                    HistoryListDialog.this.doCustomButtonPressed();
                }

                @Override
                public void selectionChanged(ListDialogField<ICElement> field) {
                    HistoryListDialog.this.doSelectionChanged();
                }

                @Override
                public void doubleClicked(ListDialogField<ICElement> field) {
                    HistoryListDialog.this.doDoubleClicked();
                }
            };
            CUILabelProvider labelProvider = new CUILabelProvider(2182113313L, 1);
            this.fHistoryList = new ListDialogField<ICElement>(adapter, buttonLabels, (IBaseLabelProvider)labelProvider);
            this.fHistoryList.setLabelText(CHMessages.CHHistoryListAction_HistoryList_label);
            this.fHistoryList.setElements(Arrays.asList(historyEntries));
            StructuredSelection sel = historyEntries.length > 0 ? new StructuredSelection((Object)historyEntries[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setFont(parent.getFont());
            inner.setLayoutData((Object)new GridData(1808));
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null), true);
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        private void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        private void doSelectionChanged() {
            StatusInfo status = new StatusInfo();
            List<ICElement> selected = this.fHistoryList.getSelectedElements();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = selected.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > selected.size() && selected.size() != 0);
            this.fHistoryStatus = status;
            this.updateStatus(status);
        }

        public ICElement getResult() {
            return this.fResult;
        }

        public ICElement[] getRemaining() {
            List<ICElement> elems = this.fHistoryList.getElements();
            return elems.toArray(new ICElement[elems.size()]);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }
    }
}

