/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.NameAndVisibilityComposite;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ChooserComposite;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInputPage;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExtractFunctionComposite
extends Composite {
    private Button replaceSimilar;
    private ChooserComposite comp;
    private NameAndVisibilityComposite nameVisiComp;
    private final ExtractFunctionInformation info;

    public ExtractFunctionComposite(Composite parent, ExtractFunctionInformation info, ExtractFunctionInputPage ip) {
        super(parent, 0);
        this.info = info;
        this.setLayout((Layout)new GridLayout());
        this.createNewMethodNameComposite(this);
        Group returnGroup = this.createReturnGroup(this.nameVisiComp);
        this.createReturnValueChooser((Composite)returnGroup, info, ip);
        this.createReplaceCheckBox(this.nameVisiComp);
        if (info.getMethodContext().getType() == MethodContext.ContextType.METHOD) {
            this.visibilityPanelSetVisible(true);
        } else {
            this.visibilityPanelSetVisible(false);
        }
        this.layout();
    }

    private Group createReturnGroup(Composite parent) {
        Group returnGroup = new Group(parent, 0);
        returnGroup.setText(Messages.ExtractFunctionComposite_ReturnValue);
        returnGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        returnGroup.setLayoutData((Object)gridData);
        return returnGroup;
    }

    private void createReturnValueChooser(Composite parent, ExtractFunctionInformation info, ExtractFunctionInputPage ip) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comp = new ChooserComposite(parent, info, ip);
        this.comp.setLayoutData(gridData);
        this.comp.redraw();
    }

    public Text getMethodNameText() {
        return this.nameVisiComp.getConstantNameText();
    }

    public Button getReplaceSimilarButton() {
        return this.replaceSimilar;
    }

    public void visibilityPanelSetVisible(boolean visible) {
        this.nameVisiComp.visibilityPanelsetVisible(visible);
    }

    private void createNewMethodNameComposite(Composite parent) {
        String label = this.info.getMethodContext().getType() == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionComposite_MethodName : Messages.ExtractFunctionComposite_FunctionName;
        this.nameVisiComp = new NameAndVisibilityComposite(parent, label, VisibilityEnum.v_private, "");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameVisiComp.setLayoutData(gridData);
        final Button virtual = new Button((Composite)this.nameVisiComp, 32);
        virtual.setText(Messages.ExtractFunctionComposite_Virtual);
        virtual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractFunctionComposite.this.info.setVirtual(virtual.getSelection());
            }
        });
    }

    private void createReplaceCheckBox(Composite parent) {
        this.replaceSimilar = new Button(parent, 16416);
        GridData buttonLayoutData = new GridData(0);
        buttonLayoutData.verticalIndent = 5;
        this.replaceSimilar.setLayoutData((Object)buttonLayoutData);
        this.replaceSimilar.setText(Messages.ExtractFunctionComposite_ReplaceDuplicates);
    }

    public ChooserComposite getReturnChooser() {
        return this.comp;
    }

    public String getMethodName() {
        return this.nameVisiComp.getConstantNameText().getText();
    }

    public Composite getVisibiltyGroup() {
        return this.nameVisiComp.getVisibiltyGroup();
    }
}

