/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringASTCache;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionFinder {
    public static IASTName getDefinition(IASTSimpleDeclaration simpleDeclaration, RefactoringASTCache astCache, IProgressMonitor pm) throws CoreException {
        IIndex index = astCache.getIndex();
        IASTDeclarator declarator = simpleDeclaration.getDeclarators()[0];
        if (index == null) {
            return null;
        }
        IIndexBinding binding = index.adaptBinding(declarator.getName().resolveBinding());
        if (binding == null) {
            return null;
        }
        return DefinitionFinder.getDefinition(binding, astCache, index, pm);
    }

    private static IASTName getDefinition(IIndexBinding binding, RefactoringASTCache astCache, IIndex index, IProgressMonitor pm) throws CoreException {
        IIndexName[] definitionsFromIndex;
        ITranslationUnit tu;
        IEditorPart[] dirtyEditors;
        HashSet<String> searchedFiles = new HashSet<String>();
        ArrayList<IASTName> definitions = new ArrayList<IASTName>();
        IEditorPart[] iEditorPartArray = dirtyEditors = EditorUtility.getDirtyEditors(true);
        int n = dirtyEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor = iEditorPartArray[n2];
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof ITranslationUnitEditorInput) {
                tu = CModelUtil.toWorkingCopy(((ITranslationUnitEditorInput)editorInput).getTranslationUnit());
                DefinitionFinder.findDefinitionsInTranslationUnit(binding, tu, astCache, definitions, null);
                searchedFiles.add(tu.getLocation().toOSString());
            }
            ++n2;
        }
        IIndexName[] iIndexNameArray = definitionsFromIndex = index.findDefinitions((IBinding)binding);
        int n3 = definitionsFromIndex.length;
        n = 0;
        while (n < n3) {
            IIndexName name = iIndexNameArray[n];
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            tu = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)name.getFile().getLocation(), null);
            if (searchedFiles.add(tu.getLocation().toOSString())) {
                DefinitionFinder.findDefinitionsInTranslationUnit(binding, tu, astCache, definitions, pm);
            }
            ++n;
        }
        return definitions.size() == 1 ? (IASTName)definitions.get(0) : null;
    }

    private static void findDefinitionsInTranslationUnit(IIndexBinding binding, ITranslationUnit tu, RefactoringASTCache astCache, List<IASTName> definitions, IProgressMonitor pm) throws OperationCanceledException, CoreException {
        IASTTranslationUnit ast = astCache.getAST(tu, pm);
        DefinitionFinder.findDefinitionsInAST(binding, ast, tu, definitions);
    }

    private static void findDefinitionsInAST(IIndexBinding binding, IASTTranslationUnit ast, ITranslationUnit tu, List<IASTName> definitions) {
        IName[] iNameArray = ast.getDefinitions((IBinding)binding);
        int n = iNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IName definition = iNameArray[n2];
            if (definition instanceof IASTName) {
                definitions.add((IASTName)definition);
            }
            ++n2;
        }
    }
}

