/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.cdt.internal.ui.util.Messages;

public class OccurrencesFinder
implements IOccurrencesFinder {
    public static final String ID = "OccurrencesFinder";
    public static final int OPTION_EXCLUDE_IMPLICIT_REFERENCES = 1;
    private IASTTranslationUnit fRoot;
    private IASTName fSelectedNode;
    private IBinding fTarget;
    private List<IOccurrencesFinder.OccurrenceLocation> fResult;
    private String fReadDescription;
    private String fWriteDescription;
    private int fOptions;

    public String initialize(IASTTranslationUnit root, IASTNode node) {
        if (!(node instanceof IASTName)) {
            return CSearchMessages.OccurrencesFinder_no_element;
        }
        this.fRoot = root;
        this.fSelectedNode = (IASTName)node;
        this.fTarget = this.fSelectedNode.resolveBinding();
        if (this.fTarget == null) {
            return CSearchMessages.OccurrencesFinder_no_binding;
        }
        this.fReadDescription = Messages.format(CSearchMessages.OccurrencesFinder_occurrence_description, this.fTarget.getName());
        this.fWriteDescription = Messages.format(CSearchMessages.OccurrencesFinder_occurrence_write_description, this.fTarget.getName());
        return null;
    }

    public void setOptions(int options) {
        this.fOptions = options;
    }

    private void performSearch() {
        if (this.fResult == null) {
            IASTName candidate;
            IASTName[] names;
            this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
            IASTName[] iASTNameArray = names = this.fRoot.getDeclarationsInAST(this.fTarget);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                candidate = iASTNameArray[n2];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addUsage(candidate, candidate.resolveBinding());
                }
                ++n2;
            }
            iASTNameArray = names = this.fRoot.getReferences(this.fTarget);
            n = names.length;
            n2 = 0;
            while (n2 < n) {
                candidate = iASTNameArray[n2];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addUsage(candidate, candidate.resolveBinding());
                }
                ++n2;
            }
            if (this.needImplicitReferences() && this.canHaveImplicitReference(this.fTarget)) {
                iASTNameArray = names = CPPVisitor.getImplicitReferences((IASTTranslationUnit)this.fRoot, (IBinding)this.fTarget);
                n = names.length;
                n2 = 0;
                while (n2 < n) {
                    candidate = iASTNameArray[n2];
                    if (candidate.isPartOfTranslationUnitFile()) {
                        this.addUsage(candidate, candidate.resolveBinding());
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean needImplicitReferences() {
        return (this.fOptions & 1) == 0;
    }

    private boolean canHaveImplicitReference(IBinding binding) {
        char[] op = Keywords.cOPERATOR;
        char[] nameCharArray = binding.getNameCharArray();
        if (nameCharArray.length > 0) {
            if (nameCharArray[0] == '~') {
                return true;
            }
            if (CharArrayUtils.equals((char[])nameCharArray, (int)0, (int)op.length, (char[])op)) {
                return true;
            }
        }
        return binding instanceof ICPPConstructor;
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.performSearch();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    public IASTTranslationUnit getASTRoot() {
        return this.fRoot;
    }

    public String getJobLabel() {
        return CSearchMessages.OccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedNode != null) {
            return new String(this.fSelectedNode.toCharArray());
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return CSearchMessages.OccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return CSearchMessages.OccurrencesFinder_label_singular;
    }

    private boolean addUsage(IASTName node, IBinding binding) {
        if (binding != null) {
            IASTImageLocation fileLocation;
            if (node instanceof ICPPASTTemplateId) {
                node = ((ICPPASTTemplateId)node).getTemplateName();
            }
            if ((fileLocation = node.getImageLocation()) == null || !this.fRoot.getFilePath().equals(fileLocation.getFileName())) {
                fileLocation = node.getFileLocation();
            }
            if (fileLocation != null) {
                int offset = fileLocation.getNodeOffset();
                int length = fileLocation.getNodeLength();
                if (offset >= 0 && length > 0) {
                    if (binding instanceof IVariable) {
                        boolean isWriteOccurrence = CSearchUtil.isWriteOccurrence(node, binding);
                        int flag = isWriteOccurrence ? 1 : 2;
                        String description = isWriteOccurrence ? this.fWriteDescription : this.fReadDescription;
                        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, length, flag, description));
                    } else {
                        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, length, 2, this.fWriteDescription));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public int getSearchKind() {
        return 5;
    }

    public String getID() {
        return ID;
    }
}

