/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElement;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.cdt.internal.ui.search.PDOMSearchViewPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class PDOMSearchTreeContentProvider
implements ITreeContentProvider,
IPDOMSearchContentProvider {
    private TreeViewer viewer;
    private PDOMSearchResult result;
    private Map<Object, Set<Object>> tree = new HashMap<Object, Set<Object>>();
    private final PDOMSearchViewPage fPage;

    PDOMSearchTreeContentProvider(PDOMSearchViewPage page) {
        this.fPage = page;
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.tree.get(parentElement);
        if (children == null) {
            return new Object[0];
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        for (Object parent : this.tree.keySet()) {
            Set<Object> children = this.tree.get(parent);
            if (!children.contains(element)) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.tree.get(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.result = (PDOMSearchResult)((Object)newInput);
        this.initialize(this.result);
        viewer.refresh();
    }

    private void insertUnindexedProjectWarningElement(ICProject project) {
        this.insertCElement((ICElement)project);
        this.insertChild(project, new Status(2, "org.eclipse.cdt.ui", CSearchMessages.PDOMSearchTreeContentProvider_IndexerNotEnabledWarning));
    }

    private void insertClosedProjectWarningElement(ICProject project) {
        this.insertCElement((ICElement)project);
        this.insertChild(project, new Status(2, "org.eclipse.cdt.ui", CSearchMessages.PDOMSearchTreeContentProvider_ProjectClosedWarning));
    }

    private boolean insertChild(Object parent, Object child) {
        Set<Object> children = this.tree.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.tree.put(parent, children);
        }
        return children.add(child);
    }

    private void insertSearchElement(PDOMSearchElement element) {
        IFile[] files;
        IIndexFileLocation location = element.getLocation();
        if (location.getFullPath() != null) {
            files = new IFile[]{ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location.getFullPath()))};
        } else {
            IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)element.getLocation());
            files = ResourceLookup.findFilesForLocation((IPath)path);
        }
        boolean handled = false;
        if (files.length > 0) {
            int j = 0;
            while (j < files.length) {
                ICElement celement = CoreModel.getDefault().create(files[j]);
                if (celement != null) {
                    this.insertChild(celement, element);
                    this.insertCElement(celement);
                    handled = true;
                }
                ++j;
            }
        }
        if (!handled) {
            IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)location);
            if (path != null) {
                IPath directory = path.removeLastSegments(1);
                this.insertChild(location, element);
                this.insertChild(directory, location);
                this.insertChild((Object)this.result, directory);
            } else {
                this.insertChild(IPDOMSearchContentProvider.URI_CONTAINER, location.getURI());
                this.insertChild((Object)this.result, IPDOMSearchContentProvider.URI_CONTAINER);
            }
        }
    }

    private void insertCElement(ICElement element) {
        if (element instanceof ICProject) {
            this.insertChild((Object)this.result, element);
        } else {
            ICElement parent = element.getParent();
            if (parent instanceof ISourceRoot && parent.getUnderlyingResource() instanceof IProject) {
                parent = parent.getParent();
            }
            this.insertChild(parent, element);
            this.insertCElement(parent);
        }
    }

    public void elementsChanged(Object[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                PDOMSearchElement element = (PDOMSearchElement)elements[i];
                if (this.fPage.getDisplayedMatchCount(element) > 0) {
                    this.insertSearchElement(element);
                } else {
                    boolean remove = true;
                    if (element instanceof ICProject) {
                        ICProject cProject = (ICProject)element;
                        boolean bl = remove = !this.addProjectWarningIfApplicable(cProject);
                    }
                    if (remove) {
                        this.remove(element);
                    }
                }
                ++i;
            }
        }
        if (!this.viewer.getTree().isDisposed()) {
            this.viewer.refresh();
        }
    }

    private boolean addProjectWarningIfApplicable(ICProject cProject) {
        if (cProject.getProject().isOpen()) {
            if (!CCorePlugin.getIndexManager().isProjectIndexed(cProject)) {
                this.insertUnindexedProjectWarningElement(cProject);
                return true;
            }
        } else {
            this.insertClosedProjectWarningElement(cProject);
            return true;
        }
        return false;
    }

    public void clear() {
        this.initialize(this.result);
    }

    private void initialize(PDOMSearchResult result) {
        this.result = result;
        this.tree.clear();
        if (result != null) {
            if (result.wasIndexerBusy()) {
                this.insertChild((Object)result, IPDOMSearchContentProvider.INCOMPLETE_RESULTS_NODE);
            }
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                PDOMSearchElement element = (PDOMSearchElement)elements[i];
                if (this.fPage.getDisplayedMatchCount(element) > 0) {
                    this.insertSearchElement(element);
                }
                ++i;
            }
            ICProject[] projects = ((PDOMSearchQuery)result.getQuery()).getProjects();
            int i2 = 0;
            while (i2 < projects.length) {
                ICProject project = projects[i2];
                Set<Object> projectResults = this.tree.get(project);
                if (projectResults == null) {
                    this.addProjectWarningIfApplicable(project);
                }
                ++i2;
            }
        }
    }

    protected void remove(Object element) {
        Object parent = this.getParent(element);
        if (parent == null) {
            return;
        }
        Set<Object> siblings = this.tree.get(parent);
        siblings.remove(element);
        if (siblings.isEmpty()) {
            this.remove(parent);
            this.tree.remove(parent);
        }
    }
}

