/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.CombinedWordRule;
import org.eclipse.cdt.ui.IPropertyChangeParticipant;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class TaskTagRule
extends CombinedWordRule
implements IPropertyChangeParticipant {
    private static final String TODO_TASK_TAGS = "org.eclipse.cdt.core.taskTags";
    private static final String TODO_TASK_CASE_SENSITIVE = "org.eclipse.cdt.core.taskCaseSensitive";
    private TaskTagMatcher fMatcher;

    public TaskTagRule(IToken token, IToken defaultToken, IPreferenceStore preferenceStore, IPreferenceStore corePreferenceStore) {
        super((IWordDetector)new TaskTagDetector(), defaultToken);
        this.fMatcher = new TaskTagMatcher(token);
        this.addWordMatcher(this.fMatcher);
        String taskWords = null;
        if (preferenceStore.contains(TODO_TASK_TAGS)) {
            taskWords = preferenceStore.getString(TODO_TASK_TAGS);
        } else if (corePreferenceStore != null) {
            taskWords = corePreferenceStore.getString(TODO_TASK_TAGS);
        }
        if (taskWords != null) {
            this.addTaskTags(taskWords);
        }
        boolean isCaseSensitive = true;
        if (preferenceStore.contains(TODO_TASK_CASE_SENSITIVE)) {
            isCaseSensitive = preferenceStore.getBoolean(TODO_TASK_CASE_SENSITIVE);
        } else if (corePreferenceStore != null) {
            isCaseSensitive = corePreferenceStore.getBoolean(TODO_TASK_CASE_SENSITIVE);
        }
        this.fMatcher.setCaseSensitive(isCaseSensitive);
    }

    public void clearTaskTags() {
        this.fMatcher.clearWords();
    }

    public void addTaskTags(String value) {
        this.fMatcher.addTaskTags(value);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(TODO_TASK_TAGS) || event.getProperty().equals(TODO_TASK_CASE_SENSITIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        Object value;
        if (event.getProperty().equals(TODO_TASK_TAGS)) {
            Object value2 = event.getNewValue();
            if (value2 instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fMatcher;
                synchronized (taskTagMatcher) {
                    this.fMatcher.clearWords();
                    this.fMatcher.addTaskTags((String)value2);
                }
            }
        } else if (event.getProperty().equals(TODO_TASK_CASE_SENSITIVE) && (value = event.getNewValue()) instanceof String) {
            this.fMatcher.setCaseSensitive(Boolean.parseBoolean((String)value));
        }
    }

    private static class TaskTagDetector
    implements IWordDetector {
        private TaskTagDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@' || c == '\\' || Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return c == '.' || Character.isJavaIdentifierPart(c);
        }
    }

    private class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map<CombinedWordRule.CharacterBuffer, IToken> fUppercaseWords = new HashMap<CombinedWordRule.CharacterBuffer, IToken>();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken token) {
            this.fToken = token;
        }

        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String value) {
            String[] taskTags;
            String[] stringArray = taskTags = value.split(",");
            int n = taskTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (tag.length() > 0) {
                    this.addWord(tag, this.fToken);
                }
                ++n2;
            }
        }

        public synchronized void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            super.addWord(word, token);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(word.toUpperCase()), token);
        }

        public synchronized IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            if (this.fCaseSensitive) {
                return super.evaluate(scanner, word);
            }
            this.fBuffer.clear();
            int i = 0;
            int n = word.length();
            while (i < n) {
                this.fBuffer.append(Character.toUpperCase(word.charAt(i)));
                ++i;
            }
            IToken token = this.fUppercaseWords.get(this.fBuffer);
            if (token != null) {
                return token;
            }
            return Token.UNDEFINED;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.fCaseSensitive = caseSensitive;
        }
    }
}

