/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction.proposals;

import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CUIStatus;
import org.eclipse.cdt.internal.ui.text.correction.proposals.TUCorrectionProposal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;

public class ASTRewriteCorrectionProposal
extends TUCorrectionProposal {
    private ASTRewrite fRewrite;

    public ASTRewriteCorrectionProposal(String name, ITranslationUnit tu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, tu, relevance, image);
        this.fRewrite = rewrite;
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                Change change = rewrite.rewriteAST();
                this.addTextEdits(change, editRoot);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(CUIStatus.createError(4, e));
            }
        }
    }

    private void addTextEdits(Change change, TextEdit editRoot) {
        if (change instanceof TextChange) {
            editRoot.addChild(((TextChange)change).getEdit());
        } else if (change instanceof CompositeChange) {
            Change[] changeArray = ((CompositeChange)change).getChildren();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change c = changeArray[n2];
                this.addTextEdits(c, editRoot);
                ++n2;
            }
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus status = CUIStatus.createError(4, "Rewriter not initialized", null);
            throw new CoreException(status);
        }
        return this.fRewrite;
    }
}

