/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ColoredViewersManager
implements IPropertyChangeListener {
    public static final String INHERITED_COLOR_NAME = "org.eclipse.cdt.ui.ColoredLabels.inherited";
    public static final String HIGHLIGHT_BG_COLOR_NAME = "org.eclipse.cdt.ui.ColoredLabels.match_highlight";
    public static final String HIGHLIGHT_WRITE_BG_COLOR_NAME = "org.eclipse.cdt.ui.ColoredLabels.writeaccess_highlight";
    private static ColoredViewersManager fgInstance = new ColoredViewersManager();
    private Set<ColoringLabelProvider> fManagedLabelProviders = new HashSet<ColoringLabelProvider>();

    public void installColoredLabels(ColoringLabelProvider labelProvider) {
        if (this.fManagedLabelProviders.contains((Object)labelProvider)) {
            return;
        }
        if (this.fManagedLabelProviders.isEmpty()) {
            PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        }
        this.fManagedLabelProviders.add(labelProvider);
    }

    public void uninstallColoredLabels(ColoringLabelProvider labelProvider) {
        if (!this.fManagedLabelProviders.remove((Object)labelProvider)) {
            return;
        }
        if (this.fManagedLabelProviders.isEmpty()) {
            PlatformUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("QUALIFIER_COLOR") || property.equals("COUNTER_COLOR") || property.equals("DECORATIONS_COLOR") || property.equals(HIGHLIGHT_BG_COLOR_NAME) || property.equals("USE_COLORED_LABELS") || property.equals(HIGHLIGHT_WRITE_BG_COLOR_NAME)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ColoredViewersManager.this.refreshAllViewers();
                }
            });
        }
    }

    protected final void refreshAllViewers() {
        for (ColoringLabelProvider provider : this.fManagedLabelProviders) {
            provider.refresh();
        }
    }

    public static boolean showColoredLabels() {
        return PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS");
    }

    public static void install(ColoringLabelProvider labelProvider) {
        fgInstance.installColoredLabels(labelProvider);
    }

    public static void uninstall(ColoringLabelProvider labelProvider) {
        fgInstance.uninstallColoredLabels(labelProvider);
    }
}

