/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedListDialogField<T>
extends ListDialogField<T> {
    private int fCheckAllButtonIndex = -1;
    private int fUncheckAllButtonIndex = -1;
    private List<T> fCheckElements = new ArrayList<T>();

    public CheckedListDialogField(IListAdapter<T> adapter, String[] customButtonLabels, IBaseLabelProvider lprovider) {
        super(adapter, customButtonLabels, lprovider);
    }

    public void setCheckAllButtonIndex(int checkButtonIndex) {
        Assert.isTrue((checkButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fCheckAllButtonIndex = checkButtonIndex;
    }

    public void setUncheckAllButtonIndex(int uncheckButtonIndex) {
        Assert.isTrue((uncheckButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUncheckAllButtonIndex = uncheckButtonIndex;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 32 + this.getListStyle());
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                CheckedListDialogField.this.doCheckStateChanged(e);
            }
        });
        return tableViewer;
    }

    @Override
    public Control getListControl(Composite parent) {
        Control control = super.getListControl(parent);
        if (parent != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckElements.toArray());
        }
        return control;
    }

    @Override
    public void dialogFieldChanged() {
        int i = this.fCheckElements.size() - 1;
        while (i >= 0) {
            if (!this.fElements.contains(this.fCheckElements.get(i))) {
                this.fCheckElements.remove(i);
            }
            --i;
        }
        super.dialogFieldChanged();
    }

    private void checkStateChanged() {
        super.dialogFieldChanged();
    }

    public List<T> getCheckedElements() {
        return new ArrayList<T>(this.fCheckElements);
    }

    public int getCheckedSize() {
        return this.fCheckElements.size();
    }

    public boolean isChecked(Object obj) {
        return this.fCheckElements.contains(obj);
    }

    public void setCheckedElements(Collection<T> list) {
        this.fCheckElements = new ArrayList<T>(list);
        if (this.fTable != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(list.toArray());
        }
        this.checkStateChanged();
    }

    public void setChecked(T object, boolean state) {
        this.setCheckedWithoutUpdate(object, state);
        this.checkStateChanged();
    }

    public void setCheckedWithoutUpdate(T object, boolean state) {
        if (state) {
            if (!this.fCheckElements.contains(object)) {
                this.fCheckElements.add(object);
            }
        } else {
            this.fCheckElements.remove(object);
        }
        if (this.fTable != null) {
            ((CheckboxTableViewer)this.fTable).setChecked(object, state);
        }
    }

    public void checkAll(boolean state) {
        if (state) {
            this.fCheckElements = this.getElements();
        } else {
            this.fCheckElements.clear();
        }
        if (this.fTable != null) {
            ((CheckboxTableViewer)this.fTable).setAllChecked(state);
        }
        this.checkStateChanged();
    }

    void doCheckStateChanged(CheckStateChangedEvent e) {
        if (e.getChecked()) {
            Object elem = e.getElement();
            this.fCheckElements.add(elem);
        } else {
            this.fCheckElements.remove(e.getElement());
        }
        this.checkStateChanged();
    }

    @Override
    public void replaceElement(T oldElement, T newElement) throws IllegalArgumentException {
        boolean wasChecked = this.isChecked(oldElement);
        super.replaceElement(oldElement, newElement);
        this.setChecked(newElement, wasChecked);
    }

    @Override
    protected boolean getManagedButtonState(ISelection sel, int index) {
        if (index == this.fCheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        if (index == this.fUncheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        return super.getManagedButtonState(sel, index);
    }

    @Override
    protected boolean managedButtonPressed(int index) {
        if (index == this.fCheckAllButtonIndex) {
            this.checkAll(true);
        } else if (index == this.fUncheckAllButtonIndex) {
            this.checkAll(false);
        } else {
            return super.managedButtonPressed(index);
        }
        return true;
    }
}

