/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.AbstractProblemReporter;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.ICodanProblemMarker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemReporterPersistent;
import org.eclipse.cdt.codan.core.model.IProblemReporterSessionPersistent;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodanMarkerProblemReporter
extends AbstractProblemReporter
implements IProblemReporterPersistent,
IProblemReporterSessionPersistent {
    private IResource resource;
    private IChecker checker;
    private ArrayList<ICodanProblemMarker> toAdd = new ArrayList();

    public CodanMarkerProblemReporter() {
    }

    public CodanMarkerProblemReporter(IResource resource, IChecker checker) {
        this.resource = resource;
        this.checker = checker;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public IChecker getChecker() {
        return this.checker;
    }

    @Override
    protected void reportProblem(ICodanProblemMarker codanProblemMarker) {
        if (this.checker == null) {
            this.createProblem(codanProblemMarker);
        } else {
            this.toAdd.add(codanProblemMarker);
        }
    }

    protected IMarker createProblem(ICodanProblemMarker codanProblemMarker) {
        try {
            return codanProblemMarker.createMarker();
        }
        catch (CoreException e) {
            CodanCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public void deleteProblems(IResource file) {
        try {
            file.deleteMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 0);
        }
        catch (CoreException ce) {
            CodanCorePlugin.log(ce);
        }
    }

    @Override
    public void deleteAllProblems() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 2);
        }
        catch (CoreException e) {
            CodanCorePlugin.log(e);
        }
    }

    @Override
    public void deleteProblems(final IResource file, final IChecker checker) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Collection<IMarker> markers = CodanMarkerProblemReporter.this.findResourceMarkers(file, checker);
                    for (IMarker iMarker : markers) {
                        iMarker.delete();
                    }
                }
            }, null, 1, null);
        }
        catch (CoreException e) {
            CodanCorePlugin.log(e);
        }
    }

    protected Collection<IMarker> findResourceMarkers(IResource resource, IChecker checker) throws CoreException {
        IMarker[] markers;
        ArrayList<IMarker> res = new ArrayList<IMarker>();
        if (resource.exists()) {
            markers = resource.findMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 2);
        } else {
            if (resource.getProject() == null || !resource.getProject().isAccessible()) {
                return res;
            }
            markers = resource.getProject().findMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 0);
        }
        ICheckersRegistry reg = CodanRuntime.getInstance().getCheckersRegistry();
        Collection<IProblem> problems = reg.getRefProblems(checker);
        int i = 0;
        while (i < markers.length) {
            IMarker m = markers[i];
            String id = m.getAttribute("id", "");
            for (IProblem iProblem : problems) {
                if (!iProblem.getId().equals(id)) continue;
                res.add(m);
            }
            ++i;
        }
        return res;
    }

    @Override
    public IProblemReporterSessionPersistent createReporter(IResource resource, IChecker checker) {
        return new CodanMarkerProblemReporter(resource, checker);
    }

    @Override
    public void start() {
        if (this.checker == null) {
            this.deleteProblems(false);
        }
    }

    @Override
    public void done() {
        if (this.checker != null) {
            if (this.toAdd.size() == 0) {
                this.deleteProblems(false);
            } else {
                this.reconcileMarkers();
            }
            this.toAdd.clear();
        }
    }

    protected void reconcileMarkers() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Collection<IMarker> markers = CodanMarkerProblemReporter.this.findResourceMarkers(CodanMarkerProblemReporter.this.resource, CodanMarkerProblemReporter.this.checker);
                    for (IMarker m : markers) {
                        ICodanProblemMarker cm = CodanMarkerProblemReporter.this.similarMarker(m);
                        if (cm == null) {
                            m.delete();
                            continue;
                        }
                        CodanMarkerProblemReporter.this.updateMarker(m, cm);
                        CodanMarkerProblemReporter.this.toAdd.remove(cm);
                    }
                    for (ICodanProblemMarker cm : CodanMarkerProblemReporter.this.toAdd) {
                        cm.createMarker();
                    }
                }
            }, null, 1, null);
        }
        catch (CoreException e) {
            CodanCorePlugin.log(e);
        }
    }

    protected void updateMarker(IMarker m, ICodanProblemMarker cm) {
        IProblemLocation loc = cm.getLocation();
        try {
            if (m.getAttribute("lineNumber", 0) != loc.getLineNumber()) {
                m.setAttribute("lineNumber", loc.getLineNumber());
            }
            if (m.getAttribute("charStart", 0) != loc.getStartingChar()) {
                m.setAttribute("charStart", loc.getStartingChar());
            }
            if (m.getAttribute("charEnd", 0) != loc.getEndingChar()) {
                m.setAttribute("charEnd", loc.getEndingChar());
            }
            int severity = cm.getProblem().getSeverity().intValue();
            if (m.getAttribute("severity", 0) != severity) {
                m.setAttribute("severity", severity);
            }
        }
        catch (CoreException coreException) {
            try {
                m.delete();
                cm.createMarker();
            }
            catch (CoreException e1) {
                CodanCorePlugin.log(e1);
            }
        }
    }

    protected ICodanProblemMarker similarMarker(IMarker m) {
        ICodanProblemMarker mcm = CodanProblemMarker.createCodanProblemMarkerFromResourceMarker(m);
        ArrayList<ICodanProblemMarker> cand = new ArrayList<ICodanProblemMarker>();
        for (ICodanProblemMarker cm : this.toAdd) {
            if (mcm.equals(cm)) {
                return cm;
            }
            if (!this.markersAreSimilar(mcm, cm)) continue;
            cand.add(cm);
        }
        if (cand.size() == 1) {
            return (ICodanProblemMarker)cand.get(0);
        }
        return null;
    }

    private boolean markersAreSimilar(ICodanProblemMarker marker1, ICodanProblemMarker marker2) {
        if (!marker1.getProblem().getId().equals(marker2.getProblem().getId())) {
            return false;
        }
        if (!Arrays.equals(marker1.getArgs(), marker2.getArgs())) {
            return false;
        }
        IProblemLocation loc1 = marker1.getLocation();
        IProblemLocation loc2 = marker2.getLocation();
        if (!loc1.getFile().equals((Object)loc2.getFile())) {
            return false;
        }
        return Math.abs(loc1.getLineNumber() - loc2.getLineNumber()) <= 2;
    }

    @Override
    public void deleteProblems(boolean all) {
        if (all) {
            throw new UnsupportedOperationException();
        }
        this.deleteProblems(this.resource, this.checker);
    }
}

