/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.layout.grid;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Rect;
import com.android.ide.common.layout.GravityHelper;
import com.android.ide.common.layout.GridLayoutRule;
import com.android.utils.Pair;
import com.google.common.collect.ArrayListMultimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GridModel {
    static final int UNDEFINED = Integer.MIN_VALUE;
    static final int SPACER_SIZE_DP = 1;
    private static final String SPACER_SIZE = String.format("%ddp", 1);
    private static final int DEFAULT_CELL_WIDTH = 100;
    private static final int DEFAULT_CELL_HEIGHT = 15;
    public final INode layout;
    public boolean vertical;
    public int declaredRowCount;
    public int declaredColumnCount;
    public int actualRowCount;
    public int actualColumnCount;
    private int[] mLeft;
    private int[] mTop;
    private int[] mMaxRight;
    private int[] mMaxBottom;
    private int[] mBaselines;
    private List<ViewData> mChildViews;
    private final IClientRulesEngine mRulesEngine;
    private Object mViewObject;
    private String mNamespace;
    private static WeakReference<Object> sCachedViewObject = new WeakReference<Object>(null);
    private static WeakReference<GridModel> sCachedViewModel;
    private static boolean sAttemptSpecReflection;

    static {
        sAttemptSpecReflection = true;
    }

    private GridModel(IClientRulesEngine rulesEngine, INode node, Object viewObject) {
        this.mRulesEngine = rulesEngine;
        this.layout = node;
        this.mViewObject = viewObject;
        this.loadFromXml();
    }

    @NonNull
    public static GridModel get(@NonNull IClientRulesEngine rulesEngine, @NonNull INode node, @Nullable Object viewObject) {
        GridModel model;
        if (viewObject != null && viewObject == sCachedViewObject.get() && (model = (GridModel)sCachedViewModel.get()) != null) {
            return model;
        }
        model = new GridModel(rulesEngine, node, viewObject);
        sCachedViewModel = new WeakReference<GridModel>(model);
        sCachedViewObject = new WeakReference<Object>(viewObject);
        return model;
    }

    public ViewData getView(int index) {
        return this.mChildViews.get(index);
    }

    public ViewData getView(INode node) {
        for (ViewData view : this.mChildViews) {
            if (view.node != node) continue;
            return view;
        }
        return null;
    }

    public int getInsertIndex(int row, int column) {
        if (this.vertical) {
            for (ViewData view : this.mChildViews) {
                if (view.column <= column && (view.column != column || view.row < row)) continue;
                return view.index;
            }
        } else {
            for (ViewData view : this.mChildViews) {
                if (view.row <= row && (view.row != row || view.column < column)) continue;
                return view.index;
            }
        }
        for (ViewData view : this.mChildViews) {
            if (!view.isSpacer()) continue;
            return view.index;
        }
        return -1;
    }

    public int getBaseline(int row) {
        if (row < 0 || row >= this.mBaselines.length) {
            return -1;
        }
        int baseline = this.mBaselines[row];
        if (baseline == Integer.MIN_VALUE) {
            baseline = -1;
            for (ViewData view : this.mChildViews) {
                String gravity;
                if (view.row != row || view.rowSpan != 1 || (baseline = view.node.getBaseline()) == -1 || (gravity = this.getGridAttribute(view.node, "layout_gravity")) != null && (gravity.contains("top") || gravity.contains("bottom") || gravity.contains("center_vertical"))) continue;
                baseline += view.node.getBounds().y - this.getRowY(row);
                break;
            }
            this.mBaselines[row] = baseline;
        }
        return baseline;
    }

    void applyPositionAttributes() {
        for (ViewData view : this.mChildViews) {
            view.applyPositionAttributes();
        }
        if (this.getGridAttribute(this.layout, "columnCount") != null && this.declaredColumnCount > this.actualColumnCount) {
            this.setGridAttribute(this.layout, "columnCount", this.actualColumnCount);
        }
    }

    public void setGridAttribute(INode node, String name, int value) {
        this.setGridAttribute(node, name, Integer.toString(value));
    }

    public void setGridAttribute(INode node, String name, String value) {
        node.setAttribute(this.getNamespace(), name, value);
    }

    public String getNamespace() {
        if (this.mNamespace == null) {
            this.mNamespace = "http://schemas.android.com/apk/res/android";
            String fqcn = this.layout.getFqcn();
            if (!fqcn.equals("GridLayout") && !fqcn.equals("android.widget.GridLayout")) {
                this.mNamespace = this.mRulesEngine.getAppNameSpace();
            }
        }
        return this.mNamespace;
    }

    static String removeFlag(String flag, String value) {
        if (value.equals(flag)) {
            return null;
        }
        int index = value.indexOf(flag);
        if (index != -1) {
            int pipe = value.lastIndexOf(124, index);
            int endIndex = index + flag.length();
            value = pipe != -1 ? String.valueOf(value.substring(0, pipe).trim()) + value.substring(endIndex).trim() : ((pipe = value.indexOf(124, endIndex)) != -1 ? String.valueOf(value.substring(0, index).trim()) + value.substring(pipe + 1).trim() : String.valueOf(value.substring(0, index).trim()) + value.substring(endIndex).trim());
        }
        return value;
    }

    private void loadFromXml() {
        INode[] children = this.layout.getChildren();
        this.declaredRowCount = this.getGridAttribute(this.layout, "rowCount", Integer.MIN_VALUE);
        this.declaredColumnCount = this.getGridAttribute(this.layout, "columnCount", Integer.MIN_VALUE);
        this.vertical = "vertical".equals(this.getGridAttribute(this.layout, "orientation"));
        this.mChildViews = new ArrayList<ViewData>(children.length);
        int index = 0;
        INode[] iNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            ViewData view = new ViewData(child, index++);
            this.mChildViews.add(view);
            ++n2;
        }
        if (!this.assignRowsAndColumnsFromViews(this.mChildViews)) {
            this.assignRowsAndColumnsFromXml(this.declaredRowCount == Integer.MIN_VALUE ? children.length : this.declaredRowCount, this.declaredColumnCount == Integer.MIN_VALUE ? children.length : this.declaredColumnCount);
        }
        this.assignCellBounds();
        int i = 0;
        while (i <= this.actualRowCount) {
            this.mBaselines[i] = Integer.MIN_VALUE;
            ++i;
        }
    }

    private Pair<Map<Integer, Integer>, Map<Integer, Integer>> findCellsOutsideDeclaredBounds() {
        HashMap<Integer, Integer> extraColumnsMap = null;
        HashMap<Integer, Integer> extraRowsMap = null;
        if (this.declaredRowCount != Integer.MIN_VALUE) {
            HashSet<Integer> extraRows = null;
            for (ViewData view : this.mChildViews) {
                if (view.row < this.declaredRowCount) continue;
                if (extraRows == null) {
                    extraRows = new HashSet<Integer>();
                }
                extraRows.add(view.row);
            }
            if (extraRows != null && this.declaredRowCount != Integer.MIN_VALUE) {
                ArrayList rows = new ArrayList(extraRows);
                Collections.sort(rows);
                int row = this.declaredRowCount;
                extraRowsMap = new HashMap<Integer, Integer>();
                for (Integer declared : rows) {
                    extraRowsMap.put(declared, row++);
                }
            }
        }
        if (this.declaredColumnCount != Integer.MIN_VALUE) {
            HashSet<Integer> extraColumns = null;
            for (ViewData view : this.mChildViews) {
                if (view.column < this.declaredColumnCount) continue;
                if (extraColumns == null) {
                    extraColumns = new HashSet<Integer>();
                }
                extraColumns.add(view.column);
            }
            if (extraColumns != null && this.declaredColumnCount != Integer.MIN_VALUE) {
                ArrayList columns = new ArrayList(extraColumns);
                Collections.sort(columns);
                int column = this.declaredColumnCount;
                extraColumnsMap = new HashMap<Integer, Integer>();
                for (Integer declared : columns) {
                    extraColumnsMap.put(declared, column++);
                }
            }
        }
        return Pair.of(extraRowsMap, extraColumnsMap);
    }

    private void assignRowsAndColumnsFromXml(int rowCount, int columnCount) {
        Pair<Map<Integer, Integer>, Map<Integer, Integer>> p = this.findCellsOutsideDeclaredBounds();
        Map extraRowsMap = (Map)p.getFirst();
        Map extraColumnsMap = (Map)p.getSecond();
        if (!this.vertical) {
            int row = 0;
            int column = 0;
            int nextRow = 1;
            for (ViewData view : this.mChildViews) {
                int declaredColumn = view.column;
                if (declaredColumn != Integer.MIN_VALUE) {
                    if (declaredColumn >= columnCount) {
                        assert (extraColumnsMap != null);
                        view.column = declaredColumn = ((Integer)extraColumnsMap.get(declaredColumn)).intValue();
                    }
                    if (declaredColumn < column) {
                        assert (nextRow > row);
                        row = nextRow;
                    }
                    column = declaredColumn;
                } else {
                    view.column = column;
                }
                if (view.row != Integer.MIN_VALUE) {
                    row = view.row;
                } else {
                    view.row = row;
                }
                nextRow = Math.max(nextRow, view.row + view.rowSpan);
                if ((column += view.columnSpan) < columnCount) continue;
                column = 0;
                assert (nextRow > row);
                row = nextRow;
            }
        } else {
            int row = 0;
            int column = 0;
            int nextColumn = 1;
            for (ViewData view : this.mChildViews) {
                int declaredRow = view.row;
                if (declaredRow != Integer.MIN_VALUE) {
                    if (declaredRow >= rowCount) {
                        view.row = declaredRow = ((Integer)extraRowsMap.get(declaredRow)).intValue();
                    }
                    if (declaredRow < row) {
                        assert (nextColumn > column);
                        column = nextColumn;
                    }
                    row = declaredRow;
                } else {
                    view.row = row;
                }
                if (view.column != Integer.MIN_VALUE) {
                    column = view.column;
                } else {
                    view.column = column;
                }
                nextColumn = Math.max(nextColumn, view.column + view.columnSpan);
                if ((row += view.rowSpan) < rowCount) continue;
                row = 0;
                assert (nextColumn > column);
                column = nextColumn;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean assignRowsAndColumnsFromViews(List<ViewData> views) {
        if (!sAttemptSpecReflection) {
            return false;
        }
        try {
            Field spanField = null;
            Field rowSpecField = null;
            Field colSpecField = null;
            Field minField = null;
            Field maxField = null;
            Method getLayoutParams = null;
            Iterator<ViewData> iterator = views.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                ViewData view = iterator.next();
                Object child = this.mRulesEngine.getViewObject(view.node);
                if (child == null) {
                    return false;
                }
                if (getLayoutParams == null) {
                    getLayoutParams = child.getClass().getMethod("getLayoutParams", new Class[0]);
                }
                Object layoutParams = getLayoutParams.invoke(child, new Object[0]);
                if (rowSpecField == null) {
                    Class<?> layoutParamsClass = layoutParams.getClass();
                    rowSpecField = layoutParamsClass.getDeclaredField("rowSpec");
                    colSpecField = layoutParamsClass.getDeclaredField("columnSpec");
                    rowSpecField.setAccessible(true);
                    colSpecField.setAccessible(true);
                }
                assert (colSpecField != null);
                Object rowSpec = rowSpecField.get(layoutParams);
                Object colSpec = colSpecField.get(layoutParams);
                if (spanField == null) {
                    spanField = rowSpec.getClass().getDeclaredField("span");
                    spanField.setAccessible(true);
                }
                assert (spanField != null);
                Object rowInterval = spanField.get(rowSpec);
                Object colInterval = spanField.get(colSpec);
                if (minField == null) {
                    Class<?> intervalClass = rowInterval.getClass();
                    minField = intervalClass.getDeclaredField("min");
                    maxField = intervalClass.getDeclaredField("max");
                    minField.setAccessible(true);
                    maxField.setAccessible(true);
                }
                assert (maxField != null);
                int row = minField.getInt(rowInterval);
                int col = minField.getInt(colInterval);
                int rowEnd = maxField.getInt(rowInterval);
                int colEnd = maxField.getInt(colInterval);
                view.column = col;
                view.row = row;
                view.columnSpan = colEnd - col;
                view.rowSpan = rowEnd - row;
            }
        }
        catch (Throwable throwable) {
            sAttemptSpecReflection = false;
            return false;
        }
    }

    private void assignCellBounds() {
        if (!this.assignCellBoundsFromView()) {
            this.assignCellBoundsFromBounds();
        }
        this.initializeMaxBounds();
        this.mBaselines = new int[this.actualRowCount + 1];
    }

    private boolean assignCellBoundsFromView() {
        Pair<int[], int[]> cellBounds;
        if (this.mViewObject != null && (cellBounds = GridModel.getAxisBounds(this.mViewObject)) != null) {
            int i;
            int[] xs = (int[])cellBounds.getFirst();
            int[] ys = (int[])cellBounds.getSecond();
            Rect layoutBounds = this.layout.getBounds();
            if (this.actualColumnCount <= 1 && this.actualRowCount <= 1 && this.mChildViews.isEmpty()) {
                xs = new int[2];
                ys = new int[2];
                int cellWidth = layoutBounds.w / 1;
                int cellHeight = layoutBounds.h / 1;
                i = 0;
                while (i <= 1) {
                    xs[i] = i * cellWidth;
                    ys[i] = i * cellHeight;
                    ++i;
                }
            }
            this.actualColumnCount = xs.length - 1;
            this.actualRowCount = ys.length - 1;
            int layoutBoundsX = layoutBounds.x;
            int layoutBoundsY = layoutBounds.y;
            this.mLeft = new int[xs.length];
            this.mTop = new int[ys.length];
            i = 0;
            while (i < xs.length) {
                this.mLeft[i] = xs[i] + layoutBoundsX;
                ++i;
            }
            i = 0;
            while (i < ys.length) {
                this.mTop[i] = ys[i] + layoutBoundsY;
                ++i;
            }
            return true;
        }
        return false;
    }

    private void assignCellBoundsFromBounds() {
        Rect layoutBounds = this.layout.getBounds();
        int maxColumn = 0;
        int maxRow = 0;
        for (ViewData view : this.mChildViews) {
            maxColumn = Math.max(maxColumn, view.column);
            maxRow = Math.max(maxRow, view.row);
        }
        this.actualColumnCount = maxColumn + 1;
        this.actualRowCount = maxRow + 1;
        this.mLeft = new int[this.actualColumnCount + 1];
        int i = 1;
        while (i < this.actualColumnCount) {
            this.mLeft[i] = Integer.MIN_VALUE;
            ++i;
        }
        this.mLeft[0] = layoutBounds.x;
        this.mLeft[this.actualColumnCount] = layoutBounds.x2();
        this.mTop = new int[this.actualRowCount + 1];
        i = 1;
        while (i < this.actualRowCount) {
            this.mTop[i] = Integer.MIN_VALUE;
            ++i;
        }
        this.mTop[0] = layoutBounds.y;
        this.mTop[this.actualRowCount] = layoutBounds.y2();
        for (ViewData view : this.mChildViews) {
            Rect bounds = view.node.getBounds();
            if (!bounds.isValid()) continue;
            int column = view.column;
            int row = view.row;
            this.mLeft[column] = this.mLeft[column] == Integer.MIN_VALUE ? bounds.x : Math.min(bounds.x, this.mLeft[column]);
            this.mTop[row] = this.mTop[row] == Integer.MIN_VALUE ? bounds.y : Math.min(bounds.y, this.mTop[row]);
        }
        i = this.actualColumnCount - 1;
        while (i >= 0) {
            if (this.mLeft[i] == Integer.MIN_VALUE) {
                if (i == 0) {
                    this.mLeft[i] = layoutBounds.x;
                } else if (i < this.actualColumnCount - 1) {
                    this.mLeft[i] = this.mLeft[i + 1] - 1;
                    if (this.mLeft[i - 1] != Integer.MIN_VALUE && this.mLeft[i] < this.mLeft[i - 1]) {
                        this.mLeft[i] = this.mLeft[i - 1];
                    }
                } else {
                    this.mLeft[i] = layoutBounds.x2();
                }
            }
            --i;
        }
        i = this.actualRowCount - 1;
        while (i >= 0) {
            if (this.mTop[i] == Integer.MIN_VALUE) {
                if (i == 0) {
                    this.mTop[i] = layoutBounds.y;
                } else if (i < this.actualRowCount - 1) {
                    this.mTop[i] = this.mTop[i + 1] - 1;
                    if (this.mTop[i - 1] != Integer.MIN_VALUE && this.mTop[i] < this.mTop[i - 1]) {
                        this.mTop[i] = this.mTop[i - 1];
                    }
                } else {
                    this.mTop[i] = layoutBounds.y2();
                }
            }
            --i;
        }
    }

    private void initializeMaxBounds() {
        this.mMaxRight = new int[this.actualColumnCount + 1];
        this.mMaxBottom = new int[this.actualRowCount + 1];
        for (ViewData view : this.mChildViews) {
            Margins insets;
            Rect bounds = view.node.getBounds();
            if (!bounds.isValid() || view.isSpacer()) continue;
            int x2 = bounds.x2();
            int y2 = bounds.y2();
            int column = view.column;
            int row = view.row;
            int targetColumn = Math.min(this.actualColumnCount - 1, column + view.columnSpan - 1);
            int targetRow = Math.min(this.actualRowCount - 1, row + view.rowSpan - 1);
            IViewMetadata metadata = this.mRulesEngine.getMetadata(view.node.getFqcn());
            if (metadata != null && (insets = metadata.getInsets()) != null) {
                x2 -= insets.right;
                y2 -= insets.bottom;
            }
            if (this.mMaxRight[targetColumn] < x2 && (view.gravity & 6) == 0) {
                this.mMaxRight[targetColumn] = x2;
            }
            if (this.mMaxBottom[targetRow] >= y2 || (view.gravity & 0x90) != 0) continue;
            this.mMaxBottom[targetRow] = y2;
        }
    }

    public static Pair<int[], int[]> getAxisBounds(Object view) {
        try {
            Field horizontalAxis;
            Class<?> clz = view.getClass();
            String verticalAxisName = "verticalAxis";
            try {
                horizontalAxis = clz.getDeclaredField("horizontalAxis");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                horizontalAxis = clz.getDeclaredField("mHorizontalAxis");
                verticalAxisName = "mVerticalAxis";
            }
            Field verticalAxis = clz.getDeclaredField(verticalAxisName);
            horizontalAxis.setAccessible(true);
            verticalAxis.setAccessible(true);
            Object horizontal = horizontalAxis.get(view);
            Object vertical = verticalAxis.get(view);
            Field locations = horizontal.getClass().getDeclaredField("locations");
            assert (locations.getType().isArray()) : locations.getType();
            locations.setAccessible(true);
            Object horizontalLocations = locations.get(horizontal);
            Object verticalLocations = locations.get(vertical);
            int[] xs = (int[])horizontalLocations;
            int[] ys = (int[])verticalLocations;
            return Pair.of((Object)xs, (Object)ys);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public INode addColumn(List<? extends INode> selectedChildren) {
        INode newView;
        int newColumn = this.actualColumnCount;
        if (selectedChildren != null && selectedChildren.size() > 0) {
            INode first = selectedChildren.get(0);
            ViewData view = this.getView(first);
            newColumn = view.column;
        }
        if ((newView = this.addColumn(newColumn, null, Integer.MIN_VALUE, false, Integer.MIN_VALUE, Integer.MIN_VALUE)) != null) {
            this.mRulesEngine.select(Collections.singletonList(newView));
        }
        return newView;
    }

    public INode addColumn(int newColumn, INode newView, int columnWidthDp, boolean split, int row, int x) {
        ++this.actualColumnCount;
        if (this.declaredColumnCount != Integer.MIN_VALUE) {
            ++this.declaredColumnCount;
            this.setGridAttribute(this.layout, "columnCount", this.declaredColumnCount);
        }
        boolean isLastColumn = true;
        for (ViewData view : this.mChildViews) {
            if (view.column < newColumn) continue;
            isLastColumn = false;
            break;
        }
        for (ViewData view : this.mChildViews) {
            boolean columnSpanSet = false;
            int endColumn = view.column + view.columnSpan;
            if (view.column >= newColumn || endColumn == newColumn) {
                if (view.column == newColumn || endColumn == newColumn) {
                    if (newView == null && !isLastColumn) {
                        int index = GridModel.getChildIndex(this.layout.getChildren(), view.node);
                        assert (view.index == index);
                        if (endColumn == newColumn) {
                            ++index;
                        }
                        ViewData newViewData = this.addSpacer(this.layout, index, split ? row : Integer.MIN_VALUE, split ? newColumn - 1 : Integer.MIN_VALUE, columnWidthDp != Integer.MIN_VALUE ? columnWidthDp : 100, 15);
                        newViewData.column = newColumn - 1;
                        newViewData.row = row;
                        newView = newViewData.node;
                    }
                    if (view.column == newColumn) {
                        ++view.column;
                        this.setGridAttribute(view.node, "layout_column", view.column);
                    }
                } else if (this.getGridAttribute(view.node, "layout_column") != null) {
                    ++view.column;
                    this.setGridAttribute(view.node, "layout_column", view.column);
                }
            } else if (endColumn > newColumn) {
                ++view.columnSpan;
                this.setColumnSpanAttribute(view.node, view.columnSpan);
                columnSpanSet = true;
            }
            if (!split || columnSpanSet || view.node.getBounds().x2() <= x || view.node.getBounds().x >= x) continue;
            ++view.columnSpan;
            this.setColumnSpanAttribute(view.node, view.columnSpan);
        }
        if (isLastColumn) {
            for (ViewData view : this.mChildViews) {
                if (view.column != 0 || view.row <= 0) continue;
                this.setGridAttribute(view.node, "layout_row", view.row);
            }
            if (split) {
                assert (newView == null);
                this.addSpacer(this.layout, -1, row, newColumn - 1, columnWidthDp != Integer.MIN_VALUE ? columnWidthDp : 100, 1);
            }
        }
        return newView;
    }

    public void removeColumns(List<? extends INode> selectedChildren) {
        if (selectedChildren.size() == 0) {
            return;
        }
        HashSet<Integer> removeColumns = new HashSet<Integer>();
        HashSet<ViewData> removedViews = new HashSet<ViewData>();
        for (INode iNode : selectedChildren) {
            ViewData viewData = this.getView(iNode);
            removedViews.add(viewData);
            removeColumns.add(viewData.column);
        }
        ArrayList arrayList = new ArrayList(removeColumns);
        Collections.sort(arrayList, Collections.reverseOrder());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int removedColumn = (Integer)iterator.next();
            --this.actualColumnCount;
            if (this.declaredColumnCount != Integer.MIN_VALUE) {
                --this.declaredColumnCount;
            }
            for (ViewData view2 : this.mChildViews) {
                if (view2.column == removedColumn) {
                    int index = GridModel.getChildIndex(this.layout.getChildren(), view2.node);
                    assert (view2.index == index);
                    if (view2.columnSpan > 1) {
                        int columnWidth = this.getColumnWidth(removedColumn, view2.columnSpan) - this.getColumnWidth(removedColumn, 1);
                        int columnWidthDip = this.mRulesEngine.pxToDp(columnWidth);
                        ViewData spacer = this.addSpacer(this.layout, index, Integer.MIN_VALUE, Integer.MIN_VALUE, columnWidthDip, 1);
                        spacer.row = 0;
                        spacer.column = removedColumn;
                    }
                    this.layout.removeChild(view2.node);
                    continue;
                }
                if (view2.column < removedColumn && view2.column + view2.columnSpan > removedColumn) {
                    --view2.columnSpan;
                    this.setColumnSpanAttribute(view2.node, view2.columnSpan);
                    continue;
                }
                if (view2.column <= removedColumn) continue;
                --view2.column;
                if (this.getGridAttribute(view2.node, "layout_column") == null) continue;
                this.setGridAttribute(view2.node, "layout_column", view2.column);
            }
        }
        if (removedViews.size() <= 2) {
            this.mChildViews.removeAll(removedViews);
        } else {
            ArrayList<ViewData> remaining = new ArrayList<ViewData>(this.mChildViews.size() - removedViews.size());
            for (ViewData viewData : this.mChildViews) {
                if (removedViews.contains(viewData)) continue;
                remaining.add(viewData);
            }
            this.mChildViews = remaining;
        }
        this.setGridAttribute(this.layout, "columnCount", this.actualColumnCount);
    }

    public INode addRow(List<? extends INode> selectedChildren) {
        INode newView;
        int newRow = this.actualRowCount;
        if (selectedChildren.size() > 0) {
            INode first = selectedChildren.get(0);
            ViewData view = this.getView(first);
            newRow = view.row;
        }
        if ((newView = this.addRow(newRow, null, Integer.MIN_VALUE, false, Integer.MIN_VALUE, Integer.MIN_VALUE)) != null) {
            this.mRulesEngine.select(Collections.singletonList(newView));
        }
        return newView;
    }

    public INode addRow(int newRow, INode newView, int rowHeightDp, boolean split, int column, int y) {
        ++this.actualRowCount;
        if (this.declaredRowCount != Integer.MIN_VALUE) {
            ++this.declaredRowCount;
            this.setGridAttribute(this.layout, "rowCount", this.declaredRowCount);
        }
        boolean added = false;
        for (ViewData view : this.mChildViews) {
            if (view.row >= newRow) {
                if (view.row == newRow && view.column == 0) {
                    if (newView == null) {
                        int index = GridModel.getChildIndex(this.layout.getChildren(), view.node);
                        assert (view.index == index);
                        if (this.declaredColumnCount != Integer.MIN_VALUE && !split) {
                            this.setGridAttribute(this.layout, "columnCount", this.declaredColumnCount);
                        }
                        ViewData newViewData = this.addSpacer(this.layout, index, split ? newRow - 1 : Integer.MIN_VALUE, split ? column : Integer.MIN_VALUE, 1, rowHeightDp != Integer.MIN_VALUE ? rowHeightDp : 15);
                        newViewData.column = column;
                        newViewData.row = newRow - 1;
                        newView = newViewData.node;
                    }
                    ++view.row;
                    this.setGridAttribute(view.node, "layout_row", view.row);
                    added = true;
                    continue;
                }
                if (this.getGridAttribute(view.node, "layout_row") == null) continue;
                ++view.row;
                this.setGridAttribute(view.node, "layout_row", view.row);
                continue;
            }
            int endRow = view.row + view.rowSpan;
            if (endRow > newRow) {
                ++view.rowSpan;
                this.setRowSpanAttribute(view.node, view.rowSpan);
                continue;
            }
            if (!split || view.node.getBounds().y2() <= y || view.node.getBounds().y >= y) continue;
            ++view.rowSpan;
            this.setRowSpanAttribute(view.node, view.rowSpan);
        }
        if (!added) {
            if (newView == null) {
                ViewData newViewData = this.addSpacer(this.layout, -1, Integer.MIN_VALUE, Integer.MIN_VALUE, 1, rowHeightDp != Integer.MIN_VALUE ? rowHeightDp : 15);
                newViewData.column = column;
                newViewData.row = split ? newRow - 1 : newRow;
                newView = newViewData.node;
            }
            if (this.declaredColumnCount != Integer.MIN_VALUE && !split) {
                this.setGridAttribute(this.layout, "columnCount", this.declaredColumnCount);
            }
            if (split) {
                this.setGridAttribute(newView, "layout_row", newRow - 1);
                this.setGridAttribute(newView, "layout_column", column);
            }
        }
        return newView;
    }

    public void removeRows(List<? extends INode> selectedChildren) {
        if (selectedChildren.size() == 0) {
            return;
        }
        HashSet<ViewData> removedViews = new HashSet<ViewData>();
        HashSet<Integer> removedRows = new HashSet<Integer>();
        for (INode iNode : selectedChildren) {
            ViewData viewData = this.getView(iNode);
            removedViews.add(viewData);
            removedRows.add(viewData.row);
        }
        ArrayList arrayList = new ArrayList(removedRows);
        Collections.sort(arrayList, Collections.reverseOrder());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int removedRow = (Integer)iterator.next();
            --this.actualRowCount;
            if (this.declaredRowCount != Integer.MIN_VALUE) {
                --this.declaredRowCount;
                this.setGridAttribute(this.layout, "rowCount", this.declaredRowCount);
            }
            for (ViewData view2 : this.mChildViews) {
                if (view2.row == removedRow) {
                    this.layout.removeChild(view2.node);
                    continue;
                }
                if (view2.row > removedRow) {
                    --view2.row;
                    if (this.getGridAttribute(view2.node, "layout_row") == null) continue;
                    this.setGridAttribute(view2.node, "layout_row", view2.row);
                    continue;
                }
                if (view2.row >= removedRow || view2.row + view2.rowSpan <= removedRow) continue;
                --view2.rowSpan;
                this.setRowSpanAttribute(view2.node, view2.rowSpan);
            }
        }
        if (removedViews.size() <= 2) {
            this.mChildViews.removeAll(removedViews);
        } else {
            ArrayList<ViewData> remaining = new ArrayList<ViewData>(this.mChildViews.size() - removedViews.size());
            for (ViewData viewData : this.mChildViews) {
                if (removedViews.contains(viewData)) continue;
                remaining.add(viewData);
            }
            this.mChildViews = remaining;
        }
    }

    public int getRow(int y) {
        int row = Arrays.binarySearch(this.mTop, y);
        if (row == -1) {
            return 0;
        }
        if (row < 0) {
            row = -(row + 2);
        }
        return row;
    }

    public int getColumn(int x) {
        int column = Arrays.binarySearch(this.mLeft, x);
        if (column == -1) {
            return 0;
        }
        if (column < 0) {
            column = -(column + 2);
        }
        return column;
    }

    public int getClosestRow(int y) {
        int row = Arrays.binarySearch(this.mTop, y);
        if (row == -1) {
            return 0;
        }
        if (row < 0) {
            row = -(row + 2);
        }
        if (this.getRowDistance(row, y) < this.getRowDistance(row + 1, y)) {
            return row;
        }
        return row + 1;
    }

    public int getClosestColumn(int x) {
        int column = Arrays.binarySearch(this.mLeft, x);
        if (column == -1) {
            return 0;
        }
        if (column < 0) {
            column = -(column + 2);
        }
        if (this.getColumnDistance(column, x) < this.getColumnDistance(column + 1, x)) {
            return column;
        }
        return column + 1;
    }

    public int getColumnDistance(int column, int x) {
        return Math.abs(this.getColumnX(column) - x);
    }

    public int getColumnActualWidth(int column) {
        return this.getColumnMaxX(column) - this.getColumnX(column);
    }

    public int getRowDistance(int row, int y) {
        return Math.abs(this.getRowY(row) - y);
    }

    public int getRowY(int row) {
        return this.mTop[Math.min(this.mTop.length - 1, Math.max(0, row))];
    }

    public int getRowMaxY(int row) {
        return this.mMaxBottom[Math.min(this.mMaxBottom.length - 1, Math.max(0, row))];
    }

    public int getRowActualHeight(int row) {
        return this.getRowMaxY(row) - this.getRowY(row);
    }

    public Collection<INode> getIntersectsRow(int y1, int y2) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (ViewData view : this.mChildViews) {
            Rect bounds;
            if (view.isSpacer() || (bounds = view.node.getBounds()).y2() < y1 || bounds.y > y2) continue;
            nodes.add(view.node);
        }
        return nodes;
    }

    public int getRowHeight(int row, int rowSpan) {
        return this.getRowY(row + rowSpan) - this.getRowY(row);
    }

    public int getColumnX(int column) {
        return this.mLeft[Math.min(this.mLeft.length - 1, Math.max(0, column))];
    }

    public int getColumnMaxX(int column) {
        return this.mMaxRight[Math.min(this.mMaxRight.length - 1, Math.max(0, column))];
    }

    public int getColumnWidth(int column, int columnSpan) {
        return this.getColumnX(column + columnSpan) - this.getColumnX(column);
    }

    public Rect getCellBounds(int row, int column, int rowSpan, int columnSpan) {
        return new Rect(this.getColumnX(column), this.getRowY(row), this.getColumnWidth(column, columnSpan), this.getRowHeight(row, rowSpan));
    }

    public String toString() {
        int col;
        int cellWidth = 25;
        ArrayList<Object> rowList = new ArrayList<Object>(this.mTop.length);
        int row = 0;
        while (row < this.mTop.length) {
            ArrayList columnList = new ArrayList(this.mLeft.length);
            col = 0;
            while (col < this.mLeft.length) {
                columnList.add(new ArrayList(4));
                ++col;
            }
            rowList.add(columnList);
            ++row;
        }
        block2: for (ViewData view : this.mChildViews) {
            int i = 0;
            while (i < view.rowSpan) {
                if (view.row + i > this.mTop.length || rowList.size() <= view.row + i) continue block2;
                int j = 0;
                while (j < view.columnSpan) {
                    List columnList = (List)rowList.get(view.row + i);
                    if (columnList.size() <= view.column + j) break;
                    ((List)columnList.get(view.column + j)).add(view);
                    ++j;
                }
                ++i;
            }
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.printf("%" + cellWidth + "s", "");
        col = 0;
        while (col < this.actualColumnCount + 1) {
            out.printf("|%-" + (cellWidth - 1) + "d", this.mLeft[col]);
            ++col;
        }
        out.printf("\n", new Object[0]);
        int row2 = 0;
        while (row2 < this.actualRowCount + 1) {
            out.printf("%" + cellWidth + "d", this.mTop[row2]);
            if (row2 == this.actualRowCount) break;
            int col2 = 0;
            while (col2 < this.actualColumnCount) {
                List views = (List)((List)rowList.get(row2)).get(col2);
                StringBuilder sb = new StringBuilder();
                for (ViewData view : views) {
                    String id;
                    String string = id = view != null ? view.getId() : "";
                    if (id.startsWith("@+id/")) {
                        id = id.substring("@+id/".length());
                    }
                    if (id.length() > cellWidth - 2) {
                        id = id.substring(0, cellWidth - 2);
                    }
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(id);
                }
                String cellString = sb.toString();
                if (cellString.contains(",") && cellString.length() > cellWidth - 2) {
                    cellString = String.valueOf(cellString.substring(0, cellWidth - 6)) + "...,";
                }
                out.printf("|%-" + (cellWidth - 2) + "s ", cellString);
                ++col2;
            }
            out.printf("\n", new Object[0]);
            ++row2;
        }
        out.flush();
        return stringWriter.toString();
    }

    public void splitColumn(int newColumn, boolean insertMarginColumn, int columnWidthDp, int x) {
        ++this.actualColumnCount;
        if (this.declaredColumnCount != Integer.MIN_VALUE) {
            ++this.declaredColumnCount;
            if (insertMarginColumn) {
                ++this.declaredColumnCount;
            }
            this.setGridAttribute(this.layout, "columnCount", this.declaredColumnCount);
        }
        boolean isLastColumn = true;
        for (ViewData view : this.mChildViews) {
            if (view.column < newColumn) continue;
            isLastColumn = false;
            break;
        }
        if (isLastColumn) {
            for (ViewData view : this.mChildViews) {
                if (view.column != 0 || view.row <= 0 || this.getGridAttribute(view.node, "layout_row") != null) continue;
                this.setGridAttribute(view.node, "layout_row", view.row);
            }
        }
        ViewData prevColumnSpacer = null;
        for (ViewData view : this.mChildViews) {
            if (view.column != newColumn - 1 || !view.isColumnSpacer()) continue;
            prevColumnSpacer = view;
            break;
        }
        for (ViewData view : this.mChildViews) {
            int endColumn;
            if (view == prevColumnSpacer) continue;
            INode node = view.node;
            int column = view.column;
            if (column > newColumn || column == newColumn && view.node.getBounds().x2() > x) {
                view.column = view.column + (insertMarginColumn ? 2 : 1);
                this.setGridAttribute(node, "layout_column", view.column);
                continue;
            }
            if (view.isSpacer() || (endColumn = column + view.columnSpan) <= newColumn && (endColumn != newColumn || view.node.getBounds().x2() <= x && (!GravityHelper.isConstrainedHorizontally(view.gravity) || GravityHelper.isLeftAligned(view.gravity)))) continue;
            view.columnSpan = view.columnSpan + (insertMarginColumn ? 2 : 1);
            this.setColumnSpanAttribute(node, view.columnSpan);
        }
        if (prevColumnSpacer != null) {
            int dp;
            int remaining;
            int px = this.getColumnWidth(newColumn - 1, 1);
            if (insertMarginColumn || columnWidthDp == 0) {
                px -= this.getColumnActualWidth(newColumn - 1);
            }
            if ((remaining = (dp = this.mRulesEngine.pxToDp(px)) - columnWidthDp) > 0) {
                prevColumnSpacer.node.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", String.format("%ddp", remaining));
                prevColumnSpacer.column = insertMarginColumn ? newColumn + 1 : newColumn;
                this.setGridAttribute(prevColumnSpacer.node, "layout_column", prevColumnSpacer.column);
            }
        }
        if (columnWidthDp > 0) {
            int index = prevColumnSpacer != null ? prevColumnSpacer.index : -1;
            this.addSpacer(this.layout, index, 0, insertMarginColumn ? newColumn : newColumn - 1, columnWidthDp, 1);
        }
    }

    public void splitRow(int newRow, boolean insertMarginRow, int rowHeightDp, int y) {
        ++this.actualRowCount;
        if (this.declaredRowCount != Integer.MIN_VALUE) {
            ++this.declaredRowCount;
            if (insertMarginRow) {
                ++this.declaredRowCount;
            }
            this.setGridAttribute(this.layout, "rowCount", this.declaredRowCount);
        }
        ViewData prevRowSpacer = null;
        for (ViewData view : this.mChildViews) {
            if (view.row != newRow - 1 || !view.isRowSpacer()) continue;
            prevRowSpacer = view;
            break;
        }
        for (ViewData view : this.mChildViews) {
            int endRow;
            if (view == prevRowSpacer) continue;
            INode node = view.node;
            int row = view.row;
            if (row > newRow || row == newRow && view.node.getBounds().y2() > y) {
                view.row = view.row + (insertMarginRow ? 2 : 1);
                this.setGridAttribute(node, "layout_row", view.row);
                continue;
            }
            if (view.isSpacer() || (endRow = row + view.rowSpan) <= newRow && (endRow != newRow || view.node.getBounds().y2() <= y && (!GravityHelper.isConstrainedVertically(view.gravity) || GravityHelper.isTopAligned(view.gravity)))) continue;
            view.rowSpan = view.rowSpan + (insertMarginRow ? 2 : 1);
            this.setRowSpanAttribute(node, view.rowSpan);
        }
        if (prevRowSpacer != null) {
            int dp;
            int remaining;
            int px = this.getRowHeight(newRow - 1, 1);
            if (insertMarginRow || rowHeightDp == 0) {
                px -= this.getRowActualHeight(newRow - 1);
            }
            if ((remaining = (dp = this.mRulesEngine.pxToDp(px)) - rowHeightDp) > 0) {
                prevRowSpacer.node.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", String.format("%ddp", remaining));
                prevRowSpacer.row = insertMarginRow ? newRow + 1 : newRow;
                this.setGridAttribute(prevRowSpacer.node, "layout_row", prevRowSpacer.row);
            }
        }
        if (rowHeightDp > 0) {
            int index = prevRowSpacer != null ? prevRowSpacer.index : -1;
            this.addSpacer(this.layout, index, insertMarginRow ? newRow : newRow - 1, 0, 1, rowHeightDp);
        }
    }

    public void setColumnSpanAttribute(INode node, int span) {
        this.setGridAttribute(node, "layout_columnSpan", span > 1 ? Integer.toString(span) : null);
    }

    public void setRowSpanAttribute(INode node, int span) {
        this.setGridAttribute(node, "layout_rowSpan", span > 1 ? Integer.toString(span) : null);
    }

    static int getChildIndex(INode[] children, INode target) {
        int index = 0;
        INode[] iNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            if (child == target) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public void onDeleted(@NonNull List<INode> nodes) {
        if (nodes.size() == 0) {
            return;
        }
        deleted = new HashSet<INode>();
        for (INode child : nodes) {
            fqcn = child.getFqcn();
            if (fqcn.equals("android.widget.Space") || fqcn.equals("android.support.v7.widget.Space")) continue;
            deleted.add(child);
        }
        usedColumns = new HashSet<Integer>(this.actualColumnCount);
        usedRows = new HashSet<Integer>(this.actualRowCount);
        columnSpacers = ArrayListMultimap.create((int)this.actualColumnCount, (int)2);
        rowSpacers = ArrayListMultimap.create((int)this.actualRowCount, (int)2);
        removedViews = new HashSet<ViewData>();
        for (ViewData view : this.mChildViews) {
            if (deleted.contains(view.node)) {
                removedViews.add(view);
                continue;
            }
            if (view.isColumnSpacer()) {
                columnSpacers.put((Object)view.column, (Object)view);
                continue;
            }
            if (view.isRowSpacer()) {
                rowSpacers.put((Object)view.row, (Object)view);
                continue;
            }
            usedColumns.add(view.column);
            usedRows.add(view.row);
        }
        if (usedColumns.size() == 0 || usedRows.size() == 0) {
            for (ViewData spacer : columnSpacers.values()) {
                this.layout.removeChild(spacer.node);
            }
            for (ViewData spacer : rowSpacers.values()) {
                this.layout.removeChild(spacer.node);
            }
            this.mChildViews.clear();
            this.actualColumnCount = 0;
            this.declaredColumnCount = 2;
            this.actualRowCount = 0;
            this.declaredRowCount = -2147483648;
            this.setGridAttribute(this.layout, "columnCount", 2);
            return;
        }
        columnMap = new int[this.actualColumnCount + 1];
        newColumn = 0;
        prevUsed = usedColumns.contains(0);
        column = 1;
        while (column < this.actualColumnCount) {
            used = usedColumns.contains(column);
            if (used || prevUsed != used) {
                prevUsed = used;
            }
            columnMap[column] = ++newColumn;
            ++column;
        }
        columnMap[this.actualColumnCount] = ++newColumn;
        if (!GridModel.$assertionsDisabled && columnMap[0] != 0) {
            throw new AssertionError();
        }
        rowMap = new int[this.actualRowCount + 1];
        newRow = 0;
        prevUsed = usedRows.contains(0);
        row = 1;
        while (row < this.actualRowCount) {
            used = usedRows.contains(row);
            if (used || prevUsed != used) {
                prevUsed = used;
            }
            rowMap[row] = ++newRow;
            ++row;
        }
        rowMap[this.actualRowCount] = ++newRow;
        if (!GridModel.$assertionsDisabled && rowMap[0] != 0) {
            throw new AssertionError();
        }
        for (ViewData view : this.mChildViews) {
            if (removedViews.contains(view)) continue;
            newColumnStart = columnMap[Math.min(columnMap.length - 1, view.column)];
            newColumnEnd = columnMap[Math.min(columnMap.length - 1, view.column + view.columnSpan)];
            if (newColumnStart != view.column) {
                view.column = newColumnStart;
                this.setGridAttribute(view.node, "layout_column", view.column);
            }
            if ((columnSpan = newColumnEnd - newColumnStart) != view.columnSpan && columnSpan >= 1) {
                view.columnSpan = columnSpan;
                this.setColumnSpanAttribute(view.node, view.columnSpan);
            }
            newRowStart = rowMap[Math.min(rowMap.length - 1, view.row)];
            newRowEnd = rowMap[Math.min(rowMap.length - 1, view.row + view.rowSpan)];
            if (newRowStart != view.row) {
                view.row = newRowStart;
                this.setGridAttribute(view.node, "layout_row", view.row);
            }
            if ((rowSpan = newRowEnd - newRowStart) == view.rowSpan || rowSpan < 1) continue;
            view.rowSpan = rowSpan;
            this.setRowSpanAttribute(view.node, view.rowSpan);
        }
        start = 0;
        ** GOTO lbl137
        {
            ++start;
            do {
                if (start < this.actualColumnCount && usedColumns.contains(start)) continue block7;
                if (start == this.actualColumnCount) break block7;
                if (!GridModel.$assertionsDisabled && usedColumns.contains(start)) {
                    throw new AssertionError();
                }
                end = start + 1;
                while (end < this.actualColumnCount) {
                    if (usedColumns.contains(end)) break;
                    ++end;
                }
                width = this.getColumnWidth(start, end - start);
                isFirstSpacer = true;
                column = start;
                while (column < end) {
                    spacers = columnSpacers.get((Object)column);
                    if (spacers != null && !spacers.isEmpty()) {
                        spacers = new ArrayList<E>(spacers);
                        for (ViewData spacer : spacers) {
                            if (isFirstSpacer) {
                                isFirstSpacer = false;
                                spacer.column = columnMap[start];
                                this.setGridAttribute(spacer.node, "layout_column", spacer.column);
                                if (end - start > 1) {
                                    columnWidthDp = this.mRulesEngine.pxToDp(width);
                                    spacer.node.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", String.format("%ddp", new Object[]{columnWidthDp}));
                                }
                                columnSpacers.put((Object)start, (Object)spacer);
                                continue;
                            }
                            removedViews.add(spacer);
                            this.layout.removeChild(spacer.node);
                        }
                    }
                    ++column;
                }
                if (isFirstSpacer) {
                    columnWidthDp = this.mRulesEngine.pxToDp(width);
                    this.addSpacer(this.layout, -1, -2147483648, columnMap[start], columnWidthDp, 15);
                }
                start = end;
lbl137:
                // 2 sources

            } while (start < this.actualColumnCount);
        }
        this.actualColumnCount = newColumn;
        start = 0;
        ** GOTO lbl182
        {
            ++start;
            do {
                if (start < this.actualRowCount && usedRows.contains(start)) continue block12;
                if (start == this.actualRowCount) break block12;
                if (!GridModel.$assertionsDisabled && usedRows.contains(start)) {
                    throw new AssertionError();
                }
                end = start + 1;
                while (end < this.actualRowCount) {
                    if (usedRows.contains(end)) break;
                    ++end;
                }
                height = this.getRowHeight(start, end - start);
                isFirstSpacer = true;
                row = start;
                while (row < end) {
                    spacers = rowSpacers.get((Object)row);
                    if (spacers != null && !spacers.isEmpty()) {
                        spacers = new ArrayList<E>(spacers);
                        for (ViewData spacer : spacers) {
                            if (isFirstSpacer) {
                                isFirstSpacer = false;
                                spacer.row = rowMap[start];
                                this.setGridAttribute(spacer.node, "layout_row", spacer.row);
                                if (end - start > 1) {
                                    rowHeightDp = this.mRulesEngine.pxToDp(height);
                                    spacer.node.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", String.format("%ddp", new Object[]{rowHeightDp}));
                                }
                                rowSpacers.put((Object)start, (Object)spacer);
                                continue;
                            }
                            removedViews.add(spacer);
                            this.layout.removeChild(spacer.node);
                        }
                    }
                    ++row;
                }
                if (isFirstSpacer) {
                    rowWidthDp = this.mRulesEngine.pxToDp(height);
                    this.addSpacer(this.layout, -1, rowMap[start], -2147483648, 100, rowWidthDp);
                }
                start = end;
lbl182:
                // 2 sources

            } while (start < this.actualRowCount);
        }
        this.actualRowCount = newRow;
        if (removedViews.size() <= 2) {
            this.mChildViews.removeAll(removedViews);
        } else {
            remaining = new ArrayList<ViewData>(this.mChildViews.size() - removedViews.size());
            for (ViewData view : this.mChildViews) {
                if (removedViews.contains(view)) continue;
                remaining.add(view);
            }
            this.mChildViews = remaining;
        }
        if (this.declaredColumnCount != -2147483648) {
            this.declaredColumnCount = this.actualColumnCount;
            this.setGridAttribute(this.layout, "columnCount", this.actualColumnCount);
        }
        if (this.declaredRowCount != -2147483648) {
            this.declaredRowCount = this.actualRowCount;
            this.setGridAttribute(this.layout, "rowCount", this.actualRowCount);
        }
    }

    ViewData addSpacer(INode parent, int index, int row, int column, int widthDp, int heightDp) {
        String tag = "android.widget.Space";
        String gridLayout = parent.getFqcn();
        if (!gridLayout.equals("GridLayout") && gridLayout.length() > "GridLayout".length()) {
            String pkg = gridLayout.substring(0, gridLayout.length() - "GridLayout".length());
            tag = String.valueOf(pkg) + "Space";
        }
        INode spacer = index != -1 ? parent.insertChildAt(tag, index) : parent.appendChild(tag);
        ViewData view = new ViewData(spacer, index != -1 ? index : this.mChildViews.size());
        this.mChildViews.add(view);
        if (row != Integer.MIN_VALUE) {
            view.row = row;
            this.setGridAttribute(spacer, "layout_row", row);
        }
        if (column != Integer.MIN_VALUE) {
            view.column = column;
            this.setGridAttribute(spacer, "layout_column", column);
        }
        if (widthDp > 0) {
            spacer.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", String.format("%ddp", widthDp));
        }
        if (heightDp > 0) {
            spacer.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", String.format("%ddp", heightDp));
        }
        if (GridLayoutRule.sDebugGridLayout) {
            String id = "@+id/spacer_" + Integer.toString(System.identityHashCode(spacer)).substring(0, 3);
            spacer.setAttribute("http://schemas.android.com/apk/res/android", "id", id);
        }
        return view;
    }

    public String getGridAttribute(INode node, String name) {
        return node.getStringAttr(this.getNamespace(), name);
    }

    private int getGridAttribute(INode node, String attribute, int defaultValue) {
        String valueString = node.getStringAttr(this.getNamespace(), attribute);
        if (valueString != null) {
            try {
                return Integer.decode(valueString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public int getViewCount() {
        return this.mChildViews.size();
    }

    public static boolean isSpace(String fqcn) {
        return "android.widget.Space".equals(fqcn) || "android.support.v7.widget.Space".equals(fqcn);
    }

    public class ViewData {
        public final INode node;
        public final int index;
        public int row;
        public int column;
        public int rowSpan;
        public int columnSpan;
        public int gravity;

        ViewData(INode n, int index) {
            this.node = n;
            this.index = index;
            this.column = GridModel.this.getGridAttribute(n, "layout_column", Integer.MIN_VALUE);
            this.columnSpan = GridModel.this.getGridAttribute(n, "layout_columnSpan", 1);
            this.row = GridModel.this.getGridAttribute(n, "layout_row", Integer.MIN_VALUE);
            this.rowSpan = GridModel.this.getGridAttribute(n, "layout_rowSpan", 1);
            this.gravity = GravityHelper.getGravity(GridModel.this.getGridAttribute(n, "layout_gravity"), 0);
        }

        void applyPositionAttributes() {
            GridModel.this.setGridAttribute(this.node, "layout_column", this.column);
            GridModel.this.setGridAttribute(this.node, "layout_row", this.row);
        }

        String getId() {
            String id = this.node.getStringAttr("http://schemas.android.com/apk/res/android", "id");
            if (id == null) {
                id = "<unknownid>";
                String fqn = this.node.getFqcn();
                fqn = fqn.substring(fqn.lastIndexOf(46) + 1);
                id = String.valueOf(fqn) + "-" + Integer.toString(System.identityHashCode(this.node)).substring(0, 3);
            }
            return id;
        }

        boolean isSpacer() {
            return GridModel.isSpace(this.node.getFqcn());
        }

        boolean isColumnSpacer() {
            return this.isSpacer() && (this.column > 0 || !SPACER_SIZE.equals(this.node.getStringAttr("http://schemas.android.com/apk/res/android", "layout_width")));
        }

        boolean isRowSpacer() {
            return this.isSpacer() && (this.row > 0 || !SPACER_SIZE.equals(this.node.getStringAttr("http://schemas.android.com/apk/res/android", "layout_height")));
        }
    }
}

