/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import java.net.URL;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

class ConvertSwitchDialog
extends TitleAreaDialog
implements SelectionListener {
    private static final String URL = "http://tools.android.com/tips/non-constant-fields";
    private final String mField;
    private Link mLink;

    public ConvertSwitchDialog(Shell parentShell, String field) {
        super(parentShell);
        this.mField = field;
        Image image = IconFactory.getInstance().getIcon("android-64");
        this.setTitleImage(image);
    }

    protected Control createDialogArea(Composite parent) {
        String text = String.format("As of ADT 14, the resource fields (such as %1$s) are no longer constants when defined in library projects. This is necessary to make library projects reusable without recompiling them.\n\nOne consequence of this is that you can no longer use the fields directly in switch statements. You must use an if-else chain instead.\n\nEclipse can automatically convert from a switch statement to an if-else statement. Just place the caret on the switch keyword and invoke Quick Fix (Ctrl-1 on Windows and Linux, Cmd-1 on Mac), then select \"Convert 'switch' to 'if-else'\".\n\nFor more information, see <a href=\"http://tools.android.com/tips/non-constant-fields\">http://tools.android.com/tips/non-constant-fields</a>", this.mField);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.mLink = new Link(container, 0);
        this.mLink.setLayoutData((Object)new GridData(16384, 128, true, true, 1, 1));
        this.mLink.setText(text);
        this.mLink.addSelectionListener((SelectionListener)this);
        this.setMessage("Non-Constant Expressions: Migration Necessary", 1);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    private void showWebPage() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWebBrowser browser = workbench.getBrowserSupport().getExternalBrowser();
            browser.openURL(new URL(URL));
        }
        catch (Exception exception) {
            String message = String.format("Could not open browser. Vist\n%1$s\ninstead.", URL);
            MessageDialog.openError((Shell)this.getShell(), (String)"Browser Error", (String)message);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 17) {
            this.showWebPage();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.mLink) {
            this.showWebPage();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

