/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.Messages;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class DexWrapper {
    private static final String DEX_MAIN = "com.android.dx.command.dexer.Main";
    private static final String DEX_CONSOLE = "com.android.dx.command.DxConsole";
    private static final String DEX_ARGS = "com.android.dx.command.dexer.Main$Arguments";
    private static final String MAIN_RUN = "run";
    private Method mRunMethod;
    private Constructor<?> mArgConstructor;
    private Field mArgOutName;
    private Field mArgVerbose;
    private Field mArgJarOutput;
    private Field mArgFileNames;
    private Field mArgForceJumbo;
    private Field mConsoleOut;
    private Field mConsoleErr;

    public synchronized IStatus loadDex(String osFilepath) {
        try {
            File f = new File(osFilepath);
            if (!f.isFile()) {
                return new Status(4, "com.android.ide.eclipse.adt", String.format(Messages.DexWrapper_s_does_not_exists, osFilepath));
            }
            URL url = f.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, DexWrapper.class.getClassLoader());
            Class<?> mainClass = loader.loadClass(DEX_MAIN);
            Class<?> consoleClass = loader.loadClass(DEX_CONSOLE);
            Class<?> argClass = loader.loadClass(DEX_ARGS);
            try {
                this.mRunMethod = mainClass.getMethod(MAIN_RUN, argClass);
                this.mArgConstructor = argClass.getConstructor(new Class[0]);
                this.mArgOutName = argClass.getField("outName");
                this.mArgJarOutput = argClass.getField("jarOutput");
                this.mArgFileNames = argClass.getField("fileNames");
                this.mArgVerbose = argClass.getField("verbose");
                this.mArgForceJumbo = argClass.getField("forceJumbo");
                this.mConsoleOut = consoleClass.getField("out");
                this.mConsoleErr = consoleClass.getField("err");
            }
            catch (SecurityException e) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_API, e);
            }
            catch (NoSuchMethodException e) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_Method, e);
            }
            catch (NoSuchFieldException e) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_Field, e);
            }
            return Status.OK_STATUS;
        }
        catch (MalformedURLException e) {
            return DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Failed_to_load_s, osFilepath), e);
        }
        catch (ClassNotFoundException e) {
            return DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Failed_to_load_s, osFilepath), e);
        }
    }

    public synchronized void unload() {
        this.mRunMethod = null;
        this.mArgConstructor = null;
        this.mArgOutName = null;
        this.mArgJarOutput = null;
        this.mArgFileNames = null;
        this.mArgVerbose = null;
        this.mConsoleOut = null;
        this.mConsoleErr = null;
        System.gc();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int run(String osOutFilePath, Collection<String> osFilenames, boolean forceJumbo, boolean verbose, PrintStream outStream, PrintStream errStream) throws CoreException {
        if (!DexWrapper.$assertionsDisabled && this.mRunMethod == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgConstructor == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgOutName == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgJarOutput == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgFileNames == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgForceJumbo == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgVerbose == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mConsoleOut == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mConsoleErr == null) {
            throw new AssertionError();
        }
        if (this.mRunMethod == null) {
            throw new CoreException(DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Unable_To_Execute_Dex_s, new Object[]{"wrapper was not properly loaded first"}), null));
        }
        try {
            this.mConsoleErr.set(null, errStream);
            this.mConsoleOut.set(null, outStream);
            args = this.mArgConstructor.newInstance(new Object[0]);
            this.mArgOutName.set(args, osOutFilePath);
            this.mArgFileNames.set(args, osFilenames.toArray(new String[osFilenames.size()]));
            this.mArgJarOutput.set(args, osOutFilePath.endsWith(".jar"));
            this.mArgForceJumbo.set(args, forceJumbo);
            this.mArgVerbose.set(args, verbose);
            res = this.mRunMethod.invoke(null, new Object[]{args});
            if (res instanceof Integer) {
                return (Integer)res;
            }
            return -1;
        }
        catch (Exception e) {
            t = e;
            ** while (t.getCause() != null)
        }
lbl-1000:
        // 1 sources

        {
            t = t.getCause();
            continue;
        }
lbl39:
        // 1 sources

        msg = t.getMessage();
        if (msg == null) {
            msg = String.format("%s. Check the Eclipse log for stack trace.", new Object[]{t.getClass().getName()});
        }
        throw new CoreException(DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Unable_To_Execute_Dex_s, new Object[]{msg}), t));
    }

    private static IStatus createErrorStatus(String message, Throwable e) {
        AdtPlugin.log(e, message, new Object[0]);
        AdtPlugin.printErrorToConsole(Messages.DexWrapper_Dex_Loader, message);
        return new Status(4, "com.android.ide.eclipse.adt", message, e);
    }
}

