/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors;

import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.IPageImageProvider;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.lint.EclipseLintRunner;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourceXmlTextAction;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AndroidXmlEditor
extends FormEditor {
    public static final String ICON_XML_PAGE = "editor_page_source";
    private static final String PREF_CURRENT_PAGE = "_current_page";
    private static String BROWSER_ID = "android";
    public static final String TEXT_EDITOR_ID = "editor_part";
    public static final int TEXT_WIDTH_HINT = 50;
    protected int mTextPageIndex;
    private StructuredTextEditor mTextEditor;
    private XmlModelStateListener mXmlModelStateListener;
    private Sdk.TargetChangeListener mTargetListener = null;
    private boolean mIsCreatingPage = false;
    private boolean mIgnoreXmlUpdate;
    private int mIsEditXmlModelPending;
    private UiElementNode mFormatNode;
    private boolean mFormatChildren;
    public static final int CATEGORY_LAYOUT = 1;
    public static final int CATEGORY_MANIFEST = 2;
    public static final int CATEGORY_OTHER = 4;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        AdtPlugin.getDefault().refreshSdk();
    }

    public void addDefaultTargetListener() {
        if (this.mTargetListener == null) {
            this.mTargetListener = new Sdk.TargetChangeListener(){

                @Override
                public IProject getProject() {
                    return AndroidXmlEditor.this.getProject();
                }

                @Override
                public void reload() {
                    AndroidXmlEditor.this.commitPages(false);
                    AndroidXmlEditor.this.initUiRootNode(true);
                }
            };
            AdtPlugin.getDefault().addTargetListener(this.mTargetListener);
        }
    }

    public abstract UiElementNode getUiRootNode();

    protected abstract void createFormPages();

    protected void postCreatePages() {
    }

    protected abstract void initUiRootNode(boolean var1);

    protected abstract void xmlModelChanged(Document var1);

    public void setIgnoreXmlUpdate(boolean ignore) {
        this.mIgnoreXmlUpdate = ignore;
    }

    public boolean getIgnoreXmlUpdate() {
        return this.mIgnoreXmlUpdate;
    }

    public Object getAdapter(Class adapter) {
        Object result = super.getAdapter(adapter);
        if (result != null && adapter.equals(IGotoMarker.class)) {
            final IGotoMarker gotoMarker = (IGotoMarker)result;
            return new IGotoMarker(){

                public void gotoMarker(IMarker marker) {
                    gotoMarker.gotoMarker(marker);
                    try {
                        IEditorPart editor;
                        if (marker.getType().equals("com.android.ide.eclipse.adt.lintProblem") && (editor = AdtUtils.getActiveEditor()) instanceof AndroidXmlEditor) {
                            AndroidXmlEditor xmlEditor = (AndroidXmlEditor)editor;
                            xmlEditor.setActivePage(AndroidXmlEditor.TEXT_EDITOR_ID);
                        }
                    }
                    catch (CoreException e) {
                        AdtPlugin.log(e, null, new Object[0]);
                    }
                }
            };
        }
        if (result == null && adapter == IContentOutlinePage.class) {
            return this.getStructuredTextEditor().getAdapter(adapter);
        }
        return result;
    }

    protected void addPages() {
        this.createAndroidPages();
        this.selectDefaultPage(null);
    }

    public void createAndroidPages() {
        this.mIsCreatingPage = true;
        this.createFormPages();
        this.createTextEditor();
        this.updateActionBindings();
        this.postCreatePages();
        this.mIsCreatingPage = false;
    }

    public boolean isCreatingPages() {
        return this.mIsCreatingPage;
    }

    public int addPage(IFormPage page) throws PartInitException {
        int index = super.addPage(page);
        if (page instanceof IPageImageProvider) {
            this.setPageImage(index, ((IPageImageProvider)page).getPageImage());
        }
        return index;
    }

    public int addPage(IEditorPart editor, IEditorInput input) throws PartInitException {
        int index = super.addPage(editor, input);
        if (editor instanceof IPageImageProvider) {
            this.setPageImage(index, ((IPageImageProvider)editor).getPageImage());
        }
        return index;
    }

    protected void updateActionBindings() {
        IActionBars bars = this.getEditorSite().getActionBars();
        if (bars != null) {
            IAction action = this.mTextEditor.getAction(ActionFactory.UNDO.getId());
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), action);
            action = this.mTextEditor.getAction(ActionFactory.REDO.getId());
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), action);
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.mTextEditor.getAction(ActionFactory.DELETE.getId()));
            bars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.mTextEditor.getAction(ActionFactory.CUT.getId()));
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.mTextEditor.getAction(ActionFactory.COPY.getId()));
            bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.mTextEditor.getAction(ActionFactory.PASTE.getId()));
            bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.mTextEditor.getAction(ActionFactory.SELECT_ALL.getId()));
            bars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.mTextEditor.getAction(ActionFactory.FIND.getId()));
            bars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.mTextEditor.getAction(IDEActionFactory.BOOKMARK.getId()));
            bars.updateActionBars();
        }
    }

    protected void clearActionBindings(boolean includeUndoRedo) {
        IActionBars bars = this.getEditorSite().getActionBars();
        if (bars != null) {
            if (includeUndoRedo) {
                bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
                bars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
            }
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            bars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
            bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
            bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
            bars.setGlobalActionHandler(ActionFactory.FIND.getId(), null);
            bars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), null);
            bars.updateActionBars();
        }
    }

    public void selectDefaultPage(String defaultPageId) {
        IFile file;
        if (defaultPageId == null && (file = this.getInputFile()) != null) {
            QualifiedName qname = new QualifiedName("com.android.ide.eclipse.adt", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + PREF_CURRENT_PAGE);
            try {
                String pageId = file.getPersistentProperty(qname);
                if (pageId != null) {
                    defaultPageId = pageId;
                }
            }
            catch (CoreException coreException) {}
        }
        if (defaultPageId != null) {
            try {
                this.setActivePage(Integer.parseInt(defaultPageId));
            }
            catch (Exception e) {
                AdtPlugin.log(e, "Selecting page '%s' in AndroidXmlEditor failed", defaultPageId);
            }
        } else if (AdtPrefs.getPrefs().isXmlEditorPreferred(this.getPersistenceCategory())) {
            this.setActivePage(this.mTextPageIndex);
        }
    }

    protected int getPersistenceCategory() {
        return 4;
    }

    protected void removePages() {
        int count = this.getPageCount();
        int i = count - 1;
        while (i >= 0) {
            this.removePage(i);
            --i;
        }
    }

    public IFormPage setActivePage(String pageId) {
        if (pageId.equals(TEXT_EDITOR_ID)) {
            super.setActivePage(this.mTextPageIndex);
            return null;
        }
        return super.setActivePage(pageId);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (this.mIsCreatingPage) {
            return;
        }
        IFile file = this.getInputFile();
        if (file != null) {
            QualifiedName qname = new QualifiedName("com.android.ide.eclipse.adt", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + PREF_CURRENT_PAGE);
            try {
                file.setPersistentProperty(qname, Integer.toString(newPageIndex));
            }
            catch (CoreException coreException) {}
        }
        boolean isTextPage = newPageIndex == this.mTextPageIndex;
        AdtPrefs.getPrefs().setXmlEditorPreferred(this.getPersistenceCategory(), isTextPage);
    }

    public boolean isEditorPageActive() {
        return this.getActivePage() == this.mTextPageIndex;
    }

    @Nullable
    public IFile getInputFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public void dispose() {
        IStructuredModel xml_model = this.getModelForRead();
        if (xml_model != null) {
            try {
                if (this.mXmlModelStateListener != null) {
                    xml_model.removeModelStateListener((IModelStateListener)this.mXmlModelStateListener);
                }
            }
            finally {
                xml_model.releaseFromRead();
            }
        }
        if (this.mTargetListener != null) {
            AdtPlugin.getDefault().removeTargetListener(this.mTargetListener);
            this.mTargetListener = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IAction action;
        this.commitPages(true);
        if (AdtPrefs.getPrefs().isFormatOnSave() && (action = this.mTextEditor.getAction("FormatDocument")) != null) {
            try {
                this.mIgnoreXmlUpdate = true;
                action.run();
            }
            finally {
                this.mIgnoreXmlUpdate = false;
            }
        }
        this.getEditor(this.mTextPageIndex).doSave(monitor);
        if (AdtPrefs.getPrefs().isLintOnSave()) {
            this.runLint();
        }
    }

    protected Job runLint() {
        return this.startLintJob();
    }

    @Nullable
    public Job startLintJob() {
        IFile file = this.getInputFile();
        if (file != null) {
            return EclipseLintRunner.startLint(Collections.singletonList(file), (IResource)file, (IDocument)this.getStructuredDocument(), false, false);
        }
        return null;
    }

    public void doSaveAs() {
        this.commitPages(true);
        IEditorPart editor = this.getEditor(this.mTextPageIndex);
        editor.doSaveAs();
        this.setPageText(this.mTextPageIndex, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void commitPages(boolean onSave) {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                IFormPage form_page;
                IManagedForm managed_form;
                Object page = this.pages.get(i);
                if (page != null && page instanceof IFormPage && (managed_form = (form_page = (IFormPage)page).getManagedForm()) != null && managed_form.isDirty()) {
                    managed_form.commit(onSave);
                }
                ++i;
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public int getTextPageIndex() {
        return this.mTextPageIndex;
    }

    public final IHyperlinkListener createHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                super.linkActivated(e);
                String link = e.data.toString();
                if (link.startsWith("http") || link.startsWith("file:/")) {
                    AndroidXmlEditor.this.openLinkInBrowser(link);
                } else if (link.startsWith("page:")) {
                    AndroidXmlEditor.this.setActivePage(link.substring(5));
                }
            }
        };
    }

    private void openLinkInBrowser(String link) {
        try {
            IWorkbenchBrowserSupport wbs = WorkbenchBrowserSupport.getInstance();
            wbs.createBrowser(BROWSER_ID).openURL(new URL(link));
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void createTextEditor() {
        block8: {
            try {
                int index;
                this.mTextEditor = new StructuredTextEditor(){

                    protected void createActions() {
                        super.createActions();
                        RenameResourceXmlTextAction action = new RenameResourceXmlTextAction((ITextEditor)AndroidXmlEditor.this.mTextEditor);
                        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.rename.element");
                        this.setAction("org.eclipse.jdt.ui.edit.text.java.rename.element", (IAction)action);
                    }
                };
                this.mTextPageIndex = index = this.addPage((IEditorPart)this.mTextEditor, this.getEditorInput());
                this.setPageText(index, this.mTextEditor.getTitle());
                this.setPageImage(index, IconFactory.getInstance().getIcon(ICON_XML_PAGE));
                if (!(this.mTextEditor.getTextViewer().getDocument() instanceof IStructuredDocument)) {
                    Status status = new Status(4, "com.android.ide.eclipse.adt", "Error opening the Android XML editor. Is the document an XML file?");
                    throw new RuntimeException("Android XML Editor Error", new CoreException((IStatus)status));
                }
                IStructuredModel xml_model = this.getModelForRead();
                if (xml_model == null) break block8;
                try {
                    try {
                        this.mXmlModelStateListener = new XmlModelStateListener();
                        xml_model.addModelStateListener((IModelStateListener)this.mXmlModelStateListener);
                        this.mXmlModelStateListener.modelChanged(xml_model);
                    }
                    catch (Exception e) {
                        AdtPlugin.log(e, "Error while loading editor", new Object[0]);
                        xml_model.releaseFromRead();
                    }
                }
                finally {
                    xml_model.releaseFromRead();
                }
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Android XML Editor Error", null, (IStatus)e.getStatus());
            }
        }
    }

    public final ISourceViewer getStructuredSourceViewer() {
        if (this.mTextEditor != null) {
            return this.mTextEditor.getTextViewer();
        }
        return null;
    }

    public StructuredTextEditor getStructuredTextEditor() {
        return this.mTextEditor;
    }

    public IStructuredDocument getStructuredDocument() {
        if (this.mTextEditor != null && this.mTextEditor.getTextViewer() != null) {
            return (IStructuredDocument)this.mTextEditor.getTextViewer().getDocument();
        }
        return null;
    }

    public IStructuredModel getModelForRead() {
        IModelManager mm;
        IStructuredDocument document = this.getStructuredDocument();
        if (document != null && (mm = StructuredModelManager.getModelManager()) != null) {
            return mm.getModelForRead(document);
        }
        return null;
    }

    private IStructuredModel getModelForEdit() {
        IModelManager mm;
        IStructuredDocument document = this.getStructuredDocument();
        if (document != null && (mm = StructuredModelManager.getModelManager()) != null) {
            return mm.getModelForEdit(document);
        }
        return null;
    }

    public final void wrapEditXmlModel(Runnable editAction) {
        this.wrapEditXmlModel(editAction, null);
    }

    public void runEditHooks() {
        if (!this.mIgnoreXmlUpdate && AdtPrefs.getPrefs().isLintOnSave()) {
            this.runLint();
        }
    }

    private final void wrapEditXmlModel(final Runnable editAction, final String undoLabel) {
        block59: {
            int undoReverseCount;
            IStructuredModel model;
            block57: {
                block58: {
                    Display display = this.mTextEditor.getSite().getShell().getDisplay();
                    if (display.getThread() != Thread.currentThread()) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!AndroidXmlEditor.this.mTextEditor.getTextViewer().getControl().isDisposed()) {
                                    AndroidXmlEditor.this.wrapEditXmlModel(editAction, undoLabel);
                                }
                            }
                        });
                        return;
                    }
                    model = null;
                    undoReverseCount = 0;
                    try {
                        if (this.mIsEditXmlModelPending != 0) break block57;
                        try {
                            model = this.getModelForEdit();
                            if (undoLabel != null) {
                                int i = 0;
                                while (i < 4) {
                                    model.beginRecording((Object)this, undoLabel);
                                    ++undoReverseCount;
                                    ++i;
                                }
                            }
                            model.aboutToChangeModel();
                            break block57;
                        }
                        catch (Throwable t) {
                            AdtPlugin.log(t, "XML Editor failed to get model to edit", new Object[0]);
                            --this.mIsEditXmlModelPending;
                            if (model == null) break block58;
                            try {
                                boolean oldIgnore = this.mIgnoreXmlUpdate;
                                try {
                                    this.mIgnoreXmlUpdate = true;
                                    if (AdtPrefs.getPrefs().getFormatGuiXml() && this.mFormatNode != null) {
                                        if (this.mFormatNode == this.getUiRootNode()) {
                                            this.reformatDocument();
                                        } else {
                                            Node node = this.mFormatNode.getXmlNode();
                                            if (node instanceof IndexedRegion) {
                                                IndexedRegion region = (IndexedRegion)node;
                                                int begin = region.getStartOffset();
                                                int end = region.getEndOffset();
                                                if (!this.mFormatChildren) {
                                                    end = begin + 1;
                                                }
                                                if (this.mFormatChildren && node == node.getOwnerDocument().getDocumentElement()) {
                                                    this.reformatDocument();
                                                } else {
                                                    this.reformatRegion(begin, end);
                                                }
                                            }
                                        }
                                        this.mFormatNode = null;
                                        this.mFormatChildren = false;
                                    }
                                    model.changedModel();
                                    int i = 0;
                                    while (i < undoReverseCount) {
                                        model.endRecording((Object)this);
                                        ++i;
                                    }
                                }
                                finally {
                                    this.mIgnoreXmlUpdate = oldIgnore;
                                }
                            }
                            catch (Exception e) {
                                AdtPlugin.log(e, "Failed to clean up undo unit", new Object[0]);
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    model.releaseFromEdit();
                    if (this.mIsEditXmlModelPending < 0) {
                        AdtPlugin.log(4, "wrapEditXmlModel finished with invalid nested counter==%1$d", this.mIsEditXmlModelPending);
                        this.mIsEditXmlModelPending = 0;
                    }
                    this.runEditHooks();
                    IStructuredModel readModel = this.getModelForRead();
                    if (readModel != null) {
                        try {
                            try {
                                this.mXmlModelStateListener.modelChanged(readModel);
                            }
                            catch (Exception e) {
                                AdtPlugin.log(e, "Error while notifying changes", new Object[0]);
                                readModel.releaseFromRead();
                            }
                        }
                        finally {
                            readModel.releaseFromRead();
                        }
                    }
                }
                return;
            }
            try {
                ++this.mIsEditXmlModelPending;
                editAction.run();
            }
            finally {
                --this.mIsEditXmlModelPending;
                if (model == null) break block59;
                try {
                    boolean oldIgnore = this.mIgnoreXmlUpdate;
                    try {
                        this.mIgnoreXmlUpdate = true;
                        if (AdtPrefs.getPrefs().getFormatGuiXml() && this.mFormatNode != null) {
                            if (this.mFormatNode == this.getUiRootNode()) {
                                this.reformatDocument();
                            } else {
                                Node node = this.mFormatNode.getXmlNode();
                                if (node instanceof IndexedRegion) {
                                    IndexedRegion region = (IndexedRegion)node;
                                    int begin = region.getStartOffset();
                                    int end = region.getEndOffset();
                                    if (!this.mFormatChildren) {
                                        end = begin + 1;
                                    }
                                    if (this.mFormatChildren && node == node.getOwnerDocument().getDocumentElement()) {
                                        this.reformatDocument();
                                    } else {
                                        this.reformatRegion(begin, end);
                                    }
                                }
                            }
                            this.mFormatNode = null;
                            this.mFormatChildren = false;
                        }
                        model.changedModel();
                        int i = 0;
                        while (i < undoReverseCount) {
                            model.endRecording((Object)this);
                            ++i;
                        }
                    }
                    finally {
                        this.mIgnoreXmlUpdate = oldIgnore;
                    }
                }
                catch (Exception e) {
                    AdtPlugin.log(e, "Failed to clean up undo unit", new Object[0]);
                }
            }
            model.releaseFromEdit();
            if (this.mIsEditXmlModelPending < 0) {
                AdtPlugin.log(4, "wrapEditXmlModel finished with invalid nested counter==%1$d", this.mIsEditXmlModelPending);
                this.mIsEditXmlModelPending = 0;
            }
            this.runEditHooks();
            IStructuredModel readModel = this.getModelForRead();
            if (readModel != null) {
                try {
                    try {
                        this.mXmlModelStateListener.modelChanged(readModel);
                    }
                    catch (Exception e) {
                        AdtPlugin.log(e, "Error while notifying changes", new Object[0]);
                        readModel.releaseFromRead();
                    }
                }
                finally {
                    readModel.releaseFromRead();
                }
            }
        }
    }

    public boolean supportsFormatOnGuiEdit() {
        return false;
    }

    public void scheduleNodeReformat(UiElementNode node, boolean attributesOnly) {
        if (!this.supportsFormatOnGuiEdit()) {
            return;
        }
        if (node == this.mFormatNode) {
            if (!attributesOnly) {
                this.mFormatChildren = true;
            }
        } else if (this.mFormatNode == null) {
            this.mFormatNode = node;
            this.mFormatChildren = !attributesOnly;
        } else if (this.mFormatNode.isAncestorOf(node)) {
            this.mFormatChildren = true;
        } else if (node.isAncestorOf(this.mFormatNode)) {
            this.mFormatNode = node;
            this.mFormatChildren = true;
        } else {
            this.mFormatChildren = true;
            this.mFormatNode = UiElementNode.getCommonAncestor(this.mFormatNode, node);
        }
    }

    public void wrapUndoEditXmlModel(String label, Runnable undoableAction) {
        assert (label != null) : "All undoable actions should have a label";
        this.wrapEditXmlModel(undoableAction, label == null ? "" : label);
    }

    public boolean isEditXmlModelPending() {
        return this.mIsEditXmlModelPending > 0;
    }

    public final Document getXmlDocument(IStructuredModel model) {
        if (model == null) {
            AdtPlugin.log(2, "Android Editor: No XML model for root node.", new Object[0]);
            return null;
        }
        if (model instanceof IDOMModel) {
            IDOMModel dom_model = (IDOMModel)model;
            return dom_model.getDocument();
        }
        return null;
    }

    @Nullable
    public IProject getProject() {
        IFile file = this.getInputFile();
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    @Nullable
    public AndroidTargetData getTargetData() {
        IAndroidTarget target;
        Sdk currentSdk;
        IProject project = this.getProject();
        if (project != null && (currentSdk = Sdk.getCurrent()) != null && (target = currentSdk.getTarget(project)) != null) {
            return currentSdk.getTargetData(target);
        }
        IEditorInput input = this.getEditorInput();
        if (input instanceof IURIEditorInput) {
            IURIEditorInput urlInput = (IURIEditorInput)input;
            Sdk currentSdk2 = Sdk.getCurrent();
            if (currentSdk2 != null) {
                try {
                    IAndroidTarget[] targets;
                    String path = AdtUtils.getFile(urlInput.getURI().toURL()).getPath();
                    IAndroidTarget[] iAndroidTargetArray = targets = currentSdk2.getTargets();
                    int n = targets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAndroidTarget target2 = iAndroidTargetArray[n2];
                        if (path.startsWith(target2.getLocation())) {
                            return currentSdk2.getTargetData(target2);
                        }
                        ++n2;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return null;
    }

    public boolean show(Node xmlNode) {
        if (xmlNode instanceof IndexedRegion) {
            IndexedRegion region = (IndexedRegion)xmlNode;
            IEditorPart textPage = this.getEditor(this.mTextPageIndex);
            if (textPage instanceof StructuredTextEditor) {
                StructuredTextEditor editor = (StructuredTextEditor)textPage;
                this.setActivePage(TEXT_EDITOR_ID);
                int regionLength = region.getEndOffset() - region.getStartOffset();
                editor.selectAndReveal(region.getStartOffset(), regionLength);
                return true;
            }
        }
        return false;
    }

    public void show(int start, int length, boolean frontTab) {
        IEditorPart textPage = this.getEditor(this.mTextPageIndex);
        if (textPage instanceof StructuredTextEditor) {
            StructuredTextEditor editor = (StructuredTextEditor)textPage;
            if (frontTab) {
                this.setActivePage(TEXT_EDITOR_ID);
            }
            editor.selectAndReveal(start, length);
            if (frontTab) {
                editor.setFocus();
            }
        }
    }

    public boolean hasMultiplePages() {
        return this.getPageCount() > 1;
    }

    public String getXmlText(Node xmlNode) {
        String data = null;
        IStructuredModel model = this.getModelForRead();
        try {
            try {
                IStructuredDocument document = this.getStructuredDocument();
                if (xmlNode instanceof NodeContainer) {
                    data = ((NodeContainer)xmlNode).getSource();
                } else if (xmlNode instanceof IndexedRegion && document != null) {
                    IndexedRegion region = (IndexedRegion)xmlNode;
                    int start = region.getStartOffset();
                    int end = region.getEndOffset();
                    if (end > start) {
                        data = document.get(start, end - start);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                model.releaseFromRead();
            }
        }
        finally {
            model.releaseFromRead();
        }
        return data;
    }

    public void reformatRegion(int begin, int end) {
        int operation;
        StructuredTextViewer structuredTextViewer;
        boolean canFormat;
        ISourceViewer textViewer = this.getStructuredSourceViewer();
        IDocument document = textViewer.getDocument();
        int documentLength = document.getLength();
        end = Math.min(end, documentLength);
        begin = Math.min(begin, end);
        if (!AdtPrefs.getPrefs().getUseCustomXmlFormatter()) {
            try {
                IRegion lineInformation = document.getLineInformationOfOffset(begin);
                if (lineInformation != null) {
                    int lineBegin = lineInformation.getOffset();
                    if (lineBegin != begin) {
                        begin = lineBegin;
                    } else if (begin > 0) {
                        --begin;
                    }
                }
            }
            catch (BadLocationException e) {
                AdtPlugin.log(e, e.toString(), new Object[0]);
            }
        }
        if (textViewer instanceof StructuredTextViewer && (canFormat = (structuredTextViewer = (StructuredTextViewer)textViewer).canDoOperation(operation = 15))) {
            StyledText textWidget = textViewer.getTextWidget();
            textWidget.setSelection(begin, end);
            boolean oldIgnore = this.mIgnoreXmlUpdate;
            try {
                this.mIgnoreXmlUpdate = true;
                structuredTextViewer.doOperation(operation);
            }
            finally {
                this.mIgnoreXmlUpdate = oldIgnore;
            }
            textWidget.setSelection(0, 0);
        }
    }

    public void invokeContentAssist(int offset) {
        int operation;
        StructuredTextViewer structuredTextViewer;
        boolean allowed;
        ISourceViewer textViewer = this.getStructuredSourceViewer();
        if (textViewer instanceof StructuredTextViewer && (allowed = (structuredTextViewer = (StructuredTextViewer)textViewer).canDoOperation(operation = 13))) {
            if (offset != -1) {
                StyledText textWidget = textViewer.getTextWidget();
                IDocument document = textViewer.getDocument();
                int documentLength = document.getLength();
                offset = Math.max(0, Math.min(offset, documentLength));
                textWidget.setSelection(offset, offset);
            }
            structuredTextViewer.doOperation(operation);
        }
    }

    public void reformatNode(Node node) {
        if (this.mIsCreatingPage) {
            return;
        }
        if (node instanceof IndexedRegion) {
            IndexedRegion region = (IndexedRegion)node;
            int begin = region.getStartOffset();
            int end = region.getEndOffset();
            this.reformatRegion(begin, end);
        }
    }

    public void reformatDocument() {
        int operation;
        StructuredTextViewer structuredTextViewer;
        boolean canFormat;
        ISourceViewer textViewer = this.getStructuredSourceViewer();
        if (textViewer instanceof StructuredTextViewer && (canFormat = (structuredTextViewer = (StructuredTextViewer)textViewer).canDoOperation(operation = 23))) {
            boolean oldIgnore = this.mIgnoreXmlUpdate;
            try {
                this.mIgnoreXmlUpdate = true;
                structuredTextViewer.doOperation(operation);
            }
            finally {
                this.mIgnoreXmlUpdate = oldIgnore;
            }
        }
    }

    public String getIndent(Node xmlNode) {
        return AndroidXmlEditor.getIndent((IDocument)this.getStructuredDocument(), xmlNode);
    }

    public static String getIndent(IDocument document, Node xmlNode) {
        if (xmlNode instanceof IndexedRegion) {
            IndexedRegion region = (IndexedRegion)xmlNode;
            int startOffset = region.getStartOffset();
            return AndroidXmlEditor.getIndentAtOffset(document, startOffset);
        }
        return "";
    }

    public static String getIndentAtOffset(IDocument document, int offset) {
        try {
            int lineBegin;
            IRegion lineInformation = document.getLineInformationOfOffset(offset);
            if (lineInformation != null && (lineBegin = lineInformation.getOffset()) != offset) {
                String prefix = document.get(lineBegin, offset - lineBegin);
                int i = 0;
                while (i < prefix.length()) {
                    if (!Character.isWhitespace(prefix.charAt(i))) {
                        return prefix.substring(0, i);
                    }
                    ++i;
                }
                return prefix;
            }
        }
        catch (BadLocationException e) {
            AdtPlugin.log(e, "Could not obtain indentation", new Object[0]);
        }
        return "";
    }

    public static AndroidXmlEditor fromTextViewer(ITextViewer viewer) {
        IWorkbenchWindow wwin = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wwin != null) {
            ISourceViewer ssviewer;
            IEditorPart editor;
            IWorkbenchPage page = wwin.getActivePage();
            if (page != null && (editor = page.getActiveEditor()) instanceof AndroidXmlEditor && (ssviewer = ((AndroidXmlEditor)editor).getStructuredSourceViewer()) == viewer) {
                return (AndroidXmlEditor)editor;
            }
            IWorkbenchPage[] iWorkbenchPageArray = wwin.getPages();
            int n = iWorkbenchPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page2 = iWorkbenchPageArray[n2];
                if (page2 != null) {
                    IEditorReference[] iEditorReferenceArray = page2.getEditorReferences();
                    int n3 = iEditorReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISourceViewer ssviewer2;
                        IEditorReference editorRef = iEditorReferenceArray[n4];
                        IEditorPart editor2 = editorRef.getEditor(false);
                        if (editor2 instanceof AndroidXmlEditor && (ssviewer2 = ((AndroidXmlEditor)editor2).getStructuredSourceViewer()) == viewer) {
                            return (AndroidXmlEditor)editor2;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public void activated() {
        if (this.getActivePage() == this.mTextPageIndex) {
            this.updateActionBindings();
        }
    }

    public void deactivated() {
    }

    private class XmlModelStateListener
    implements IModelStateListener {
        private XmlModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelChanged(IStructuredModel model) {
            if (AndroidXmlEditor.this.mIgnoreXmlUpdate) {
                return;
            }
            AndroidXmlEditor.this.xmlModelChanged(AndroidXmlEditor.this.getXmlDocument(model));
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }
    }
}

