/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationMenuListener;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Locale;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderPreviewMode;
import com.android.ide.eclipse.adt.internal.wizards.newxmlfile.AddTranslationDialog;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

class LocaleMenuListener
extends SelectionAdapter {
    private static final int ACTION_SET_LOCALE = 1;
    private static final int ACTION_ADD_TRANSLATION = 2;
    private final ConfigurationChooser mConfigChooser;
    private final int mAction;
    private final Locale mLocale;

    LocaleMenuListener(@NonNull ConfigurationChooser configChooser, int action, @Nullable Locale locale) {
        this.mConfigChooser = configChooser;
        this.mAction = action;
        this.mLocale = locale;
    }

    public void widgetSelected(SelectionEvent e) {
        switch (this.mAction) {
            case 1: {
                this.mConfigChooser.selectLocale(this.mLocale);
                this.mConfigChooser.onLocaleChange();
                break;
            }
            case 2: {
                IProject project = this.mConfigChooser.getProject();
                Shell shell = this.mConfigChooser.getShell();
                AddTranslationDialog dialog = new AddTranslationDialog(shell, project);
                dialog.open();
                break;
            }
            default: {
                assert (false) : this.mAction;
                break;
            }
        }
    }

    static void show(ConfigurationChooser chooser, ToolItem combo) {
        Menu menu = new Menu((Decorations)chooser.getShell(), 8);
        Configuration configuration = chooser.getConfiguration();
        List<Locale> locales = chooser.getLocaleList();
        Locale current = configuration.getLocale();
        for (Locale locale : locales) {
            boolean selected;
            String title = ConfigurationChooser.getLocaleLabel(chooser, locale, false);
            MenuItem item = new MenuItem(menu, 32);
            item.setText(title);
            Image image = locale.getFlagImage();
            item.setImage(image);
            boolean bl = selected = current == locale;
            if (selected) {
                item.setSelection(true);
            }
            LocaleMenuListener listener = new LocaleMenuListener(chooser, 1, locale);
            item.addSelectionListener((SelectionListener)listener);
        }
        if (locales.size() > 1) {
            new MenuItem(menu, 2);
            ConfigurationMenuListener.addTogglePreviewModeAction(menu, "Preview All Locales", chooser, RenderPreviewMode.LOCALES);
        }
        new MenuItem(menu, 2);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Add New Translation...");
        LocaleMenuListener listener = new LocaleMenuListener(chooser, 2, null);
        item.addSelectionListener((SelectionListener)listener);
        Rectangle bounds = combo.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = combo.getParent().toDisplay(location);
        menu.setLocation(location.x, location.y);
        menu.setVisible(true);
    }
}

