/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.Rect;
import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.ContextPullParser;
import com.android.ide.eclipse.adt.internal.editors.layout.ProjectCallback;
import com.android.ide.eclipse.adt.internal.editors.layout.UiElementPullParser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Locale;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.IncludeFinder;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeProxy;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.xmlpull.v1.XmlPullParserException;

public class RenderService {
    private static final Object RENDERING_LOCK = new Object();
    private final GraphicalEditorPart mEditor;
    private final IProject mProject;
    private final ProjectCallback mProjectCallback;
    private final ResourceResolver mResourceResolver;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    private final LayoutLibrary mLayoutLib;
    private final IImageFactory mImageFactory;
    private final HardwareConfigHelper mHardwareConfigHelper;
    private final Locale mLocale;
    private UiDocumentNode mModel;
    private IncludeFinder.Reference mIncludedWithin;
    private SessionParams.RenderingMode mRenderingMode = SessionParams.RenderingMode.NORMAL;
    private LayoutLog mLogger;
    private Integer mOverrideBgColor;
    private boolean mShowDecorations = true;
    private Set<UiElementNode> mExpandNodes = Collections.emptySet();
    private final Object mCredential;

    private RenderService(GraphicalEditorPart editor, Object credential) {
        this.mEditor = editor;
        this.mCredential = credential;
        this.mProject = editor.getProject();
        LayoutCanvas canvas = editor.getCanvasControl();
        this.mImageFactory = canvas.getImageOverlay();
        ConfigurationChooser chooser = editor.getConfigurationChooser();
        Configuration config = chooser.getConfiguration();
        FolderConfiguration folderConfig = config.getFullConfig();
        Device device = config.getDevice();
        assert (device != null);
        this.mHardwareConfigHelper = new HardwareConfigHelper(device);
        this.mHardwareConfigHelper.setOrientation(folderConfig.getScreenOrientationQualifier().getValue());
        this.mLayoutLib = editor.getReadyLayoutLib(true);
        this.mResourceResolver = editor.getResourceResolver();
        this.mProjectCallback = editor.getProjectCallback(true, this.mLayoutLib);
        this.mMinSdkVersion = editor.getMinSdkVersion();
        this.mTargetSdkVersion = editor.getTargetSdkVersion();
        this.mLocale = config.getLocale();
    }

    private RenderService(GraphicalEditorPart editor, Configuration configuration, ResourceResolver resourceResolver, Object credential) {
        this.mEditor = editor;
        this.mCredential = credential;
        this.mProject = editor.getProject();
        LayoutCanvas canvas = editor.getCanvasControl();
        this.mImageFactory = canvas.getImageOverlay();
        FolderConfiguration folderConfig = configuration.getFullConfig();
        Device device = configuration.getDevice();
        assert (device != null);
        this.mHardwareConfigHelper = new HardwareConfigHelper(device);
        this.mHardwareConfigHelper.setOrientation(folderConfig.getScreenOrientationQualifier().getValue());
        this.mLayoutLib = editor.getReadyLayoutLib(true);
        this.mResourceResolver = resourceResolver != null ? resourceResolver : editor.getResourceResolver();
        this.mProjectCallback = editor.getProjectCallback(true, this.mLayoutLib);
        this.mMinSdkVersion = editor.getMinSdkVersion();
        this.mTargetSdkVersion = editor.getTargetSdkVersion();
        this.mLocale = configuration.getLocale();
    }

    private RenderSecurityManager createSecurityManager() {
        String projectPath = null;
        String sdkPath = null;
        RenderSecurityManager securityManager = new RenderSecurityManager(sdkPath, projectPath);
        securityManager.setLogger((ILogger)AdtPlugin.getDefault());
        Toolkit.getDefaultToolkit();
        return securityManager;
    }

    public static boolean supports(@NonNull IAndroidTarget target, @NonNull Capability capability) {
        LayoutLibrary layoutLib;
        AndroidTargetData targetData;
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null && (targetData = sdk.getTargetData(target)) != null && (layoutLib = targetData.getLayoutLibrary()) != null) {
            return layoutLib.supports(capability);
        }
        return false;
    }

    public static RenderService create(GraphicalEditorPart editor) {
        return editor.createRenderService();
    }

    @NonNull
    public static RenderService create(GraphicalEditorPart editor, Object credential) {
        return new RenderService(editor, credential);
    }

    public static RenderService create(GraphicalEditorPart editor, Configuration configuration, ResourceResolver resolver) {
        return editor.createRenderService(configuration, resolver);
    }

    public static RenderService create(GraphicalEditorPart editor, Configuration configuration, ResourceResolver resolver, Object credential) {
        return new RenderService(editor, configuration, resolver, credential);
    }

    public RenderService setLog(LayoutLog logger) {
        this.mLogger = logger;
        return this;
    }

    public RenderService setModel(UiDocumentNode model) {
        this.mModel = model;
        return this;
    }

    public RenderService setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.mHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    public RenderService setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.mHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    public RenderService setRenderingMode(SessionParams.RenderingMode renderingMode) {
        this.mRenderingMode = renderingMode;
        return this;
    }

    public RenderService setOverrideBgColor(Integer overrideBgColor) {
        this.mOverrideBgColor = overrideBgColor;
        return this;
    }

    public RenderService setDecorations(boolean showDecorations) {
        this.mShowDecorations = showDecorations;
        return this;
    }

    public RenderService setNodesToExpand(Set<UiElementNode> nodesToExpand) {
        this.mExpandNodes = nodesToExpand;
        return this;
    }

    public RenderService setIncludedWithin(IncludeFinder.Reference includedWithin) {
        this.mIncludedWithin = includedWithin;
        return this;
    }

    private void finishConfiguration() {
        if (this.mLogger == null) {
            this.mLogger = new LayoutLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderSession createRenderSession() {
        Object info;
        File layoutFile;
        String contextLayoutName;
        ResourceValue contextLayout;
        UiElementPullParser modelParser;
        assert (this.mModel != null) : "Incomplete service config";
        this.finishConfiguration();
        if (this.mResourceResolver == null) {
            return null;
        }
        HardwareConfig hardwareConfig = this.mHardwareConfigHelper.getConfig();
        Object topParser = modelParser = new UiElementPullParser(this.mModel, false, this.mExpandNodes, hardwareConfig.getDensity(), this.mProject);
        this.mProjectCallback.setLayoutParser(null, null);
        if (this.mIncludedWithin != null && (contextLayout = this.mResourceResolver.findResValue("@layout/" + (contextLayoutName = this.mIncludedWithin.getName()), false)) != null && (layoutFile = new File(contextLayout.getValue())).isFile()) {
            try {
                String queryLayoutName = this.mEditor.getLayoutResourceName();
                this.mProjectCallback.setLayoutParser(queryLayoutName, (ILayoutPullParser)modelParser);
                topParser = new ContextPullParser((IProjectCallback)this.mProjectCallback, layoutFile);
                topParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                String xmlText = Files.toString((File)layoutFile, (Charset)Charsets.UTF_8);
                topParser.setInput(new StringReader(xmlText));
            }
            catch (IOException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
            catch (XmlPullParserException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
        SessionParams params = new SessionParams((ILayoutPullParser)topParser, this.mRenderingMode, (Object)this.mProject, hardwareConfig, (RenderResources)this.mResourceResolver, (LayoutlibCallback)this.mProjectCallback, this.mMinSdkVersion, this.mTargetSdkVersion, this.mLogger);
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.mLocale.toLocaleId());
        params.setAssetRepository(new AssetRepository());
        ManifestInfo manifestInfo = ManifestInfo.get(this.mProject);
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {}
        if (!this.mShowDecorations) {
            params.setForceNoDecor();
        } else {
            try {
                params.setAppLabel(manifestInfo.getApplicationLabel());
                params.setAppIcon(manifestInfo.getApplicationIcon());
                String activity = this.mEditor.getConfigurationChooser().getConfiguration().getActivity();
                if (activity != null && (info = manifestInfo.getActivityAttributes(activity)) != null) {
                    if (((ManifestInfo.ActivityAttributes)info).getLabel() != null) {
                        params.setAppLabel(((ManifestInfo.ActivityAttributes)info).getLabel());
                    }
                    if (((ManifestInfo.ActivityAttributes)info).getIcon() != null) {
                        params.setAppIcon(((ManifestInfo.ActivityAttributes)info).getIcon());
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (this.mOverrideBgColor != null) {
            params.setOverrideBgColor(this.mOverrideBgColor.intValue());
        }
        params.setImageFactory(this.mImageFactory);
        this.mProjectCallback.setLogger(this.mLogger);
        this.mProjectCallback.setResourceResolver(this.mResourceResolver);
        RenderSecurityManager securityManager = this.createSecurityManager();
        try {
            securityManager.setActive(true, this.mCredential);
            info = RENDERING_LOCK;
            synchronized (info) {
                try {
                    RenderSession renderSession = this.mLayoutLib.createSession(params);
                    return renderSession;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (RuntimeException t) {
                        this.mLogger.error(null, t.getLocalizedMessage(), (Throwable)t, null);
                        throw t;
                    }
                }
            }
        }
        finally {
            securityManager.dispose(this.mCredential);
            this.mProjectCallback.setLogger(null);
            this.mProjectCallback.setResourceResolver(null);
        }
    }

    public BufferedImage renderDrawable(ResourceValue drawableResourceValue) {
        Object data;
        if (drawableResourceValue == null) {
            return null;
        }
        this.finishConfiguration();
        HardwareConfig hardwareConfig = this.mHardwareConfigHelper.getConfig();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)this.mProject, hardwareConfig, (RenderResources)this.mResourceResolver, (LayoutlibCallback)this.mProjectCallback, this.mMinSdkVersion, this.mTargetSdkVersion, this.mLogger);
        params.setAssetRepository(new AssetRepository());
        params.setForceNoDecor();
        Result result = this.mLayoutLib.renderDrawable(params);
        if (result != null && result.isSuccess() && (data = result.getData()) instanceof BufferedImage) {
            return (BufferedImage)data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<INode, Rect> measureChildren(INode parent, final IClientRulesEngine.AttributeFilter filter) {
        this.finishConfiguration();
        HardwareConfig hardwareConfig = this.mHardwareConfigHelper.getConfig();
        final NodeFactory mNodeFactory = this.mEditor.getCanvasControl().getNodeFactory();
        UiViewElementNode parentNode = ((NodeProxy)parent).getNode();
        UiElementPullParser topParser = new UiElementPullParser(parentNode, false, Collections.emptySet(), hardwareConfig.getDensity(), this.mProject){

            @Override
            public String getAttributeValue(String namespace, String localName) {
                String value;
                NodeProxy node;
                Object cookie;
                if (filter != null && (cookie = this.getViewCookie()) instanceof UiViewElementNode && (node = mNodeFactory.create((UiViewElementNode)cookie)) != null && (value = filter.getAttribute((INode)node, namespace, localName)) != null) {
                    return value;
                }
                return super.getAttributeValue(namespace, localName);
            }

            @Override
            public void onNextFromStartDocument() {
                this.mParsingState = 2;
            }
        };
        SessionParams params = new SessionParams((ILayoutPullParser)topParser, SessionParams.RenderingMode.FULL_EXPAND, (Object)this.mProject, hardwareConfig, (RenderResources)this.mResourceResolver, (LayoutlibCallback)this.mProjectCallback, this.mMinSdkVersion, this.mTargetSdkVersion, this.mLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setAssetRepository(new AssetRepository());
        RenderSession session = null;
        this.mProjectCallback.setLogger(this.mLogger);
        this.mProjectCallback.setResourceResolver(this.mResourceResolver);
        RenderSecurityManager securityManager = this.createSecurityManager();
        try {
            securityManager.setActive(true, this.mCredential);
            Object object = RENDERING_LOCK;
            synchronized (object) {
                session = this.mLayoutLib.createSession(params);
            }
            if (session.getResult().isSuccess()) {
                assert (session.getRootViews().size() == 1);
                ViewInfo root = (ViewInfo)session.getRootViews().get(0);
                List children = root.getChildren();
                HashMap<INode, Rect> map = new HashMap<INode, Rect>(children.size());
                for (ViewInfo info : children) {
                    if (!(info.getCookie() instanceof UiViewElementNode)) continue;
                    UiViewElementNode uiNode = (UiViewElementNode)info.getCookie();
                    NodeProxy node = mNodeFactory.create(uiNode);
                    map.put(node, new Rect(info.getLeft(), info.getTop(), info.getRight() - info.getLeft(), info.getBottom() - info.getTop()));
                }
                HashMap<INode, Rect> hashMap = map;
                return hashMap;
            }
        }
        catch (RuntimeException t) {
            this.mLogger.error(null, t.getLocalizedMessage(), (Throwable)t, null);
            throw t;
        }
        finally {
            securityManager.dispose(this.mCredential);
            this.mProjectCallback.setLogger(null);
            this.mProjectCallback.setResourceResolver(null);
            if (session != null) {
                session.dispose();
            }
        }
        return null;
    }
}

