/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.refactoring;

import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ExtractIncludeRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoringWizard;
import com.android.ide.eclipse.adt.internal.resources.ResourceNameValidator;
import com.android.resources.ResourceType;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ExtractIncludeWizard
extends VisualRefactoringWizard {
    public ExtractIncludeWizard(ExtractIncludeRefactoring ref, LayoutEditorDelegate editor) {
        super(ref, editor);
        this.setDefaultPageTitle(ref.getName());
    }

    protected void addUserInputPages() {
        ExtractIncludeRefactoring ref = (ExtractIncludeRefactoring)this.getRefactoring();
        String initialName = ref.getInitialName();
        IFile sourceFile = ref.getSourceFile();
        this.addPage((IWizardPage)new InputPage(this.mDelegate.getEditor().getProject(), sourceFile, initialName));
    }

    private static class InputPage
    extends VisualRefactoringWizard.VisualRefactoringInputPage {
        private final IProject mProject;
        private final IFile mSourceFile;
        private final String mSuggestedName;
        private Text mNameText;
        private Button mReplaceAllOccurrences;

        public InputPage(IProject project, IFile sourceFile, String suggestedName) {
            super("ExtractIncludeInputPage");
            this.mProject = project;
            this.mSourceFile = sourceFile;
            this.mSuggestedName = suggestedName;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText("New Layout Name:");
            nameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            this.mNameText = new Text(composite, 2048);
            this.mNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.mNameText.addModifyListener(this.mModifyValidateListener);
            this.mReplaceAllOccurrences = new Button(composite, 32);
            this.mReplaceAllOccurrences.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.mReplaceAllOccurrences.setText("Replace occurrences in all layouts with include to new layout");
            this.mReplaceAllOccurrences.setEnabled(true);
            this.mReplaceAllOccurrences.setSelection(true);
            this.mReplaceAllOccurrences.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            if (this.mSuggestedName != null) {
                this.mNameText.setText(this.mSuggestedName);
            }
            this.setControl((Control)composite);
            this.validatePage();
        }

        @Override
        protected boolean validatePage() {
            boolean ok = true;
            String text = this.mNameText.getText().trim();
            if (text.length() == 0) {
                this.setErrorMessage("Provide a name for the new layout");
                ok = false;
            } else {
                ResourceNameValidator validator = ResourceNameValidator.create(false, this.mProject, ResourceType.LAYOUT);
                String message = validator.isValid(text);
                if (message != null) {
                    this.setErrorMessage(message);
                    ok = false;
                }
            }
            if (ok) {
                this.setErrorMessage(null);
                ExtractIncludeRefactoring refactoring = (ExtractIncludeRefactoring)this.getRefactoring();
                refactoring.setLayoutName(text);
                refactoring.setReplaceOccurrences(this.mReplaceAllOccurrences.getSelection());
            }
            this.setPageComplete(ok);
            return ok;
        }
    }
}

