/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.refactoring;

import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ChangeLayoutRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ChangeViewRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ExtractIncludeRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ExtractStyleRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.UnwrapRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.WrapInRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourceProcessor;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourceWizard;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourceXmlTextAction;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringWizard;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.Node;

public class RefactoringAssistant
implements IQuickAssistProcessor {
    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        StructuredTextEditor structuredEditor;
        ISelectionProvider provider;
        ISelection selection;
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        AndroidXmlEditor xmlEditor = AndroidXmlEditor.fromTextViewer((ITextViewer)sourceViewer);
        if (xmlEditor == null) {
            return null;
        }
        IFile file = xmlEditor.getInputFile();
        if (file == null) {
            return null;
        }
        int offset = invocationContext.getOffset();
        boolean isValue = false;
        boolean isReferenceValue = false;
        boolean isTagName = false;
        boolean isAttributeName = false;
        boolean isStylableAttribute = false;
        ResourceUrl resource = null;
        IStructuredModel model = null;
        try {
            model = xmlEditor.getModelForRead();
            IStructuredDocument doc = model.getStructuredDocument();
            IStructuredDocumentRegion region = doc.getRegionAtCharacterOffset(offset);
            ITextRegion subRegion = region.getRegionAtCharacterOffset(offset);
            if (subRegion != null) {
                String type = subRegion.getType();
                if (type.equals("XML_TAG_ATTRIBUTE_VALUE")) {
                    String value = region.getText(subRegion);
                    isValue = true;
                    if (value.startsWith("'@") || value.startsWith("\"@")) {
                        isReferenceValue = true;
                        resource = RenameResourceXmlTextAction.findResource((IDocument)doc, offset);
                    }
                } else if (type.equals("XML_TAG_NAME") || type.equals("XML_TAG_OPEN") || type.equals("XML_TAG_CLOSE")) {
                    isTagName = true;
                } else if (type.equals("XML_TAG_ATTRIBUTE_NAME")) {
                    isAttributeName = true;
                    String name = region.getText(subRegion);
                    int index = name.indexOf(58);
                    if (index != -1) {
                        name = name.substring(index + 1);
                    }
                    isStylableAttribute = ExtractStyleRefactoring.isStylableAttribute(name);
                } else if (type.equals("XML_TAG_ATTRIBUTE_EQUALS")) {
                    isAttributeName = true;
                    isStylableAttribute = true;
                } else if (type.equals("XML_CONTENT")) {
                    resource = RenameResourceXmlTextAction.findResource((IDocument)doc, offset);
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        ArrayList<RefactoringProposal> proposals = new ArrayList<RefactoringProposal>();
        if ((isTagName || isAttributeName || isValue || resource != null) && (selection = (provider = (structuredEditor = xmlEditor.getStructuredTextEditor()).getSelectionProvider()).getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection;
            ITextSelection originalSelection = textSelection = (ITextSelection)selection;
            boolean selectionOkay = false;
            if (textSelection.getLength() == 0 && !isValue) {
                Node node;
                selectionOkay = true;
                ISourceViewer textViewer = xmlEditor.getStructuredSourceViewer();
                int caretOffset = textViewer.getTextWidget().getCaretOffset();
                if (caretOffset >= 0 && (node = DomUtilities.getNode(textViewer.getDocument(), caretOffset)) instanceof IndexedRegion) {
                    IndexedRegion region = (IndexedRegion)node;
                    int startOffset = region.getStartOffset();
                    int length = region.getEndOffset() - region.getStartOffset();
                    textSelection = new TextSelection(startOffset, length);
                }
            }
            if (isValue && !isReferenceValue) {
                proposals.add(new RefactoringProposal(xmlEditor, new ExtractStringRefactoring(file, (IEditorPart)xmlEditor, textSelection)));
            } else if (resource != null) {
                RenameResourceProcessor processor = new RenameResourceProcessor(file.getProject(), resource.type, resource.name, null);
                RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
                proposals.add(new RefactoringProposal(xmlEditor, (Refactoring)refactoring));
            }
            LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor((IEditorPart)xmlEditor);
            if (delegate != null) {
                boolean showStyleFirst;
                boolean bl = showStyleFirst = isValue || isAttributeName && isStylableAttribute;
                if (showStyleFirst) {
                    proposals.add(new RefactoringProposal(xmlEditor, new ExtractStyleRefactoring(file, delegate, originalSelection, null)));
                }
                if (selectionOkay) {
                    proposals.add(new RefactoringProposal(xmlEditor, new WrapInRefactoring(file, delegate, textSelection, null)));
                    proposals.add(new RefactoringProposal(xmlEditor, new UnwrapRefactoring(file, delegate, textSelection, null)));
                    proposals.add(new RefactoringProposal(xmlEditor, new ChangeViewRefactoring(file, delegate, textSelection, null)));
                    proposals.add(new RefactoringProposal(xmlEditor, new ChangeLayoutRefactoring(file, delegate, textSelection, null)));
                }
                if (textSelection.getLength() > 0) {
                    proposals.add(new RefactoringProposal(xmlEditor, new ExtractIncludeRefactoring(file, delegate, textSelection, null)));
                }
                if (!showStyleFirst) {
                    proposals.add(new RefactoringProposal(xmlEditor, new ExtractStyleRefactoring(file, delegate, originalSelection, null)));
                }
            }
        }
        if (proposals.size() == 0) {
            return null;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public String getErrorMessage() {
        return null;
    }

    private static class RefactoringProposal
    implements ICompletionProposal {
        private final AndroidXmlEditor mEditor;
        private final Refactoring mRefactoring;

        RefactoringProposal(AndroidXmlEditor editor, Refactoring refactoring) {
            this.mEditor = editor;
            this.mRefactoring = refactoring;
        }

        public void apply(IDocument document) {
            Object wizard = null;
            if (this.mRefactoring instanceof VisualRefactoring) {
                wizard = ((VisualRefactoring)this.mRefactoring).createWizard();
            } else if (this.mRefactoring instanceof ExtractStringRefactoring) {
                wizard = new ExtractStringWizard((ExtractStringRefactoring)this.mRefactoring, this.mEditor.getProject());
            } else if (this.mRefactoring instanceof RenameRefactoring) {
                RenameRefactoring refactoring = (RenameRefactoring)this.mRefactoring;
                RenameResourceProcessor processor = (RenameResourceProcessor)refactoring.getProcessor();
                ResourceType type = processor.getType();
                wizard = new RenameResourceWizard((RenameRefactoring)this.mRefactoring, type, false);
            } else {
                throw new IllegalArgumentException();
            }
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                op.run(window.getShell(), wizard.getDefaultPageTitle());
            }
            catch (InterruptedException interruptedException) {}
        }

        public String getAdditionalProposalInfo() {
            return String.format("Initiates the \"%1$s\" refactoring", this.mRefactoring.getName());
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.mRefactoring.getName();
        }

        public Image getImage() {
            return AdtPlugin.getAndroidLogo();
        }

        public Point getSelection(IDocument document) {
            return null;
        }
    }
}

