/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.descriptors;

import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.common.resources.platform.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ITextAttributeCreator;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ListAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ReferenceAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ClassAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ManifestElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ManifestPkgAttrDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.PackageAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.PostActivityCreationAction;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.PostReceiverCreationAction;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.ThemeAttributeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class AndroidManifestDescriptors
implements IDescriptorProvider {
    public static final String USES_PERMISSION = "uses-permission";
    private static final String MANIFEST_NODE_NAME = "manifest";
    private static final String ANDROID_MANIFEST_STYLEABLE = "AndroidManifest";
    public static final String ANDROID_LABEL_ATTR = "label";
    public static final String ANDROID_NAME_ATTR = "name";
    public static final String PACKAGE_ATTR = "package";
    private final ElementDescriptor MANIFEST_ELEMENT;
    private final ElementDescriptor APPLICATION_ELEMENT = this.createElement("application", null, ElementDescriptor.Mandatory.MANDATORY_LAST);
    private final ElementDescriptor INTRUMENTATION_ELEMENT = this.createElement("instrumentation");
    private final ElementDescriptor PERMISSION_ELEMENT = this.createElement("permission");
    private final ElementDescriptor USES_PERMISSION_ELEMENT = this.createElement("uses-permission");
    private final ElementDescriptor USES_SDK_ELEMENT = this.createElement("uses-sdk", null, ElementDescriptor.Mandatory.MANDATORY);
    private final ElementDescriptor PERMISSION_GROUP_ELEMENT = this.createElement("permission-group");
    private final ElementDescriptor PERMISSION_TREE_ELEMENT = this.createElement("permission-tree");
    private final TextAttributeDescriptor PACKAGE_ATTR_DESC;

    public AndroidManifestDescriptors() {
        this.MANIFEST_ELEMENT = this.createElement(MANIFEST_NODE_NAME, new ElementDescriptor[]{this.APPLICATION_ELEMENT, this.INTRUMENTATION_ELEMENT, this.PERMISSION_ELEMENT, this.USES_PERMISSION_ELEMENT, this.PERMISSION_GROUP_ELEMENT, this.PERMISSION_TREE_ELEMENT, this.USES_SDK_ELEMENT}, ElementDescriptor.Mandatory.MANDATORY);
        this.PACKAGE_ATTR_DESC = new PackageAttributeDescriptor(PACKAGE_ATTR, null, new AttributeInfo(PACKAGE_ATTR, IAttributeInfo.Format.REFERENCE_SET)).setTooltip("This attribute gives a unique name for the package, using a Java-style naming convention to avoid name collisions.\nFor example, applications published by Google could have names of the form com.google.app.appname");
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return new ElementDescriptor[]{this.MANIFEST_ELEMENT};
    }

    @Override
    public ElementDescriptor getDescriptor() {
        return this.getManifestElement();
    }

    public ElementDescriptor getApplicationElement() {
        return this.APPLICATION_ELEMENT;
    }

    public ElementDescriptor getManifestElement() {
        return this.MANIFEST_ELEMENT;
    }

    public ElementDescriptor getUsesSdkElement() {
        return this.USES_SDK_ELEMENT;
    }

    public ElementDescriptor getInstrumentationElement() {
        return this.INTRUMENTATION_ELEMENT;
    }

    public ElementDescriptor getPermissionElement() {
        return this.PERMISSION_ELEMENT;
    }

    public ElementDescriptor getUsesPermissionElement() {
        return this.USES_PERMISSION_ELEMENT;
    }

    public ElementDescriptor getPermissionGroupElement() {
        return this.PERMISSION_GROUP_ELEMENT;
    }

    public ElementDescriptor getPermissionTreeElement() {
        return this.PERMISSION_TREE_ELEMENT;
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> manifestMap) {
        HashSet<String> required = new HashSet<String>();
        required.add("provider/authorities");
        HashMap<String, ITextAttributeCreator> overrides = new HashMap<String, ITextAttributeCreator>();
        overrides.put("*/icon", ReferenceAttributeDescriptor.CREATOR);
        overrides.put("*/theme", ThemeAttributeDescriptor.CREATOR);
        overrides.put("*/permission", ListAttributeDescriptor.CREATOR);
        overrides.put("*/targetPackage", ManifestPkgAttrDescriptor.CREATOR);
        overrides.put("uses-library/name", ListAttributeDescriptor.CREATOR);
        overrides.put("action,category,uses-permission/name", ListAttributeDescriptor.CREATOR);
        AndroidManifestDescriptors.overrideClassName(overrides, "application", "android.app.Application", false);
        AndroidManifestDescriptors.overrideClassName(overrides, "application/backupAgent", "android.app.backup.BackupAgent", false);
        AndroidManifestDescriptors.overrideClassName(overrides, "activity", "android.app.Activity");
        AndroidManifestDescriptors.overrideClassName(overrides, "receiver", "android.content.BroadcastReceiver");
        AndroidManifestDescriptors.overrideClassName(overrides, "service", "android.app.Service");
        AndroidManifestDescriptors.overrideClassName(overrides, "provider", "android.content.ContentProvider");
        AndroidManifestDescriptors.overrideClassName(overrides, "instrumentation", "android.app.Instrumentation");
        HashMap<String, ElementDescriptor> elementDescs = new HashMap<String, ElementDescriptor>();
        elementDescs.put(this.MANIFEST_ELEMENT.getXmlLocalName(), this.MANIFEST_ELEMENT);
        elementDescs.put(this.APPLICATION_ELEMENT.getXmlLocalName(), this.APPLICATION_ELEMENT);
        elementDescs.put(this.INTRUMENTATION_ELEMENT.getXmlLocalName(), this.INTRUMENTATION_ELEMENT);
        elementDescs.put(this.PERMISSION_ELEMENT.getXmlLocalName(), this.PERMISSION_ELEMENT);
        elementDescs.put(this.USES_PERMISSION_ELEMENT.getXmlLocalName(), this.USES_PERMISSION_ELEMENT);
        elementDescs.put(this.USES_SDK_ELEMENT.getXmlLocalName(), this.USES_SDK_ELEMENT);
        elementDescs.put(this.PERMISSION_GROUP_ELEMENT.getXmlLocalName(), this.PERMISSION_GROUP_ELEMENT);
        elementDescs.put(this.PERMISSION_TREE_ELEMENT.getXmlLocalName(), this.PERMISSION_TREE_ELEMENT);
        this.inflateElement(manifestMap, overrides, required, elementDescs, this.MANIFEST_ELEMENT, ANDROID_MANIFEST_STYLEABLE);
        this.insertAttribute(this.MANIFEST_ELEMENT, this.PACKAGE_ATTR_DESC);
        XmlnsAttributeDescriptor xmlns = new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
        this.insertAttribute(this.MANIFEST_ELEMENT, xmlns);
        assert (this.sanityCheck(manifestMap, this.MANIFEST_ELEMENT));
    }

    private static void overrideClassName(Map<String, ITextAttributeCreator> overrides, String elementName, String className) {
        AndroidManifestDescriptors.overrideClassName(overrides, elementName, className, true);
    }

    private static void overrideClassName(Map<String, ITextAttributeCreator> overrides, String elementName, final String className, final boolean mandatory) {
        if (elementName.indexOf(47) == -1) {
            elementName = String.valueOf(elementName) + '/' + ANDROID_NAME_ATTR;
        }
        overrides.put(elementName, new ITextAttributeCreator(){

            @Override
            public TextAttributeDescriptor create(String xmlName, String nsUri, IAttributeInfo attrInfo) {
                if (attrInfo == null) {
                    attrInfo = new AttributeInfo(xmlName, IAttributeInfo.Format.STRING_SET);
                }
                if ("android.app.Activity".equals(className)) {
                    return new ClassAttributeDescriptor(className, PostActivityCreationAction.getAction(), xmlName, nsUri, attrInfo, mandatory, true);
                }
                if ("android.content.BroadcastReceiver".equals(className)) {
                    return new ClassAttributeDescriptor(className, PostReceiverCreationAction.getAction(), xmlName, nsUri, attrInfo, mandatory, true);
                }
                if ("android.app.Instrumentation".equals(className)) {
                    return new ClassAttributeDescriptor(className, null, xmlName, nsUri, attrInfo, mandatory, false);
                }
                return new ClassAttributeDescriptor(className, xmlName, nsUri, attrInfo, mandatory);
            }
        });
    }

    private ElementDescriptor createElement(String xmlName, ElementDescriptor[] childrenElements, ElementDescriptor.Mandatory mandatory) {
        String styleName = this.guessStyleName(xmlName);
        String sdkUrl = "/reference/android/R.styleable.html#" + styleName;
        String uiName = AndroidManifestDescriptors.getUiName(xmlName);
        ManifestElementDescriptor element = new ManifestElementDescriptor(xmlName, uiName, null, sdkUrl, null, childrenElements, mandatory);
        return element;
    }

    private ElementDescriptor createElement(String xmlName) {
        return this.createElement(xmlName, null, ElementDescriptor.Mandatory.NOT_MANDATORY);
    }

    private void insertAttribute(ElementDescriptor element, AttributeDescriptor newAttr) {
        AttributeDescriptor[] attributes;
        AttributeDescriptor[] attributeDescriptorArray = attributes = element.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attr = attributeDescriptorArray[n2];
            if (attr.getXmlLocalName().equals(newAttr.getXmlLocalName())) {
                return;
            }
            ++n2;
        }
        AttributeDescriptor[] newArray = new AttributeDescriptor[attributes.length + 1];
        newArray[0] = newAttr;
        System.arraycopy(attributes, 0, newArray, 1, attributes.length);
        element.setAttributes(newArray);
    }

    private void inflateElement(Map<String, DeclareStyleableInfo> styleMap, Map<String, ITextAttributeCreator> overrides, Set<String> requiredAttributes, HashMap<String, ElementDescriptor> existingElementDescs, ElementDescriptor elemDesc, String styleName) {
        assert (elemDesc != null);
        assert (styleName != null);
        assert (styleMap != null);
        if (styleMap == null) {
            return;
        }
        DeclareStyleableInfo style = styleMap.get(styleName);
        if (style != null) {
            ArrayList<AttributeDescriptor> attrDescs = new ArrayList<AttributeDescriptor>();
            DescriptorsUtils.appendAttributes(attrDescs, elemDesc.getXmlLocalName(), "http://schemas.android.com/apk/res/android", style.getAttributes(), requiredAttributes, overrides);
            elemDesc.setTooltip(style.getJavaDoc());
            elemDesc.setAttributes(attrDescs.toArray(new AttributeDescriptor[attrDescs.size()]));
        }
        ArrayList<ElementDescriptor> children = new ArrayList<ElementDescriptor>();
        for (Map.Entry<String, DeclareStyleableInfo> entry : styleMap.entrySet()) {
            DeclareStyleableInfo childStyle = entry.getValue();
            boolean isParent = false;
            String[] parents = childStyle.getParents();
            if (parents != null) {
                String[] stringArray = parents;
                int n = parents.length;
                int n2 = 0;
                while (n2 < n) {
                    String parent = stringArray[n2];
                    if (styleName.equals(parent)) {
                        isParent = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!isParent) continue;
            String childStyleName = entry.getKey();
            String childXmlName = this.guessXmlName(childStyleName);
            ElementDescriptor child = existingElementDescs.get(childXmlName);
            if (child == null) {
                child = this.createElement(childXmlName);
                existingElementDescs.put(childXmlName, child);
            }
            children.add(child);
            this.inflateElement(styleMap, overrides, requiredAttributes, existingElementDescs, child, childStyleName);
        }
        elemDesc.setChildren(children.toArray(new ElementDescriptor[children.size()]));
    }

    private static String getUiName(String xmlName) {
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        char[] cArray = xmlName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (capitalize && c >= 'a' && c <= 'z') {
                sb.append((char)(c + 65 - 97));
                capitalize = false;
            } else if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                sb.append(' ');
                capitalize = true;
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    private String guessStyleName(String xmlName) {
        StringBuilder sb = new StringBuilder();
        if (!xmlName.equals(MANIFEST_NODE_NAME)) {
            boolean capitalize = true;
            char[] cArray = xmlName.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (capitalize && c >= 'a' && c <= 'z') {
                    sb.append((char)(c + 65 - 97));
                    capitalize = false;
                } else if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                    capitalize = true;
                } else {
                    sb.append(c);
                }
                ++n2;
            }
        }
        sb.insert(0, ANDROID_MANIFEST_STYLEABLE);
        return sb.toString();
    }

    private boolean sanityCheck(Map<String, DeclareStyleableInfo> manifestMap, ElementDescriptor manifestElement) {
        TreeSet<String> elementsDeclared = new TreeSet<String>();
        this.findAllElementNames(manifestElement, elementsDeclared);
        TreeSet<String> stylesDeclared = new TreeSet<String>();
        for (String styleName : manifestMap.keySet()) {
            if (!styleName.startsWith(ANDROID_MANIFEST_STYLEABLE)) continue;
            stylesDeclared.add(styleName);
        }
        Iterator<String> it = elementsDeclared.iterator();
        while (it.hasNext()) {
            String xmlName = it.next();
            String styleName = this.guessStyleName(xmlName);
            if (!stylesDeclared.remove(styleName)) continue;
            it.remove();
        }
        StringBuilder sb = new StringBuilder();
        if (!stylesDeclared.isEmpty()) {
            sb.append("Warning, ADT/SDK Mismatch! The following elements are declared by the SDK but unknown to ADT: ");
            for (String name : stylesDeclared) {
                sb.append(this.guessXmlName(name));
                if (name.equals(stylesDeclared.last())) continue;
                sb.append(", ");
            }
            AdtPlugin.log(2, "%s", sb.toString());
            AdtPlugin.printToConsole(null, new Object[]{sb});
            sb.setLength(0);
        }
        if (!elementsDeclared.isEmpty()) {
            sb.append("Warning, ADT/SDK Mismatch! The following elements are declared by ADT but not by the SDK: ");
            for (String name : elementsDeclared) {
                sb.append(name);
                if (name.equals(elementsDeclared.last())) continue;
                sb.append(", ");
            }
            AdtPlugin.log(2, "%s", sb.toString());
            AdtPlugin.printToConsole(null, new Object[]{sb});
        }
        return true;
    }

    private String guessXmlName(String name) {
        StringBuilder sb = new StringBuilder();
        if (ANDROID_MANIFEST_STYLEABLE.equals(name)) {
            sb.append(MANIFEST_NODE_NAME);
        } else {
            name = name.replace(ANDROID_MANIFEST_STYLEABLE, "");
            boolean first_char = true;
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c >= 'A' && c <= 'Z') {
                    if (!first_char) {
                        sb.append('-');
                    }
                    c = (char)(c - 65 + 97);
                }
                sb.append(c);
                first_char = false;
                ++n2;
            }
        }
        return sb.toString();
    }

    private void findAllElementNames(ElementDescriptor element, TreeSet<String> declared) {
        declared.add(element.getXmlName());
        ElementDescriptor[] elementDescriptorArray = element.getChildren();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDescriptor desc = elementDescriptorArray[n2];
            this.findAllElementNames(desc, declared);
            ++n2;
        }
    }
}

