/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.lint.GlobalLintConfiguration;
import com.android.ide.eclipse.adt.internal.lint.LintListDialog;
import com.android.ide.eclipse.adt.internal.lint.ProjectLintConfiguration;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.ecj.EcjTreeConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

public class EclipseLintClient
extends LintClient {
    static final String MARKER_CHECKID_PROPERTY = "checkid";
    private static final String MODEL_PROPERTY = "model";
    private final List<? extends IResource> mResources;
    private final IDocument mDocument;
    private boolean mWasFatal;
    private boolean mFatalOnly;
    private EclipseJavaParser mJavaParser;
    private boolean mCollectNodes;
    private Map<org.w3c.dom.Node, IMarker> mNodeMap;
    private IProject mLastEclipseProject;
    private Project mLastLintProject;
    private Map<Project, LintClient.ClassPathInfo> mProjectInfo;
    private boolean mSearchForSuperClasses;

    public EclipseLintClient(IssueRegistry registry, List<? extends IResource> resources, IDocument document, boolean fatalOnly) {
        this.mResources = resources;
        this.mDocument = document;
        this.mFatalOnly = fatalOnly;
    }

    public boolean isFatalOnly() {
        return this.mFatalOnly;
    }

    public void setCollectNodes(boolean collectNodes) {
        this.mCollectNodes = collectNodes;
    }

    @Nullable
    public IMarker getIssueForNode(@NonNull UiViewElementNode node) {
        if (this.mNodeMap != null) {
            return this.mNodeMap.get(node.getXmlNode());
        }
        return null;
    }

    @Nullable
    public Collection<org.w3c.dom.Node> getIssueNodes() {
        if (this.mNodeMap != null) {
            return this.mNodeMap.keySet();
        }
        return null;
    }

    public void log(@NonNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        if (exception == null) {
            AdtPlugin.log(2, format, args);
        } else {
            AdtPlugin.log(exception, format, args);
        }
    }

    public XmlParser getXmlParser() {
        return new XmlParser(){

            public Document parseXml(@NonNull XmlContext context) {
                IModelManager modelManager;
                IStructuredModel model;
                IFile file;
                block6: {
                    file = AdtUtils.fileToIFile(context.file);
                    if (file == null || !file.exists()) {
                        String path = context.file.getPath();
                        AdtPlugin.log(4, "Can't find file %1$s in workspace", path);
                        return null;
                    }
                    model = null;
                    modelManager = StructuredModelManager.getModelManager();
                    if (modelManager != null) break block6;
                    return null;
                }
                try {
                    model = modelManager.getModelForRead(file);
                    if (model instanceof IDOMModel) {
                        context.setProperty(EclipseLintClient.MODEL_PROPERTY, (Object)model);
                        IDOMModel domModel = (IDOMModel)model;
                        return domModel.getDocument();
                    }
                }
                catch (IOException e) {
                    AdtPlugin.log(e, "Cannot read XML file", new Object[0]);
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
                return null;
            }

            @NonNull
            public Location getLocation(@NonNull XmlContext context, @NonNull org.w3c.dom.Node node) {
                IStructuredModel model = (IStructuredModel)context.getProperty(EclipseLintClient.MODEL_PROPERTY);
                return new LazyLocation(context.file, model.getStructuredDocument(), (IndexedRegion)node);
            }

            @NonNull
            public Location getLocation(@NonNull XmlContext context, @NonNull org.w3c.dom.Node node, int start, int end) {
                IndexedRegion region = (IndexedRegion)node;
                int nodeStart = region.getStartOffset();
                IStructuredModel model = (IStructuredModel)context.getProperty(EclipseLintClient.MODEL_PROPERTY);
                LazyLocation location = new LazyLocation(context.file, model.getStructuredDocument(), region);
                int line = location.getStart().getLine();
                DefaultPosition startPos = new DefaultPosition(line, -1, nodeStart + start);
                DefaultPosition endPos = new DefaultPosition(line, -1, nodeStart + end);
                return Location.create((File)context.file, (com.android.tools.lint.detector.api.Position)startPos, (com.android.tools.lint.detector.api.Position)endPos);
            }

            public int getNodeStartOffset(@NonNull XmlContext context, @NonNull org.w3c.dom.Node node) {
                IndexedRegion region = (IndexedRegion)node;
                return region.getStartOffset();
            }

            public int getNodeEndOffset(@NonNull XmlContext context, @NonNull org.w3c.dom.Node node) {
                IndexedRegion region = (IndexedRegion)node;
                return region.getEndOffset();
            }

            @NonNull
            public Location.Handle createLocationHandle(@NonNull XmlContext context, @NonNull org.w3c.dom.Node node) {
                IStructuredModel model = (IStructuredModel)context.getProperty(EclipseLintClient.MODEL_PROPERTY);
                return new LazyLocation(context.file, model.getStructuredDocument(), (IndexedRegion)node);
            }

            public void dispose(@NonNull XmlContext context, @NonNull Document document) {
                IStructuredModel model = (IStructuredModel)context.getProperty(EclipseLintClient.MODEL_PROPERTY);
                if (!$assertionsDisabled && model == null) {
                    throw new AssertionError(context.file);
                }
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        };
    }

    public JavaParser getJavaParser(@Nullable Project project) {
        if (this.mJavaParser == null) {
            this.mJavaParser = new EclipseJavaParser();
        }
        return this.mJavaParser;
    }

    private IProject getProject(Project project) {
        if (project == this.mLastLintProject) {
            return this.mLastEclipseProject;
        }
        this.mLastLintProject = project;
        this.mLastEclipseProject = null;
        if (this.mResources != null) {
            if (this.mResources.size() == 1) {
                IProject p;
                this.mLastEclipseProject = p = this.mResources.get(0).getProject();
                return p;
            }
            IProject last = null;
            for (IResource iResource : this.mResources) {
                IProject p = iResource.getProject();
                if (p == last) continue;
                if (project.getDir().equals(AdtUtils.getAbsolutePath((IResource)p).toFile())) {
                    this.mLastEclipseProject = p;
                    return p;
                }
                last = p;
            }
        }
        return null;
    }

    @NonNull
    public String getProjectName(@NonNull Project project) {
        IProject eclipseProject = this.getProject(project);
        if (eclipseProject != null) {
            return eclipseProject.getName();
        }
        return super.getProjectName(project);
    }

    @NonNull
    public Configuration getConfiguration(@NonNull Project project) {
        return this.getConfigurationFor(project);
    }

    @NonNull
    public Configuration getConfigurationFor(@Nullable Project project) {
        IProject eclipseProject;
        if (project != null && (eclipseProject = this.getProject(project)) != null) {
            return ProjectLintConfiguration.get(this, eclipseProject, this.mFatalOnly);
        }
        return GlobalLintConfiguration.get();
    }

    public void report(@NonNull Context context, @NonNull Issue issue, @NonNull Severity s, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        LazyLocation l;
        IndexedRegion region;
        int severity = EclipseLintClient.getMarkerSeverity(s);
        IMarker marker = null;
        if (location != null) {
            com.android.tools.lint.detector.api.Position startPosition = location.getStart();
            if (startPosition == null) {
                IResource resource;
                if (location.getFile() != null && (resource = AdtUtils.fileToResource(location.getFile())) != null && resource.isAccessible()) {
                    marker = BaseProjectHelper.markResource(resource, "com.android.ide.eclipse.adt.lintProblem", message, 0, severity);
                }
            } else {
                com.android.tools.lint.detector.api.Position endPosition = location.getEnd();
                int line = startPosition.getLine() + 1;
                IFile file = AdtUtils.fileToIFile(location.getFile());
                if (file != null && file.isAccessible()) {
                    Pair<Integer, Integer> r = EclipseLintClient.getRange(file, this.mDocument, startPosition, endPosition);
                    int startOffset = (Integer)r.getFirst();
                    int endOffset = (Integer)r.getSecond();
                    marker = BaseProjectHelper.markResource((IResource)file, "com.android.ide.eclipse.adt.lintProblem", message, line, startOffset, endOffset, severity);
                }
            }
        }
        if (marker == null) {
            marker = BaseProjectHelper.markResource(this.mResources.get(0), "com.android.ide.eclipse.adt.lintProblem", message, 0, severity);
        }
        if (marker != null) {
            try {
                marker.setAttribute(MARKER_CHECKID_PROPERTY, (Object)issue.getId());
            }
            catch (CoreException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
        if (s == Severity.FATAL) {
            this.mWasFatal = true;
        }
        if (this.mCollectNodes && location != null && marker != null && location instanceof LazyLocation && (region = (l = (LazyLocation)location).mRegion) instanceof org.w3c.dom.Node) {
            IMarker prev;
            org.w3c.dom.Node node = (org.w3c.dom.Node)region;
            if (node instanceof Attr) {
                node = ((Attr)node).getOwnerElement();
            }
            if (this.mNodeMap == null) {
                this.mNodeMap = new WeakHashMap<org.w3c.dom.Node, IMarker>();
            }
            if ((prev = this.mNodeMap.get(node)) != null) {
                int prevSeverity = prev.getAttribute("severity", 0);
                if (prevSeverity < severity) {
                    this.mNodeMap.put(node, marker);
                }
            } else {
                this.mNodeMap.put(node, marker);
            }
        }
    }

    @Nullable
    public File findResource(@NonNull String relativePath) {
        File file;
        String sdkFolder = AdtPrefs.getPrefs().getOsSdkFolder();
        if (sdkFolder != null && (file = new File(sdkFolder, relativePath)).exists()) {
            return file;
        }
        return null;
    }

    public static void clearMarkers(@NonNull IResource resource) {
        EclipseLintClient.clearMarkers(Collections.singletonList(resource));
    }

    static void clearMarkers(List<? extends IResource> resources) {
        for (IResource iResource : resources) {
            try {
                if (!iResource.isAccessible()) continue;
                iResource.deleteMarkers("com.android.ide.eclipse.adt.lintProblem", false, 2);
            }
            catch (CoreException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
        IEditorPart iEditorPart = AdtUtils.getActiveEditor();
        LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor(iEditorPart);
        if (delegate != null) {
            delegate.getGraphicalEditor().getLayoutActionBar().updateErrorIndicator();
        }
    }

    public static void removeMarkers(IResource resource, String id) {
        IMarker[] markers;
        if (resource == null) {
            IJavaProject[] androidProjects;
            IJavaProject[] iJavaProjectArray = androidProjects = BaseProjectHelper.getAndroidProjects(null);
            int n = androidProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject project = iJavaProjectArray[n2];
                IProject p = project.getProject();
                if (p != null) {
                    EclipseLintClient.removeMarkers((IResource)p, id);
                }
                ++n2;
            }
            return;
        }
        IMarker[] iMarkerArray = markers = EclipseLintClient.getMarkers(resource);
        int n = markers.length;
        int n3 = 0;
        while (n3 < n) {
            IMarker marker = iMarkerArray[n3];
            if (id.equals(EclipseLintClient.getId(marker))) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
            }
            ++n3;
        }
    }

    public static IMarker[] getMarkers(IResource resource) {
        try {
            if (resource.isAccessible()) {
                return resource.findMarkers("com.android.ide.eclipse.adt.lintProblem", false, 2);
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return new IMarker[0];
    }

    private static int getMarkerSeverity(Severity severity) {
        switch (severity) {
            case INFORMATIONAL: {
                return 0;
            }
            case WARNING: {
                return 1;
            }
        }
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<Integer, Integer> getRange(IFile file, IDocument doc, com.android.tools.lint.detector.api.Position startPosition, com.android.tools.lint.detector.api.Position endPosition) {
        int endOffset;
        int startOffset = startPosition.getOffset();
        int n = endOffset = endPosition != null ? endPosition.getOffset() : -1;
        if (endOffset == -1) return Pair.of((Object)startOffset, (Object)startOffset);
        if (doc != null) return EclipseLintClient.adjustOffsets(doc, startOffset, endOffset);
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        try {
            provider.connect((Object)file);
            doc = provider.getDocument((Object)file);
            if (doc == null) return Pair.of((Object)startOffset, (Object)startOffset);
            Pair<Integer, Integer> pair = EclipseLintClient.adjustOffsets(doc, startOffset, endOffset);
            return pair;
        }
        catch (Exception e) {
            AdtPlugin.log(e, "Can't find range information for %1$s", file.getName());
            return Pair.of((Object)startOffset, (Object)startOffset);
        }
        finally {
            provider.disconnect((Object)file);
        }
    }

    private static Pair<Integer, Integer> adjustOffsets(IDocument doc, int startOffset, int endOffset) {
        int originalStart = startOffset;
        int originalEnd = endOffset;
        if (doc != null) {
            while (endOffset > startOffset && endOffset < doc.getLength()) {
                try {
                    if (!Character.isWhitespace(doc.getChar(endOffset - 1))) break;
                    --endOffset;
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
            }
            int lineEnd = startOffset;
            while (lineEnd < endOffset) {
                try {
                    char c = doc.getChar(lineEnd);
                    if (c == '\n' || c == '\r') {
                        endOffset = lineEnd;
                        if (endOffset <= 0 || doc.getChar(endOffset - 1) != '\r') break;
                        --endOffset;
                    }
                }
                catch (BadLocationException badLocationException) {}
                break;
                ++lineEnd;
            }
        }
        if (startOffset >= endOffset) {
            return Pair.of((Object)originalStart, (Object)originalEnd);
        }
        return Pair.of((Object)startOffset, (Object)endOffset);
    }

    public boolean hasFatalErrors() {
        return this.mWasFatal;
    }

    public static String describe(IMarker marker) {
        String markerId;
        IssueRegistry registry = EclipseLintClient.getRegistry();
        Issue issue = registry.getIssue(markerId = EclipseLintClient.getId(marker));
        if (issue == null) {
            return "";
        }
        String summary = issue.getDescription(Issue.OutputFormat.TEXT);
        String explanation = issue.getExplanation(Issue.OutputFormat.TEXT);
        StringBuilder sb = new StringBuilder(summary.length() + explanation.length() + 20);
        try {
            sb.append((String)marker.getAttribute("message"));
            sb.append('\n').append('\n');
        }
        catch (CoreException coreException) {}
        sb.append("Issue: ");
        sb.append(summary);
        sb.append('\n');
        sb.append("Id: ");
        sb.append(issue.getId());
        sb.append('\n').append('\n');
        sb.append(explanation);
        if (issue.getMoreInfo() != null) {
            sb.append('\n').append('\n');
            sb.append(issue.getMoreInfo());
        }
        return sb.toString();
    }

    public static String getId(IMarker marker) {
        try {
            return (String)marker.getAttribute(MARKER_CHECKID_PROPERTY);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void showMarker(IMarker marker) {
        Region region = null;
        try {
            IEditorPart editor;
            IResource resource;
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            if (start >= 0 && end >= 0) {
                region = new Region(start, end - start);
            }
            if ((resource = marker.getResource()) instanceof IFile && (editor = AdtPlugin.openFile((IFile)resource, (IRegion)region, true)) != null) {
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
        }
        catch (PartInitException ex) {
            AdtPlugin.log(ex, null, new Object[0]);
        }
    }

    public static void showErrors(@NonNull Shell shell, @NonNull IFile file, @Nullable IEditorPart editor) {
        LintListDialog dialog = new LintListDialog(shell, file, editor);
        dialog.open();
    }

    @NonNull
    public String readFile(@NonNull File f) {
        IFile file = AdtUtils.fileToIFile(f);
        if (file == null || !file.exists()) {
            String path = f.getPath();
            AdtPlugin.log(4, "Can't find file %1$s in workspace", path);
            return this.readPlainFile(f);
        }
        if (SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".xml")) {
            IStructuredModel model = null;
            try {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                model = modelManager.getModelForRead(file);
                String string = model.getStructuredDocument().get();
                return string;
            }
            catch (IOException e) {
                AdtPlugin.log(e, "Cannot read XML file", new Object[0]);
            }
            catch (CoreException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return this.readPlainFile(f);
    }

    private String readPlainFile(File file) {
        try {
            return LintUtils.getEncodedString((LintClient)this, (File)file);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @NonNull
    protected LintClient.ClassPathInfo getClassPath(@NonNull Project project) {
        LintClient.ClassPathInfo info;
        block18: {
            ArrayList<File> libraries;
            List<File> classes;
            ArrayList<File> sources;
            block19: {
                if (this.mProjectInfo == null) {
                    this.mProjectInfo = Maps.newHashMap();
                    info = null;
                } else {
                    info = this.mProjectInfo.get(project);
                }
                if (info != null) break block18;
                sources = null;
                classes = null;
                libraries = null;
                IProject p = this.getProject(project);
                if (p == null) break block19;
                try {
                    File[] jars;
                    IJavaProject javaProject = BaseProjectHelper.getJavaProject(p);
                    File file = AdtUtils.workspacePathToFile(javaProject.getOutputLocation());
                    classes = Collections.singletonList(file);
                    IClasspathEntry[] entries = javaProject.getRawClasspath();
                    sources = new ArrayList<File>(entries.length);
                    libraries = new ArrayList<File>(entries.length);
                    int i = 0;
                    while (i < entries.length) {
                        block21: {
                            int kind;
                            IClasspathEntry entry;
                            block20: {
                                entry = entries[i];
                                kind = entry.getEntryKind();
                                if (kind != 4) break block20;
                                if ((entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)) == null) break block21;
                                kind = entry.getEntryKind();
                            }
                            if (kind == 3) {
                                sources.add(AdtUtils.workspacePathToFile(entry.getPath()));
                            } else if (kind == 1) {
                                libraries.add(entry.getPath().toFile());
                            }
                        }
                        ++i;
                    }
                    File libs = new File(project.getDir(), "libs");
                    if (libs.isDirectory() && (jars = libs.listFiles()) != null) {
                        File[] fileArray = jars;
                        int n = jars.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File jar = fileArray[n2];
                            if (SdkUtils.endsWith((CharSequence)jar.getPath(), (CharSequence)".jar")) {
                                libraries.add(jar);
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
            }
            if (sources == null) {
                sources = super.getClassPath(project).getSourceFolders();
            }
            if (classes == null) {
                classes = super.getClassPath(project).getClassFolders();
            }
            if (libraries == null) {
                libraries = super.getClassPath(project).getLibraries();
            }
            info = new LintClient.ClassPathInfo((List)sources, classes, (List)libraries);
            this.mProjectInfo.put(project, info);
        }
        return info;
    }

    public static IssueRegistry getRegistry() {
        return new BuiltinIssueRegistry();
    }

    @NonNull
    public Class<? extends Detector> replaceDetector(@NonNull Class<? extends Detector> detectorClass) {
        return detectorClass;
    }

    @NonNull
    public IAndroidTarget[] getTargets() {
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null) {
            return sdk.getTargets();
        }
        return new IAndroidTarget[0];
    }

    public void setSearchForSuperClasses(boolean search) {
        this.mSearchForSuperClasses = search;
    }

    public boolean getSearchForSuperClasses() {
        return this.mSearchForSuperClasses;
    }

    @Nullable
    public String getSuperClass(@NonNull Project project, @NonNull String name) {
        IJavaProject javaProject;
        block8: {
            if (!this.mSearchForSuperClasses) {
                return null;
            }
            IProject eclipseProject = this.getProject(project);
            if (eclipseProject == null) {
                return null;
            }
            javaProject = BaseProjectHelper.getJavaProject(eclipseProject);
            if (javaProject != null) break block8;
            return null;
        }
        try {
            ITypeHierarchy hierarchy;
            IType superType;
            String typeFqcn = ClassContext.getFqcn((String)name);
            IType type = javaProject.findType(typeFqcn);
            if (type != null && (superType = (hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor())).getSuperclass(type)) != null) {
                String key = superType.getKey();
                if (!key.isEmpty() && key.charAt(0) == 'L' && key.charAt(key.length() - 1) == ';') {
                    return key.substring(1, key.length() - 1);
                }
                String fqcn = superType.getFullyQualifiedName();
                return ClassContext.getInternalName((String)fqcn);
            }
        }
        catch (JavaModelException e) {
            this.log(Severity.INFORMATIONAL, e, null, new Object[0]);
        }
        catch (CoreException e) {
            this.log(Severity.INFORMATIONAL, e, null, new Object[0]);
        }
        return null;
    }

    @Nullable
    public Boolean isSubclassOf(@NonNull Project project, @NonNull String name, @NonNull String superClassName) {
        IJavaProject javaProject;
        block9: {
            if (!this.mSearchForSuperClasses) {
                return null;
            }
            IProject eclipseProject = this.getProject(project);
            if (eclipseProject == null) {
                return null;
            }
            javaProject = BaseProjectHelper.getJavaProject(eclipseProject);
            if (javaProject != null) break block9;
            return null;
        }
        try {
            ITypeHierarchy hierarchy;
            IType[] allSupertypes;
            String typeFqcn = ClassContext.getFqcn((String)name);
            IType type = javaProject.findType(typeFqcn);
            if (type != null && (allSupertypes = (hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor())).getAllSuperclasses(type)) != null) {
                String target = String.valueOf('L') + superClassName + ';';
                IType[] iTypeArray = allSupertypes;
                int n = allSupertypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superType = iTypeArray[n2];
                    if (target.equals(superType.getKey())) {
                        return Boolean.TRUE;
                    }
                    ++n2;
                }
                return Boolean.FALSE;
            }
        }
        catch (JavaModelException e) {
            this.log(Severity.INFORMATIONAL, e, null, new Object[0]);
        }
        catch (CoreException e) {
            this.log(Severity.INFORMATIONAL, e, null, new Object[0]);
        }
        return null;
    }

    private static class EclipseJavaParser
    extends JavaParser {
        private static final boolean USE_ECLIPSE_PARSER = true;
        private final Parser mParser;

        EclipseJavaParser() {
            CompilerOptions options = new CompilerOptions();
            options.complianceLevel = 0x330000L;
            options.sourceLevel = 0x330000L;
            options.targetJDK = 0x330000L;
            options.parseLiteralExpressionsAsConstants = true;
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitOnFirstError(), options, (IProblemFactory)new DefaultProblemFactory());
            this.mParser = new Parser(problemReporter, options.parseLiteralExpressionsAsConstants);
            this.mParser.javadocParser.checkDocComment = false;
        }

        public void prepareJavaParse(@NonNull List<JavaContext> contexts) {
        }

        public Node parseJava(@NonNull JavaContext context) {
            EcjTreeConverter converter = new EcjTreeConverter();
            String code = context.getContents();
            CompilationUnit sourceUnit = new CompilationUnit(code.toCharArray(), context.file.getName(), "UTF-8");
            CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
            CompilationUnitDeclaration unit = null;
            try {
                unit = this.mParser.parse((ICompilationUnit)sourceUnit, compilationResult);
            }
            catch (AbortCompilation abortCompilation) {
                return null;
            }
            if (unit == null) {
                return null;
            }
            try {
                converter.visit(code, (ASTNode)unit);
                List nodes = converter.getAll();
                for (Node node : nodes) {
                    if (!(node instanceof lombok.ast.CompilationUnit)) continue;
                    return node;
                }
                return null;
            }
            catch (Throwable t) {
                AdtPlugin.log(t, "Failed converting ECJ parse tree to Lombok for file %1$s", context.file.getPath());
                return null;
            }
        }

        @NonNull
        public Location getLocation(@NonNull JavaContext context, @NonNull Node node) {
            Position position = node.getPosition();
            return Location.create((File)context.file, (String)context.getContents(), (int)position.getStart(), (int)position.getEnd());
        }

        @NonNull
        public Location.Handle createLocationHandle(@NonNull JavaContext context, @NonNull Node node) {
            return new LocationHandle(context.file, node);
        }

        public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
        }

        @Nullable
        public JavaParser.ResolvedNode resolve(@NonNull JavaContext context, @NonNull Node node) {
            return null;
        }

        @Nullable
        public JavaParser.TypeDescriptor getType(@NonNull JavaContext context, @NonNull Node node) {
            return null;
        }

        private class LocationHandle
        implements Location.Handle {
            private File mFile;
            private Node mNode;
            private Object mClientData;

            public LocationHandle(File file, Node node) {
                this.mFile = file;
                this.mNode = node;
            }

            @NonNull
            public Location resolve() {
                Position pos = this.mNode.getPosition();
                return Location.create((File)this.mFile, null, (int)pos.getStart(), (int)pos.getEnd());
            }

            public void setClientData(@Nullable Object clientData) {
                this.mClientData = clientData;
            }

            @Nullable
            public Object getClientData() {
                return this.mClientData;
            }
        }
    }

    private static class LazyLocation
    extends Location
    implements Location.Handle {
        private final IStructuredDocument mDocument;
        private final IndexedRegion mRegion;
        private com.android.tools.lint.detector.api.Position mStart;
        private com.android.tools.lint.detector.api.Position mEnd;

        public LazyLocation(File file, IStructuredDocument document, IndexedRegion region) {
            super(file, null, null);
            this.mDocument = document;
            this.mRegion = region;
        }

        public com.android.tools.lint.detector.api.Position getStart() {
            if (this.mStart == null) {
                int line = -1;
                int column = -1;
                int offset = this.mRegion.getStartOffset();
                if (this.mRegion instanceof Text && this.mDocument != null) {
                    int i = offset;
                    while (i < this.mRegion.getEndOffset() && i < this.mDocument.getLength()) {
                        try {
                            char c = this.mDocument.getChar(i);
                            if (!Character.isWhitespace(c)) {
                                offset = i;
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                        break;
                        ++i;
                    }
                }
                if (this.mDocument != null && offset < this.mDocument.getLength()) {
                    line = this.mDocument.getLineOfOffset(offset);
                    column = -1;
                    try {
                        int lineOffset = this.mDocument.getLineOffset(line);
                        column = offset - lineOffset;
                    }
                    catch (BadLocationException e) {
                        AdtPlugin.log(e, null, new Object[0]);
                    }
                }
                this.mStart = new DefaultPosition(line, column, offset);
            }
            return this.mStart;
        }

        public com.android.tools.lint.detector.api.Position getEnd() {
            if (this.mEnd == null) {
                this.mEnd = new DefaultPosition(-1, -1, this.mRegion.getEndOffset());
            }
            return this.mEnd;
        }

        @NonNull
        public Location resolve() {
            return this;
        }
    }
}

