/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.resources.Density;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class InputDensityDialog
extends Dialog {
    private Combo mCombo;
    private static int sDpi = 160;

    InputDensityDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblWhatIsThe = new Label(container, 64);
        lblWhatIsThe.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblWhatIsThe.setText("What is the screen density the current px value works with?");
        this.mCombo = new Combo(container, 8);
        GridData gdCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdCombo.widthHint = 200;
        this.mCombo.setLayoutData((Object)gdCombo);
        int initialIndex = 0;
        ArrayList<String> s = new ArrayList<String>();
        int index = 0;
        Density[] densityArray = Density.values();
        int n = densityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Density density = densityArray[n2];
            if (density != Density.NODPI) {
                if (density.getDpiValue() == sDpi) {
                    initialIndex = index;
                }
                s.add(InputDensityDialog.getLabel(density));
                ++index;
            }
            ++n2;
        }
        String[] items = s.toArray(new String[s.size()]);
        this.mCombo.setItems(items);
        this.mCombo.select(initialIndex);
        return container;
    }

    private static String getLabel(Density density) {
        return String.format("%1$s (%2$d)", density.getShortDisplayValue(), density.getDpiValue());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 150);
    }

    public boolean close() {
        String description = this.mCombo.getItem(this.mCombo.getSelectionIndex());
        Density[] densityArray = Density.values();
        int n = densityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Density density = densityArray[n2];
            if (description.equals(InputDensityDialog.getLabel(density))) {
                sDpi = density.getDpiValue();
                break;
            }
            ++n2;
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose Density");
    }

    int getDensity() {
        return sDpi;
    }
}

