/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.lint.AddPrefixFix;
import com.android.ide.eclipse.adt.internal.lint.ConvertToDpFix;
import com.android.ide.eclipse.adt.internal.lint.DosLineEndingsFix;
import com.android.ide.eclipse.adt.internal.lint.EclipseLintClient;
import com.android.ide.eclipse.adt.internal.lint.ExtractStringFix;
import com.android.ide.eclipse.adt.internal.lint.LinearLayoutWeightFix;
import com.android.ide.eclipse.adt.internal.lint.ObsoleteLayoutParamsFix;
import com.android.ide.eclipse.adt.internal.lint.RemoveUselessViewFix;
import com.android.ide.eclipse.adt.internal.lint.SetAttributeFix;
import com.android.ide.eclipse.adt.internal.lint.SetScrollViewSizeFix;
import com.android.ide.eclipse.adt.internal.lint.TypoFix;
import com.android.ide.eclipse.adt.internal.lint.TypographyFix;
import com.android.ide.eclipse.adt.internal.lint.UseCompoundDrawableDetectorFix;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DosLineEndingDetector;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UseCompoundDrawableDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.detector.api.Issue;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

abstract class LintFix
implements ICompletionProposal {
    protected final IMarker mMarker;
    protected final String mId;
    private static final Map<String, Class<? extends LintFix>> sFixes = new HashMap<String, Class<? extends LintFix>>();

    static {
        sFixes.put(InefficientWeightDetector.INEFFICIENT_WEIGHT.getId(), LinearLayoutWeightFix.class);
        sFixes.put(AccessibilityDetector.ISSUE.getId(), SetAttributeFix.class);
        sFixes.put(InefficientWeightDetector.BASELINE_WEIGHTS.getId(), SetAttributeFix.class);
        sFixes.put(ManifestDetector.ALLOW_BACKUP.getId(), SetAttributeFix.class);
        sFixes.put(MissingIdDetector.ISSUE.getId(), SetAttributeFix.class);
        sFixes.put(HardcodedValuesDetector.ISSUE.getId(), ExtractStringFix.class);
        sFixes.put(UselessViewDetector.USELESS_LEAF.getId(), RemoveUselessViewFix.class);
        sFixes.put(UselessViewDetector.USELESS_PARENT.getId(), RemoveUselessViewFix.class);
        sFixes.put(PxUsageDetector.PX_ISSUE.getId(), ConvertToDpFix.class);
        sFixes.put(TextFieldDetector.ISSUE.getId(), SetAttributeFix.class);
        sFixes.put(SecurityDetector.EXPORTED_SERVICE.getId(), SetAttributeFix.class);
        sFixes.put(TranslationDetector.MISSING.getId(), SetAttributeFix.class);
        sFixes.put(DetectMissingPrefix.MISSING_NAMESPACE.getId(), AddPrefixFix.class);
        sFixes.put(ScrollViewChildDetector.ISSUE.getId(), SetScrollViewSizeFix.class);
        sFixes.put(ObsoleteLayoutParamsDetector.ISSUE.getId(), ObsoleteLayoutParamsFix.class);
        sFixes.put(TypographyDetector.DASHES.getId(), TypographyFix.class);
        sFixes.put(TypographyDetector.ELLIPSIS.getId(), TypographyFix.class);
        sFixes.put(TypographyDetector.FRACTIONS.getId(), TypographyFix.class);
        sFixes.put(TypographyDetector.OTHER.getId(), TypographyFix.class);
        sFixes.put(TypographyDetector.QUOTES.getId(), TypographyFix.class);
        sFixes.put(UseCompoundDrawableDetector.ISSUE.getId(), UseCompoundDrawableDetectorFix.class);
        sFixes.put(TypoDetector.ISSUE.getId(), TypoFix.class);
        sFixes.put(DosLineEndingDetector.ISSUE.getId(), DosLineEndingsFix.class);
    }

    protected LintFix(String id, IMarker marker) {
        this.mId = id;
        this.mMarker = marker;
    }

    public boolean needsFocus() {
        return true;
    }

    public boolean isBulkCapable() {
        return false;
    }

    public boolean isCancelable() {
        return true;
    }

    public String getDisplayString() {
        return null;
    }

    public String getAdditionalProposalInfo() {
        Issue issue = EclipseLintClient.getRegistry().getIssue(this.mId);
        if (issue != null) {
            return issue.getExplanation(Issue.OutputFormat.HTML);
        }
        return null;
    }

    public void deleteMarker() {
        try {
            this.mMarker.delete();
        }
        catch (PartInitException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public Image getImage() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return sharedImages.getImage("IMG_OBJS_WARN_TSK");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public static boolean hasFix(String id) {
        return sFixes.containsKey(id);
    }

    @Nullable
    public static List<LintFix> getFixes(@NonNull String id, @NonNull IMarker marker) {
        Class<? extends LintFix> clazz = sFixes.get(id);
        if (clazz != null) {
            try {
                Constructor<? extends LintFix> constructor = clazz.getDeclaredConstructor(String.class, IMarker.class);
                constructor.setAccessible(true);
                LintFix fix = constructor.newInstance(id, marker);
                List<LintFix> alternatives = fix.getAllFixes();
                if (alternatives != null) {
                    return alternatives;
                }
                return Collections.singletonList(fix);
            }
            catch (Throwable t) {
                AdtPlugin.log(t, null, new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    protected List<LintFix> getAllFixes() {
        return null;
    }
}

