/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutActionBar;
import com.android.ide.eclipse.adt.internal.lint.ColumnDialog;
import com.android.ide.eclipse.adt.internal.lint.EclipseLintClient;
import com.android.ide.eclipse.adt.internal.lint.GlobalLintConfiguration;
import com.android.ide.eclipse.adt.internal.lint.LintColumn;
import com.android.ide.eclipse.adt.internal.lint.ProjectLintConfiguration;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.ArrayListMultimap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

class LintList
extends Composite
implements IResourceChangeListener,
ControlListener {
    private static final Object UPDATE_MARKERS_FAMILY = new Object();
    private static final String KEY_WIDTHS = "lintColWidth";
    private static final String KEY_VISIBLE = "lintColVisible";
    private static final String KEY_COLUMN = "lintColumn";
    private final IWorkbenchPartSite mSite;
    private final TreeViewer mTreeViewer;
    private final Tree mTree;
    private Set<String> mExpandedIds;
    private ContentProvider mContentProvider;
    private String mSelectedId;
    private List<? extends IResource> mResources;
    private Configuration mConfiguration;
    private final boolean mSingleFile;
    private int mErrorCount;
    private int mWarningCount;
    private final UpdateMarkersJob mUpdateMarkersJob = new UpdateMarkersJob();
    private final IssueRegistry mRegistry;
    private final IMemento mMemento;
    private final LintColumn mMessageColumn = new LintColumn.MessageColumn(this);
    private final LintColumn mLineColumn = new LintColumn.LineColumn(this);
    private final LintColumn[] mColumns = new LintColumn[]{this.mMessageColumn, new LintColumn.PriorityColumn(this), new LintColumn.CategoryColumn(this), new LintColumn.LocationColumn(this), new LintColumn.FileColumn(this), new LintColumn.PathColumn(this), this.mLineColumn};
    private LintColumn[] mVisibleColumns;
    private boolean mTreePainted;

    LintList(IWorkbenchPartSite site, Composite parent, IMemento memento, boolean singleFile) {
        super(parent, 0);
        this.mSingleFile = singleFile;
        this.mMemento = memento;
        this.mSite = site;
        this.mRegistry = EclipseLintClient.getRegistry();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.mTreeViewer = new TreeViewer((Composite)this, 67586);
        this.mTree = this.mTreeViewer.getTree();
        this.mTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createColumns();
        this.mTreeViewer.setComparator((ViewerComparator)new TableComparator());
        this.setSortIndicators();
        this.mContentProvider = new ContentProvider();
        this.mTreeViewer.setContentProvider((IContentProvider)this.mContentProvider);
        this.mTree.setLinesVisible(true);
        this.mTree.setHeaderVisible(true);
        this.mTree.addControlListener((ControlListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 25);
        this.mTree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                LintList.this.mTreePainted = true;
                LintList.this.mTreeViewer.getTree().removePaintListener((PaintListener)this);
            }
        });
        this.mTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<IMarker> markers = LintList.this.getSelectedMarkers();
                if (markers.size() > 0) {
                    LintList.this.mSelectedId = EclipseLintClient.getId(markers.get(0));
                }
            }
        });
        this.mTree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                String id;
                Object data = e.item.getData();
                if (data instanceof IMarker && (id = EclipseLintClient.getId((IMarker)data)) != null) {
                    if (LintList.this.mExpandedIds == null) {
                        LintList.this.mExpandedIds = new HashSet();
                    }
                    LintList.this.mExpandedIds.add(id);
                }
            }

            public void treeCollapsed(TreeEvent e) {
                String id;
                Object data;
                if (LintList.this.mExpandedIds != null && (data = e.item.getData()) instanceof IMarker && (id = EclipseLintClient.getId((IMarker)data)) != null) {
                    LintList.this.mExpandedIds.remove(id);
                }
            }
        });
    }

    private void updateColumnWidths() {
        Rectangle r = this.mTree.getClientArea();
        int availableWidth = r.width;
        int i = 1;
        while (i < this.mTree.getColumnCount()) {
            TreeColumn column = this.mTree.getColumn(i);
            availableWidth -= column.getWidth();
            ++i;
        }
        if (availableWidth > 100) {
            this.mTree.getColumn(0).setWidth(availableWidth);
        }
    }

    public void setResources(List<? extends IResource> resources) {
        this.mResources = resources;
        this.mConfiguration = null;
        for (IResource iResource : this.mResources) {
            IProject project = iResource.getProject();
            if (project == null) continue;
            EclipseLintClient client = new EclipseLintClient(null, null, null, false);
            this.mConfiguration = ProjectLintConfiguration.get(client, project, false);
            break;
        }
        if (this.mConfiguration == null) {
            this.mConfiguration = GlobalLintConfiguration.get();
        }
        List<IMarker> list = this.getMarkers();
        this.mTreeViewer.setInput(list);
        if (this.mSingleFile) {
            this.expandAll();
        }
        this.updateColumnWidths();
    }

    public void selectFirst() {
        if (this.mTree.getItemCount() > 0) {
            this.mTree.select(this.mTree.getItem(0));
        }
    }

    private List<IMarker> getMarkers() {
        this.mWarningCount = 0;
        this.mErrorCount = 0;
        ArrayList<IMarker> markerList = new ArrayList<IMarker>();
        if (this.mResources != null) {
            for (IResource iResource : this.mResources) {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = EclipseLintClient.getMarkers(iResource);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    markerList.add(marker);
                    int severity = marker.getAttribute("severity", 0);
                    if (severity == 2) {
                        ++this.mErrorCount;
                    } else if (severity == 1) {
                        ++this.mWarningCount;
                    }
                    ++n2;
                }
            }
        }
        return markerList;
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public int getWarningCount() {
        return this.mWarningCount;
    }

    protected void checkSubclass() {
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mTree.addSelectionListener(listener);
    }

    public void refresh() {
        this.mTreeViewer.refresh();
    }

    public List<IMarker> getSelectedMarkers() {
        TreeItem[] selection = this.mTree.getSelection();
        ArrayList<IMarker> markers = new ArrayList<IMarker>(selection.length);
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof IMarker) {
                markers.add((IMarker)data);
            }
            ++n2;
        }
        return markers;
    }

    public void dispose() {
        this.cancelJobs();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    TreeViewer getTreeViewer() {
        return this.mTreeViewer;
    }

    Tree getTree() {
        return this.mTree;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.mResources == null) {
            return;
        }
        IMarkerDelta[] deltas = event.findMarkerDeltas("com.android.ide.eclipse.adt.lintProblem", true);
        if (deltas.length > 0) {
            if (event.getType() == 16) {
                this.cancelJobs();
                this.getProgressService().schedule((Job)this.mUpdateMarkersJob, 100L);
            } else {
                IWorkbenchSiteProgressService progressService = this.getProgressService();
                if (progressService == null) {
                    this.mUpdateMarkersJob.schedule(30000L);
                } else {
                    this.getProgressService().schedule((Job)this.mUpdateMarkersJob, 30000L);
                }
            }
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.updateColumnWidths();
    }

    private void cancelJobs() {
        this.mUpdateMarkersJob.cancel();
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        if (this.mSite != null && (siteService = this.mSite.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    public List<? extends IResource> getResources() {
        return this.mResources;
    }

    public void expandAll() {
        IMarker[] topMarkers;
        this.mTreeViewer.expandAll();
        if (this.mExpandedIds == null) {
            this.mExpandedIds = new HashSet<String>();
        }
        if ((topMarkers = this.mContentProvider.getTopMarkers()) != null) {
            IMarker[] iMarkerArray = topMarkers;
            int n = topMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String id = EclipseLintClient.getId(marker);
                if (id != null) {
                    this.mExpandedIds.add(id);
                }
                ++n2;
            }
        }
    }

    public void collapseAll() {
        this.mTreeViewer.collapseAll();
        this.mExpandedIds = null;
    }

    public void saveState(IMemento memento) {
        if (this.mSingleFile) {
            return;
        }
        IMemento columnEntry = memento.createChild(KEY_WIDTHS);
        LintColumn[] columns = new LintColumn[this.mTree.getColumnCount()];
        int[] positions = this.mTree.getColumnOrder();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = this.mTree.getColumn(i);
            LintColumn column = (LintColumn)treeColumn.getData(KEY_COLUMN);
            int width = this.getColumnWidth(column, this.mTreePainted);
            columnEntry.putInteger(LintList.getKey(treeColumn), width);
            columns[positions[i]] = column;
            ++i;
        }
        if (this.getVisibleColumns() != null) {
            IMemento visibleEntry = memento.createChild(KEY_VISIBLE);
            LintColumn[] lintColumnArray = this.getVisibleColumns();
            int n = lintColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                LintColumn column = lintColumnArray[n2];
                visibleEntry.putBoolean(LintList.getKey(column), true);
                ++n2;
            }
        }
    }

    private void createColumns() {
        LintColumn[] columns = this.getVisibleColumns();
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columns.length) {
            LintColumn column = columns[i];
            TreeViewerColumn viewerColumn = null;
            viewerColumn = new TreeViewerColumn(this.mTreeViewer, 0);
            TreeColumn treeColumn = viewerColumn.getColumn();
            treeColumn.setData(KEY_COLUMN, (Object)column);
            treeColumn.setResizable(true);
            treeColumn.addSelectionListener(this.getHeaderListener());
            if (!column.isLeftAligned()) {
                treeColumn.setAlignment(131072);
            }
            viewerColumn.setLabelProvider((CellLabelProvider)new LintColumnLabelProvider(column));
            treeColumn.setText(column.getColumnHeaderText());
            treeColumn.setImage(column.getColumnHeaderImage());
            IMemento columnWidths = null;
            if (this.mMemento != null && !this.mSingleFile) {
                columnWidths = this.mMemento.getChild(KEY_WIDTHS);
            }
            int columnWidth = this.getColumnWidth(column, false);
            if (columnWidths != null) {
                columnWidths.putInteger(LintList.getKey(column), columnWidth);
            }
            if (i == 0) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            } else if (columnWidth < 0) {
                int defaultColumnWidth = column.getPreferredWidth();
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(defaultColumnWidth, true, true));
            } else {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(columnWidth, true));
            }
            ++i;
        }
        this.mTreeViewer.getTree().setLayout((Layout)layout);
        this.mTree.layout(true);
    }

    private int getColumnWidth(LintColumn column, boolean getFromUi) {
        Integer value;
        IMemento columnWidths;
        Tree tree = this.mTreeViewer.getTree();
        if (getFromUi) {
            TreeColumn[] columns = tree.getColumns();
            int i = 0;
            while (i < columns.length) {
                if (column.equals(columns[i].getData(KEY_COLUMN))) {
                    return columns[i].getWidth();
                }
                ++i;
            }
        }
        int preferredWidth = -1;
        if (this.mMemento != null && !this.mSingleFile && (columnWidths = this.mMemento.getChild(KEY_WIDTHS)) != null && (value = columnWidths.getInteger(LintList.getKey(column))) != null && value >= 0) {
            preferredWidth = value;
        }
        if (preferredWidth <= 0) {
            preferredWidth = Math.max(column.getPreferredWidth(), 30);
        }
        return preferredWidth;
    }

    private static String getKey(TreeColumn treeColumn) {
        return LintList.getKey((LintColumn)treeColumn.getData(KEY_COLUMN));
    }

    private static String getKey(LintColumn column) {
        return column.getClass().getSimpleName();
    }

    private LintColumn[] getVisibleColumns() {
        if (this.mVisibleColumns == null) {
            if (this.mSingleFile) {
                this.mVisibleColumns = new LintColumn[]{this.mMessageColumn, this.mLineColumn};
            } else {
                ArrayList<LintColumn> list = new ArrayList<LintColumn>();
                IMemento visibleColumns = null;
                if (this.mMemento != null) {
                    visibleColumns = this.mMemento.getChild(KEY_VISIBLE);
                }
                LintColumn[] lintColumnArray = this.mColumns;
                int n = this.mColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    LintColumn column = lintColumnArray[n2];
                    if (visibleColumns != null) {
                        Boolean b = visibleColumns.getBoolean(LintList.getKey(column));
                        if (b != null && b.booleanValue()) {
                            list.add(column);
                        }
                    } else if (column.visibleByDefault()) {
                        list.add(column);
                    }
                    ++n2;
                }
                if (!list.contains(this.mMessageColumn)) {
                    list.add(0, this.mMessageColumn);
                }
                this.mVisibleColumns = list.toArray(new LintColumn[list.size()]);
            }
        }
        return this.mVisibleColumns;
    }

    int getCount(IMarker marker) {
        return this.mContentProvider.getCount(marker);
    }

    Issue getIssue(String id) {
        return this.mRegistry.getIssue(id);
    }

    Issue getIssue(IMarker marker) {
        String id = EclipseLintClient.getId(marker);
        return this.mRegistry.getIssue(id);
    }

    Severity getSeverity(Issue issue) {
        return this.mConfiguration.getSeverity(issue);
    }

    public void configureColumns() {
        ColumnDialog dialog = new ColumnDialog(this.getShell(), this.mColumns, this.getVisibleColumns());
        if (dialog.open() == 0) {
            this.mVisibleColumns = dialog.getSelectedColumns();
            TreeColumn[] treeColumnArray = this.mTree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.dispose();
                ++n2;
            }
            this.createColumns();
            this.mTreeViewer.setComparator((ViewerComparator)new TableComparator());
            this.setSortIndicators();
            this.mTreeViewer.refresh();
        }
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final TreeColumn treeColumn = (TreeColumn)e.widget;
                final LintColumn column = (LintColumn)treeColumn.getData(LintList.KEY_COLUMN);
                try {
                    IWorkbenchSiteProgressService progressService = LintList.this.getProgressService();
                    if (progressService == null) {
                        BusyIndicator.showWhile((Display)LintList.this.getShell().getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.resortTable(treeColumn, column, (IProgressMonitor)new NullProgressMonitor());
                            }
                        });
                    } else {
                        LintList.this.getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                this.resortTable(treeColumn, column, monitor);
                            }
                        });
                    }
                }
                catch (InvocationTargetException e1) {
                    AdtPlugin.log(e1, null, new Object[0]);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            private void resortTable(final TreeColumn treeColumn, LintColumn column, IProgressMonitor monitor) {
                TableComparator sorter = LintList.this.getTableSorter();
                monitor.beginTask("Sorting", 100);
                monitor.worked(10);
                if (column.equals(sorter.getTopColumn())) {
                    sorter.reverseTopPriority();
                } else {
                    sorter.setTopPriority(column);
                }
                monitor.worked(15);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LintList.this.mTreeViewer.refresh();
                        LintList.this.updateDirectionIndicator(treeColumn);
                    }
                });
                monitor.done();
            }
        };
    }

    private void setSortIndicators() {
        LintColumn top = this.getTableSorter().getTopColumn();
        TreeColumn[] columns = this.mTreeViewer.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn column = columns[i];
            if (column.getData(KEY_COLUMN).equals(top)) {
                this.updateDirectionIndicator(column);
                return;
            }
            ++i;
        }
    }

    private void updateDirectionIndicator(TreeColumn column) {
        Tree tree = this.mTreeViewer.getTree();
        tree.setSortColumn(column);
        if (this.getTableSorter().isAscending()) {
            tree.setSortDirection(128);
        } else {
            tree.setSortDirection(1024);
        }
    }

    private TableComparator getTableSorter() {
        return (TableComparator)this.mTreeViewer.getComparator();
    }

    private class ContentProvider
    extends TreeNodeContentProvider {
        private Map<Object, Object[]> mChildren;
        private Map<IMarker, Integer> mTypeCount;
        private IMarker[] mTopLevels;

        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                this.mTypeCount = null;
                return new IMarker[0];
            }
            List list = (List)inputElement;
            ArrayListMultimap types = ArrayListMultimap.create((int)100, (int)20);
            for (IMarker marker : list) {
                String id = EclipseLintClient.getId(marker);
                types.put((Object)id, (Object)marker);
            }
            Set ids = types.keySet();
            this.mChildren = new HashMap<Object, Object[]>(ids.size());
            this.mTypeCount = new HashMap<IMarker, Integer>(ids.size());
            ArrayList<Object> topLevel = new ArrayList<Object>(ids.size());
            for (String id : ids) {
                Collection markers = types.get((Object)id);
                int childCount = markers.size();
                TableComparator sorter = LintList.this.getTableSorter();
                Object[] array = markers.toArray(new IMarker[markers.size()]);
                sorter.sort((Viewer)LintList.this.mTreeViewer, array);
                Object topMarker = array[0];
                this.mTypeCount.put((IMarker)topMarker, childCount);
                topLevel.add(topMarker);
                IMarker[] children = (IMarker[])Arrays.copyOfRange(array, 1, array.length);
                this.mChildren.put(topMarker, children);
            }
            this.mTopLevels = topLevel.toArray(new IMarker[topLevel.size()]);
            return this.mTopLevels;
        }

        public boolean hasChildren(Object element) {
            Object[] children;
            Object[] objectArray = children = this.mChildren != null ? this.mChildren.get(element) : null;
            return children != null && children.length > 0;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = this.mChildren.get(parentElement);
            if (children != null) {
                return children;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public int getCount(IMarker marker) {
            Integer count;
            if (this.mTypeCount != null && (count = this.mTypeCount.get(marker)) != null) {
                return count;
            }
            return -1;
        }

        IMarker[] getTopMarkers() {
            return this.mTopLevels;
        }
    }

    private class LintColumnLabelProvider
    extends StyledCellLabelProvider {
        private LintColumn mColumn;

        LintColumnLabelProvider(LintColumn column) {
            this.mColumn = column;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setImage(this.mColumn.getImage((IMarker)element));
            StyledString styledString = this.mColumn.getStyledValue((IMarker)element);
            if (styledString == null) {
                cell.setText(this.mColumn.getValue((IMarker)element));
                cell.setStyleRanges(null);
            } else {
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
            super.update(cell);
        }
    }

    private class TableComparator
    extends ViewerComparator {
        private int[] mPriorities;
        private boolean[] mDirections;
        private int[] mDefaultPriorities;
        private boolean[] mDefaultDirections;

        private TableComparator() {
            int[] defaultPriorities = new int[LintList.this.mColumns.length];
            int i = 0;
            while (i < defaultPriorities.length) {
                defaultPriorities[i] = i;
                ++i;
            }
            this.mPriorities = defaultPriorities;
            boolean[] directions = new boolean[LintList.this.mColumns.length];
            int i2 = 0;
            while (i2 < directions.length) {
                directions[i2] = LintList.this.mColumns[i2].isAscending();
                ++i2;
            }
            this.mDirections = directions;
            this.mDefaultPriorities = new int[defaultPriorities.length];
            System.arraycopy(defaultPriorities, 0, this.mDefaultPriorities, 0, defaultPriorities.length);
            this.mDefaultDirections = new boolean[directions.length];
            System.arraycopy(directions, 0, this.mDefaultDirections, 0, directions.length);
        }

        private void resetState() {
            System.arraycopy(this.mDefaultPriorities, 0, this.mPriorities, 0, this.mPriorities.length);
            System.arraycopy(this.mDefaultDirections, 0, this.mDirections, 0, this.mDirections.length);
        }

        private void reverseTopPriority() {
            this.mDirections[this.mPriorities[0]] = !this.mDirections[this.mPriorities[0]];
        }

        private void setTopPriority(LintColumn property) {
            int i = 0;
            while (i < LintList.this.mColumns.length) {
                if (LintList.this.mColumns[i].equals(property)) {
                    this.setTopPriority(i);
                    return;
                }
                ++i;
            }
        }

        private void setTopPriority(int priority) {
            if (priority < 0 || priority >= this.mPriorities.length) {
                return;
            }
            int index = -1;
            int i = 0;
            while (i < this.mPriorities.length) {
                if (this.mPriorities[i] == priority) {
                    index = i;
                }
                ++i;
            }
            if (index == -1) {
                this.resetState();
                return;
            }
            i = index;
            while (i > 0) {
                this.mPriorities[i] = this.mPriorities[i - 1];
                --i;
            }
            this.mPriorities[0] = priority;
            this.mDirections[priority] = this.mDefaultDirections[priority];
        }

        private boolean isAscending() {
            return this.mDirections[this.mPriorities[0]];
        }

        private int getTopPriority() {
            return this.mPriorities[0];
        }

        private LintColumn getTopColumn() {
            return LintList.this.mColumns[this.getTopPriority()];
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare((IMarker)e1, (IMarker)e2, 0, true);
        }

        private int compare(IMarker marker1, IMarker marker2, int depth, boolean continueSearching) {
            if (depth >= this.mPriorities.length) {
                return 0;
            }
            int column = this.mPriorities[depth];
            LintColumn property = LintList.this.mColumns[column];
            int result = property.compare(marker1, marker2);
            if (result == 0 && continueSearching) {
                return this.compare(marker1, marker2, depth + 1, continueSearching);
            }
            return result * (this.mDirections[column] ? 1 : -1);
        }
    }

    private class UpdateMarkersJob
    extends WorkbenchJob {
        UpdateMarkersJob() {
            super("Updating Lint Markers");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            int n;
            LayoutEditorDelegate delegate;
            if (LintList.this.mTree.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            LintList.this.mTreeViewer.setInput(null);
            List markerList = LintList.this.getMarkers();
            if (markerList.size() == 0 && (delegate = LayoutEditorDelegate.fromEditor(AdtUtils.getActiveEditor())) != null) {
                LayoutActionBar bar;
                GraphicalEditorPart g = delegate.getGraphicalEditor();
                assert (g != null);
                LayoutActionBar layoutActionBar = bar = g == null ? null : g.getLayoutActionBar();
                assert (bar != null);
                if (bar != null) {
                    bar.updateErrorIndicator();
                }
            }
            Event updateEvent = new Event();
            updateEvent.widget = LintList.this.mTree;
            LintList.this.mTree.notifyListeners(13, updateEvent);
            LintList.this.mTreeViewer.setInput((Object)markerList);
            LintList.this.mTreeViewer.refresh();
            if (LintList.this.mExpandedIds != null) {
                ArrayList<IMarker> expanded = new ArrayList<IMarker>(LintList.this.mExpandedIds.size());
                IMarker[] topMarkers = LintList.this.mContentProvider.getTopMarkers();
                if (topMarkers != null) {
                    IMarker[] iMarkerArray = topMarkers;
                    int n2 = topMarkers.length;
                    n = 0;
                    while (n < n2) {
                        IMarker marker = iMarkerArray[n];
                        String id = EclipseLintClient.getId(marker);
                        if (id != null && LintList.this.mExpandedIds.contains(id)) {
                            expanded.add(marker);
                        }
                        ++n;
                    }
                }
                if (!expanded.isEmpty()) {
                    LintList.this.mTreeViewer.setExpandedElements(expanded.toArray());
                }
            }
            if (LintList.this.mSelectedId != null) {
                IMarker[] topMarkers;
                IMarker[] iMarkerArray = topMarkers = LintList.this.mContentProvider.getTopMarkers();
                n = topMarkers.length;
                int n3 = 0;
                while (n3 < n) {
                    IMarker marker = iMarkerArray[n3];
                    if (LintList.this.mSelectedId.equals(EclipseLintClient.getId(marker))) {
                        LintList.this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)marker), true);
                        break;
                    }
                    ++n3;
                }
            }
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return PlatformUI.isWorkbenchRunning();
        }

        public boolean belongsTo(Object family) {
            return UPDATE_MARKERS_FAMILY == family;
        }
    }
}

