/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenJavaPerspectiveAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class BaseProjectHelper {
    public static final String TEST_CLASS_OK = null;

    @NonNull
    public static List<IPath> getSourceClasspaths(IJavaProject javaProject) {
        ArrayList sourceList = Lists.newArrayList();
        IClasspathEntry[] classpaths = javaProject.readRawClasspath();
        if (classpaths != null) {
            IClasspathEntry[] iClasspathEntryArray = classpaths;
            int n = classpaths.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3) {
                    sourceList.add(e.getPath());
                }
                ++n2;
            }
        }
        return sourceList;
    }

    public static List<IPath> getSourceClasspaths(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return BaseProjectHelper.getSourceClasspaths(javaProject);
    }

    public static final IMarker markResource(IResource resource, String markerId, String message, int lineNumber, int severity) {
        return BaseProjectHelper.markResource(resource, markerId, message, lineNumber, -1, -1, severity);
    }

    @Nullable
    public static final IMarker markResource(IResource resource, String markerId, String message, int lineNumber, int startOffset, int endOffset, int severity) {
        if (!resource.isAccessible()) {
            return null;
        }
        try {
            IMarker marker = resource.createMarker(markerId);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber < 1 && marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
                lineNumber = 1;
            }
            if (lineNumber >= 1) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            if (startOffset != -1) {
                marker.setAttribute("charStart", startOffset);
                marker.setAttribute("charEnd", endOffset);
            }
            resource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            return marker;
        }
        catch (CoreException e) {
            AdtPlugin.log(e, "Failed to add marker '%1$s' to '%2$s'", markerId, resource.getFullPath());
            return null;
        }
    }

    @Nullable
    public static final IMarker markResource(IResource resource, String markerId, String message, int severity) {
        return BaseProjectHelper.markResource(resource, markerId, message, -1, severity);
    }

    @Nullable
    public static final IMarker markProject(IProject project, String markerId, String message, int severity, int priority) throws CoreException {
        if (!project.isAccessible()) {
            return null;
        }
        IMarker marker = project.createMarker(markerId);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", severity);
        marker.setAttribute("priority", priority);
        project.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return marker;
    }

    public static final String testClassForManifest(IJavaProject javaProject, String className, String superClassName, boolean testVisibility) {
        try {
            String javaClassName = className.replaceAll("\\$", "\\.");
            IType type = javaProject.findType(javaClassName);
            if (type != null && type.exists()) {
                IType tmpType;
                int flags = type.getFlags();
                if (Flags.isAbstract((int)flags)) {
                    return String.format("%1$s is abstract", className);
                }
                if (testVisibility && !Flags.isPublic((int)flags)) {
                    IMethod basicConstructor = type.getMethod(type.getElementName(), new String[0]);
                    if (basicConstructor != null && basicConstructor.exists()) {
                        int constructFlags = basicConstructor.getFlags();
                        if (!Flags.isPublic((int)constructFlags)) {
                            return String.format("%1$s or its default constructor must be public for the system to be able to instantiate it", className);
                        }
                    } else {
                        return String.format("%1$s must be public, or the system will not be able to instantiate it.", className);
                    }
                }
                IType declaringType = type;
                do {
                    if ((tmpType = declaringType.getDeclaringType()) == null) continue;
                    if (tmpType.exists()) {
                        flags = declaringType.getFlags();
                        if (!Flags.isStatic((int)flags)) {
                            return String.format("%1$s is enclosed, but not static", declaringType.getFullyQualifiedName());
                        }
                        flags = tmpType.getFlags();
                        if (!testVisibility || Flags.isPublic((int)flags)) continue;
                        return String.format("%1$s is not public", tmpType.getFullyQualifiedName());
                    }
                    tmpType = null;
                } while ((declaringType = tmpType) != null);
                ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType superType = type;
                boolean foundProperSuperClass = false;
                while ((superType = hierarchy.getSuperclass(superType)) != null && superType.exists()) {
                    if (!superClassName.equals(superType.getFullyQualifiedName())) continue;
                    foundProperSuperClass = true;
                }
                if (!foundProperSuperClass) {
                    return String.format("%1$s does not extend %2$s", className, superClassName);
                }
                return TEST_CLASS_OK;
            }
            return String.format("Class %1$s does not exist", className);
        }
        catch (JavaModelException e) {
            return String.format("%1$s: %2$s", className, e.getMessage());
        }
    }

    public static IJavaProject getJavaProject(IProject project) throws CoreException {
        if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean revealSource(IProject project, String className, int line) {
        int pos = className.indexOf(36);
        if (pos != -1) {
            className = className.substring(0, pos);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IType result = javaProject.findType(className);
            if (result != null && result.exists()) {
                IEditorPart editor;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (!page.isEditorAreaVisible()) {
                    new OpenJavaPerspectiveAction().run();
                }
                if ((editor = JavaUI.openInEditor((IJavaElement)result)) instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    IEditorInput input = textEditor.getEditorInput();
                    IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                    IDocument document = documentProvider.getDocument((Object)input);
                    IRegion lineInfo = document.getLineInformation(line - 1);
                    textEditor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
                }
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (PartInitException partInitException) {
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    @NonNull
    public static IJavaProject[] getAndroidProjects(@Nullable IProjectFilter filter) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        return BaseProjectHelper.getAndroidProjects(javaModel, filter);
    }

    @NonNull
    public static IJavaProject[] getAndroidProjects(@NonNull IJavaModel javaModel, @Nullable IProjectFilter filter) {
        IJavaProject[] javaProjectList = null;
        try {
            javaProjectList = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return new IJavaProject[0];
        }
        ArrayList<IJavaProject> androidProjectList = new ArrayList<IJavaProject>();
        IJavaProject[] iJavaProjectArray = javaProjectList;
        int n = javaProjectList.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            IProject project = javaProject.getProject();
            if (BaseProjectHelper.isAndroidProject(project) && (filter == null || filter.accept(project))) {
                androidProjectList.add(javaProject);
            }
            ++n2;
        }
        return androidProjectList.toArray(new IJavaProject[androidProjectList.size()]);
    }

    public static boolean isAndroidProject(IProject project) {
        try {
            return project.hasNature("com.android.ide.eclipse.adt.AndroidNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static final IFolder getJavaOutputFolder(IProject project) {
        try {
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPath path = javaProject.getOutputLocation();
                path = path.removeFirstSegments(1);
                return project.getFolder(path);
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    @Nullable
    public static final IFolder getAndroidOutputFolder(IProject project) {
        try {
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                return project.getFolder("bin");
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static interface IProjectFilter {
        public boolean accept(IProject var1);
    }
}

