/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.extractstring;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringInputPage;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExtractStringProposal
implements IJavaCompletionProposal {
    private IInvocationContext mContext;

    public ExtractStringProposal(IInvocationContext context) {
        this.mContext = context;
    }

    public void apply(IDocument document) {
        IEditorPart editor = AdtUtils.getActiveEditor();
        IFile file = AdtUtils.getActiveFile();
        if (editor == null || file == null) {
            return;
        }
        ASTNode coveringNode = this.mContext.getCoveringNode();
        int start = coveringNode.getStartPosition();
        int length = coveringNode.getLength();
        TextSelection selection = new TextSelection(start, length);
        ExtractStringRefactoring refactoring = new ExtractStringRefactoring(file, editor, (ITextSelection)selection);
        ExtractStringWizard wizard = new ExtractStringWizard(refactoring, file.getProject());
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            op.run(window.getShell(), wizard.getDefaultPageTitle());
        }
        catch (InterruptedException interruptedException) {}
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        try {
            int type;
            ASTNode coveringNode = this.mContext.getCoveringNode();
            int start = coveringNode.getStartPosition();
            int length = coveringNode.getLength();
            IBuffer buffer = this.mContext.getCompilationUnit().getBuffer();
            StringBuilder sb = new StringBuilder();
            String string = buffer.getText(start, length);
            string = ExtractStringRefactoring.unquoteAttrValue(string);
            String token = ExtractStringInputPage.guessId(string);
            int i = start - 1;
            while (i > 0) {
                char c = buffer.getChar(i);
                if (c == '\r' || c == '\n') break;
                --i;
            }
            String linePrefix = buffer.getText(i + 1, start - (i + 1)).trim();
            i = start + length;
            while (i < buffer.getLength()) {
                char c = buffer.getChar(i);
                if (c == '\r' || c == '\n') break;
                ++i;
            }
            String lineSuffix = buffer.getText(start + length, i - (start + length));
            boolean useContext = false;
            ASTNode parent = coveringNode.getParent();
            if (parent != null && ((type = parent.getNodeType()) == 7 || type == 60 || type == 59 || type == 58)) {
                useContext = true;
            }
            sb.append("...<br>");
            sb.append(linePrefix);
            sb.append("<b>");
            if (useContext) {
                sb.append("context.getString(");
            }
            sb.append("R.string.");
            sb.append(token);
            if (useContext) {
                sb.append(")");
            }
            sb.append("</b>");
            sb.append(lineSuffix);
            sb.append("<br>...<br>");
            sb.append("<br>");
            sb.append("&lt;resources&gt;<br>");
            sb.append("    <b>&lt;string name=\"");
            sb.append(token);
            sb.append("\"&gt;");
            sb.append(string);
            sb.append("&lt;/string&gt;</b><br>");
            sb.append("&lt;/resources&gt;");
            return sb.toString();
        }
        catch (JavaModelException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return "Initiates the Extract String refactoring operation";
        }
    }

    public String getDisplayString() {
        return "Extract String";
    }

    public Image getImage() {
        return AdtPlugin.getAndroidLogo();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 80;
    }
}

