/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.resources.manager.GlobalProjectMonitor;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectClassLoader;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class CompiledResourcesMonitor
implements GlobalProjectMonitor.IFileListener,
GlobalProjectMonitor.IProjectListener {
    private static final CompiledResourcesMonitor sThis = new CompiledResourcesMonitor();

    public static void setupMonitor(GlobalProjectMonitor monitor) {
        monitor.addFileListener(sThis, 5);
        monitor.addProjectListener(sThis);
    }

    private CompiledResourcesMonitor() {
    }

    @Override
    public void fileChanged(@NonNull IFile file, @NonNull IMarkerDelta[] markerDeltas, int kind, @Nullable String extension, int flags, boolean isAndroidProject) {
        if (!isAndroidProject || flags == 131072) {
            return;
        }
        IProject project = file.getProject();
        if (file.getName().equals("R.class")) {
            String className = this.getRClassName(project);
            if (className == null) {
                AdtPlugin.log(4, "fileChanged: failed to find manifest package for project %1$s", project.getName());
                return;
            }
            IPath relativeClassPath = file.getFullPath().removeFirstSegments(3);
            if (this.packagePathMatches(relativeClassPath.toString(), className)) {
                this.loadAndParseRClass(project, className);
            }
        }
    }

    private boolean packagePathMatches(String path, String packageName) {
        String pathWithoutExtension = path.substring(0, path.indexOf(".class"));
        String[] pathArray = pathWithoutExtension.split(Pattern.quote(File.separator));
        String[] packageArray = packageName.split("\\.");
        int pathIndex = 0;
        int packageIndex = 0;
        while (pathIndex < pathArray.length && packageIndex < packageArray.length) {
            if (!pathArray[pathIndex].equals(packageArray[packageIndex])) {
                return false;
            }
            ++pathIndex;
            ++packageIndex;
        }
        return pathIndex == pathArray.length && packageIndex == packageArray.length;
    }

    @Override
    public void projectClosed(IProject project) {
    }

    @Override
    public void projectDeleted(IProject project) {
    }

    @Override
    public void projectOpened(IProject project) {
    }

    @Override
    public void projectRenamed(IProject project, IPath from) {
    }

    @Override
    public void projectOpenedWithWorkspace(IProject project) {
        try {
            if (project.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                String className = this.getRClassName(project);
                if (className == null) {
                    AdtPlugin.log(4, "projectOpenedWithWorkspace: failed to find manifest package for project %1$s", project.getName());
                    return;
                }
                this.loadAndParseRClass(project, className);
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public void allProjectsOpenedWithWorkspace() {
    }

    private void loadAndParseRClass(IProject project, String className) {
        block5: {
            try {
                ProjectResources projectResources = ResourceManager.getInstance().getProjectResources(project);
                if (projectResources == null) break block5;
                ProjectClassLoader loader = new ProjectClassLoader(null, project);
                try {
                    EnumMap<ResourceType, Map<String, Integer>> resourceValueMap;
                    HashMap<IntArrayWrapper, String> styleableValueToNameMap;
                    HashMap<Integer, Pair<ResourceType, String>> genericValueToNameMap;
                    Class<?> clazz = loader.loadClass(className);
                    if (clazz != null && this.parseClass(clazz, genericValueToNameMap = new HashMap<Integer, Pair<ResourceType, String>>(), styleableValueToNameMap = new HashMap<IntArrayWrapper, String>(), resourceValueMap = new EnumMap<ResourceType, Map<String, Integer>>(ResourceType.class))) {
                        projectResources.setCompiledResources(genericValueToNameMap, styleableValueToNameMap, resourceValueMap);
                    }
                }
                catch (Error e) {
                    AdtPlugin.log(e, "loadAndParseRClass failed to find class %1$s", className);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private boolean parseClass(Class<?> rClass, Map<Integer, Pair<ResourceType, String>> genericValueToNameMap, Map<IntArrayWrapper, String> styleableValueToNameMap, Map<ResourceType, Map<String, Integer>> resourceValueMap) {
        try {
            Class<?>[] classArray = rClass.getDeclaredClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> inner = classArray[n2];
                String resTypeName = inner.getSimpleName();
                ResourceType resType = ResourceType.getEnum((String)resTypeName);
                if (resType != null) {
                    HashMap<String, Integer> fullMap = new HashMap<String, Integer>();
                    resourceValueMap.put(resType, fullMap);
                    Field[] fieldArray = inner.getDeclaredFields();
                    int n3 = fieldArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Field f = fieldArray[n4];
                        int modifiers = f.getModifiers();
                        if (Modifier.isStatic(modifiers)) {
                            Class<?> type = f.getType();
                            if (type.isArray() && type.getComponentType() == Integer.TYPE) {
                                styleableValueToNameMap.put(new IntArrayWrapper((int[])f.get(null)), f.getName());
                            } else if (type == Integer.TYPE) {
                                Integer value = (Integer)f.get(null);
                                genericValueToNameMap.put(value, (Pair<ResourceType, String>)Pair.of((Object)resType, (Object)f.getName()));
                                fullMap.put(f.getName(), value);
                            } else assert (false);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    private String getRClassName(IProject project) {
        ManifestData data;
        IFile manifestFile = ProjectHelper.getManifest(project);
        if (manifestFile != null && manifestFile.isSynchronized(0) && (data = AndroidManifestHelper.parseForData(manifestFile)) != null) {
            String javaPackage = data.getPackage();
            return String.valueOf(javaPackage) + ".R";
        }
        return null;
    }
}

