/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.BuildHelper;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class ProjectClassLoader
extends ClassLoader {
    private final IJavaProject mJavaProject;
    private URLClassLoader mJarClassLoader;
    private boolean mInsideJarClassLoader = false;

    public ProjectClassLoader(ClassLoader parentClassLoader, IProject project) {
        super(parentClassLoader);
        this.mJavaProject = JavaCore.create((IProject)project);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.mInsideJarClassLoader) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = this.loadFromProject(this.mJavaProject, name);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.loadClassFromJar(name);
        if (clazz != null) {
            return clazz;
        }
        try {
            ProjectState projectState = Sdk.getProjectState(this.mJavaProject.getProject());
            if (projectState != null) {
                List<IProject> libProjects = projectState.getFullLibraryProjects();
                List<IJavaProject> referencedJavaProjects = BuildHelper.getJavaProjects(libProjects);
                for (IJavaProject javaProject : referencedJavaProjects) {
                    clazz = this.loadFromProject(javaProject, name);
                    if (clazz == null) continue;
                    return clazz;
                }
            }
        }
        catch (CoreException coreException) {}
        throw new ClassNotFoundException(name);
    }

    private Class<?> loadFromProject(IJavaProject project, String name) {
        block13: {
            File classFile;
            block12: {
                IResource outRes;
                block11: {
                    try {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IPath outputLocation = project.getOutputLocation();
                        outRes = root.findMember(outputLocation);
                        if (outRes != null) break block11;
                        return null;
                    }
                    catch (Exception exception) {}
                }
                File outFolder = new File(outRes.getLocation().toOSString());
                String[] segments = name.split("\\.");
                classFile = this.getFile(outFolder, segments, 0);
                if (classFile != null) break block12;
                return null;
            }
            FileInputStream fis = new FileInputStream(classFile);
            byte[] data = new byte[(int)classFile.length()];
            int read = 0;
            try {
                read = fis.read(data);
            }
            catch (IOException iOException) {
                data = null;
            }
            fis.close();
            if (data == null) break block13;
            try {
                Class<?> clazz = this.defineClass(null, data, 0, read);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (UnsupportedClassVersionError e) {
                int maxVersion = 50;
                try {
                    byte[] rewritten = ProjectClassLoader.rewriteClass(data, maxVersion, 0);
                    return this.defineClass(null, rewritten, 0, rewritten.length);
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    throw e;
                }
            }
        }
        return null;
    }

    public static byte[] rewriteClass(byte[] classData, final int maxVersion, final int minVersion) {
        assert (maxVersion >= minVersion);
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(262144, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (version > maxVersion) {
                    version = maxVersion;
                }
                if (version < minVersion) {
                    version = minVersion;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
        ClassReader reader = new ClassReader(classData);
        reader.accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    private File getFile(File parent, String[] segments, int index) throws FileNotFoundException {
        if (index == segments.length) {
            throw new FileNotFoundException();
        }
        String toMatch = segments[index];
        File[] files = parent.listFiles();
        if (index == segments.length - 1) {
            toMatch = String.valueOf(toMatch) + ".class";
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile() && file.getName().equals(toMatch)) {
                        return file;
                    }
                    ++n2;
                }
            }
            throw new FileNotFoundException();
        }
        String innerClassName = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File file = fileArray[n3];
                if (file.isDirectory()) {
                    if (toMatch.equals(file.getName())) {
                        return this.getFile(file, segments, index + 1);
                    }
                } else if (file.getName().startsWith(toMatch)) {
                    if (innerClassName == null) {
                        StringBuilder sb = new StringBuilder(segments[index]);
                        int i = index + 1;
                        while (i < segments.length) {
                            sb.append('$');
                            sb.append(segments[i]);
                            ++i;
                        }
                        sb.append(".class");
                        innerClassName = sb.toString();
                    }
                    if (file.getName().equals(innerClassName)) {
                        return file;
                    }
                }
                ++n3;
            }
        }
        return null;
    }

    private Class<?> loadClassFromJar(String name) {
        if (this.mJarClassLoader == null) {
            URL[] jars = this.getExternalJars();
            this.mJarClassLoader = new URLClassLoader(jars, (ClassLoader)this);
        }
        try {
            this.mInsideJarClassLoader = true;
            Class<?> clazz = this.mJarClassLoader.loadClass(name);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        finally {
            this.mInsideJarClassLoader = false;
        }
    }

    private final URL[] getExternalJars() {
        IJavaProject javaProject = JavaCore.create((IProject)this.mJavaProject.getProject());
        ArrayList<URL> oslibraryList = new ArrayList<URL>();
        IClasspathEntry[] classpaths = javaProject.readRawClasspath();
        if (classpaths != null) {
            IClasspathEntry[] iClasspathEntryArray = classpaths;
            int n = classpaths.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 1 || e.getEntryKind() == 4) {
                    if (e.getEntryKind() == 4) {
                        e = JavaCore.getResolvedClasspathEntry((IClasspathEntry)e);
                    }
                    this.handleClassPathEntry(e, oslibraryList);
                } else if (e.getEntryKind() == 5) {
                    try {
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)e.getPath(), (IJavaProject)javaProject);
                        if (container != null && container.getKind() == 1) {
                            IClasspathEntry[] entries;
                            IClasspathEntry[] iClasspathEntryArray2 = entries = container.getClasspathEntries();
                            int n3 = entries.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IClasspathEntry entry = iClasspathEntryArray2[n4];
                                if (entry.getEntryKind() == 4) {
                                    entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                                }
                                this.handleClassPathEntry(entry, oslibraryList);
                                ++n4;
                            }
                        }
                    }
                    catch (JavaModelException jme) {
                        AdtPlugin.log(jme, "Failed to resolve ClasspathContainer: %s", e.getPath());
                    }
                }
                ++n2;
            }
        }
        return oslibraryList.toArray(new URL[oslibraryList.size()]);
    }

    private void handleClassPathEntry(IClasspathEntry e, ArrayList<URL> oslibraryList) {
        IPath path = e.getPath();
        if ("jar".equalsIgnoreCase(path.getFileExtension())) {
            String osFullPath;
            File f;
            boolean local = false;
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.exists() && resource.getType() == 1) {
                local = true;
                try {
                    oslibraryList.add(new File(resource.getLocation().toOSString()).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (!local && (f = new File(osFullPath = path.toOSString())).exists()) {
                try {
                    oslibraryList.add(f.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }
}

