/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.exportgradle;

import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ExportMessages;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ExportStatus;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ProjectSetupBuilder;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class FinalPage
extends WizardPage {
    private final ProjectSetupBuilder mBuilder;
    private ExportStatus mStatus;
    private Text mText;

    public FinalPage(ProjectSetupBuilder builder) {
        super("FinalPage");
        this.mBuilder = builder;
        this.setPageComplete(true);
        this.setTitle(ExportMessages.PageTitle);
        this.setDescription(ExportMessages.PageDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.mText = new Text(parent, 10);
        this.mText.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)this.mText);
        Dialog.applyDialogFont((Control)parent);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mStatus = this.mBuilder.getStatus();
            this.mBuilder.setCanFinish(!this.mStatus.hasError());
            this.mBuilder.setCanGenerate(false);
            StringBuilder sb = new StringBuilder();
            if (this.mStatus.hasError()) {
                Multimap<ExportStatus.FileStatus, File> fileStatusMap;
                Collection files;
                sb.append("There was an error!").append("\n\n");
                String errorMsg = this.mStatus.getErrorMessage();
                if (errorMsg != null) {
                    sb.append(errorMsg);
                }
                if ((files = (fileStatusMap = this.mStatus.getFileStatus()).values()) != null) {
                    sb.append("\n\n").append("Error on files:").append('\n');
                    for (File file : files) {
                        sb.append("\n").append(file.getAbsolutePath());
                    }
                }
            } else {
                sb.append("Export successful.\n\n");
                int count = this.mBuilder.getModuleCount();
                if (count > 1) {
                    sb.append(String.format("Exported %s modules", count)).append('\n');
                    sb.append(String.format("Root folder: %s", this.mBuilder.getCommonRoot().toOSString()));
                } else {
                    sb.append("Exported project: ").append(this.mBuilder.getCommonRoot().toOSString());
                }
                sb.append("\n\n").append("Choose 'Import Non-Android Studio project' in Android Studio").append('\n');
                sb.append("and select the following file:").append("\n\t");
                File bGradle = new File(this.mBuilder.getCommonRoot().toFile(), "build.gradle");
                sb.append(bGradle.getAbsolutePath());
                sb.append("\n\n").append("Do NOT import the Eclipse project itself!");
            }
            this.mText.setText(sb.toString());
        }
    }
}

