/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newxmlfile;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.eclipse.adt.internal.ui.ConfigurationSelector;
import com.android.ide.eclipse.adt.internal.wizards.newxmlfile.NewXmlFileCreationPage;
import com.android.ide.eclipse.adt.internal.wizards.newxmlfile.NewXmlFileWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChooseConfigurationPage
extends WizardPage {
    private NewXmlFileWizard.Values mValues;
    private Text mWsFolderPathTextField;
    private ConfigurationSelector mConfigSelector;
    private boolean mInternalWsFolderPathUpdate;
    private boolean mInternalConfigSelectorUpdate;
    static final String RES_FOLDER_ABS = "/res/";
    static final String RES_FOLDER_REL = "res/";

    public ChooseConfigurationPage(NewXmlFileWizard.Values values) {
        super("chooseConfig");
        this.mValues = values;
        this.setTitle("Choose Configuration Folder");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.mValues.folderPath != null) {
            this.mWsFolderPathTextField.setText(this.mValues.folderPath);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        label.setText("Optional: Choose a specific configuration to limit the XML to:");
        this.mConfigSelector = new ConfigurationSelector(composite, ConfigurationSelector.SelectorMode.DEFAULT);
        GridData gd = new GridData(1536);
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.heightHint = 250;
        this.mConfigSelector.setLayoutData(gd);
        this.mConfigSelector.setOnChangeListener(new ConfigurationChangeListener());
        String tooltip = "The folder where the file will be generated, relative to the project.";
        Label separator = new Label(composite, 258);
        GridData gdSeparator = new GridData(4, 0x1000000, false, false, 2, 1);
        gdSeparator.heightHint = 10;
        separator.setLayoutData((Object)gdSeparator);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText("Folder:");
        folderLabel.setToolTipText(tooltip);
        this.mWsFolderPathTextField = new Text(composite, 2048);
        this.mWsFolderPathTextField.setLayoutData((Object)new GridData(768));
        this.mWsFolderPathTextField.setToolTipText(tooltip);
        this.mWsFolderPathTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseConfigurationPage.this.onWsFolderPathUpdated();
            }
        });
        this.setControl((Control)composite);
        this.mConfigSelector.setConfiguration(this.mValues.configuration);
    }

    private void onWsFolderPathUpdated() {
        if (this.mInternalWsFolderPathUpdate) {
            return;
        }
        String wsFolderPath = this.mWsFolderPathTextField.getText();
        wsFolderPath = wsFolderPath.replaceAll("/+\\.\\./+|/+\\./+|//+|\\\\+|^/+", "/");
        wsFolderPath = wsFolderPath.replaceAll("^\\.\\./+|^\\./+", "");
        if ((wsFolderPath = wsFolderPath.replaceAll("/+\\.\\.$|/+\\.$|/+$", "")).startsWith(RES_FOLDER_REL)) {
            wsFolderPath = RES_FOLDER_ABS + wsFolderPath.substring(RES_FOLDER_REL.length());
            this.mInternalWsFolderPathUpdate = true;
            this.mWsFolderPathTextField.setText(wsFolderPath);
            this.mInternalWsFolderPathUpdate = false;
        }
        this.mValues.folderPath = wsFolderPath;
        if (wsFolderPath.startsWith(RES_FOLDER_ABS)) {
            String[] folderSegments;
            int pos = (wsFolderPath = wsFolderPath.substring(RES_FOLDER_ABS.length())).indexOf(47);
            if (pos >= 0) {
                wsFolderPath = wsFolderPath.substring(0, pos);
            }
            if ((folderSegments = wsFolderPath.split("-")).length > 0) {
                String folderName = folderSegments[0];
                this.mInternalConfigSelectorUpdate = true;
                this.mConfigSelector.setConfiguration(folderSegments);
                this.mInternalConfigSelectorUpdate = false;
                IWizardPage previous = ((NewXmlFileWizard)this.getWizard()).getPreviousPage((IWizardPage)this);
                if (previous instanceof NewXmlFileCreationPage) {
                    NewXmlFileCreationPage p = (NewXmlFileCreationPage)previous;
                    p.selectTypeFromFolder(folderName);
                }
            }
        }
        this.validatePage();
    }

    private void resetFolderPath(boolean validate) {
        NewXmlFileCreationPage.TypeInfo type = this.mValues.type;
        if (type != null) {
            String newPath;
            this.mConfigSelector.getConfiguration(this.mValues.configuration);
            StringBuilder sb = new StringBuilder(RES_FOLDER_ABS);
            sb.append(this.mValues.configuration.getFolderName(type.getResFolderType()));
            this.mInternalWsFolderPathUpdate = true;
            this.mValues.folderPath = newPath = sb.toString();
            this.mWsFolderPathTextField.setText(newPath);
            this.mInternalWsFolderPathUpdate = false;
            if (validate) {
                this.validatePage();
            }
        }
    }

    public String getWsFolderPath() {
        return this.mWsFolderPathTextField == null ? "" : this.mWsFolderPathTextField.getText();
    }

    private void validatePage() {
        IFile file;
        String wsFolderPath;
        String error = null;
        String warning = null;
        if (error == null) {
            ConfigurationSelector.ConfigurationState state = this.mConfigSelector.getState();
            if (state == ConfigurationSelector.ConfigurationState.INVALID_CONFIG) {
                ResourceQualifier qual = this.mConfigSelector.getInvalidQualifier();
                if (qual != null) {
                    error = String.format("The qualifier '%1$s' is invalid in the folder configuration.", qual.getName());
                }
            } else if (state == ConfigurationSelector.ConfigurationState.REGION_WITHOUT_LANGUAGE) {
                error = "The Region qualifier requires the Language qualifier.";
            }
        }
        if (error == null && !(wsFolderPath = this.getWsFolderPath()).startsWith(RES_FOLDER_ABS)) {
            error = String.format("Target folder must start with %1$s.", RES_FOLDER_ABS);
        }
        if (error == null && (file = this.mValues.getDestinationFile()) != null && file.exists()) {
            warning = "The destination file already exists";
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else if (warning != null) {
            this.setMessage(warning, 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    private class ConfigurationChangeListener
    implements Runnable {
        private ConfigurationChangeListener() {
        }

        @Override
        public void run() {
            if (ChooseConfigurationPage.this.mInternalConfigSelectorUpdate) {
                return;
            }
            ChooseConfigurationPage.this.resetFolderPath(true);
        }
    }
}

