/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public abstract class CheckedTreeEditor
extends FieldEditor
implements ICheckStateListener {
    private CheckboxTreeViewer treeViewer;
    private Composite listParent;
    private boolean isValid;
    private boolean emptySelectionAllowed = false;

    protected CheckedTreeEditor() {
    }

    public CheckedTreeEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
            ((GridData)this.getTreeControl().getLayoutData()).horizontalSpan = numColumns;
        } else {
            ((GridData)this.getTreeControl().getLayoutData()).horizontalSpan = numColumns;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.doFillLabelIntoGrid(parent, numColumns);
        this.doFillBoxIntoGrid(parent, numColumns);
    }

    protected void doFillLabelIntoGrid(Composite parent, int numColumns) {
        String text = this.getLabelText();
        if (text != null && text.length() > 0) {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            control.setLayoutData((Object)gd);
        }
    }

    protected void doFillBoxIntoGrid(Composite parent, int numColumns) {
        Tree list = this.createListControl(parent);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        list.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.getTreeControl() != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            this.getViewer().setInput(this.modelFromString(s));
        }
    }

    protected abstract Object modelFromString(String var1);

    Control getTreeControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        this.treeViewer.setGrayed(element, false);
        this.treeViewer.setSubtreeChecked(element, event.getChecked());
        Object parent = this.getContentProvider().getParent(element);
        if (parent != null) {
            this.updateCheckedState(parent);
            this.treeViewer.setParentsGrayed(parent, true);
        }
        this.refreshValidState();
    }

    private ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)this.treeViewer.getContentProvider();
    }

    private void updateCheckedState(Object parent) {
        Object[] children = this.getContentProvider().getChildren(parent);
        int count = 0;
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (this.treeViewer.getChecked(object)) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            this.treeViewer.setChecked(parent, true);
        }
        if (count == 0) {
            this.treeViewer.setGrayed(parent, false);
            this.treeViewer.setChecked(parent, false);
            return;
        }
        if (count < i) {
            this.treeViewer.setGrayed(parent, true);
        }
    }

    protected void doLoadDefault() {
        if (this.getTreeControl() != null) {
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.getViewer().setInput(this.modelFromString(s));
        }
    }

    protected void doStore() {
        String s = this.modelToString(this.getViewer().getInput());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public Tree createListControl(Composite parent) {
        Tree table = (Tree)this.getTreeControl();
        if (table == null) {
            this.listParent = parent;
            this.treeViewer = new CheckboxTreeViewer(parent, 68354);
            table = this.treeViewer.getTree();
            table.setFont(parent.getFont());
            this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        } else {
            this.checkParent((Control)table, parent);
        }
        return table;
    }

    public StructuredViewer getViewer() {
        return this.treeViewer;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Shell getShell() {
        return this.treeViewer.getControl().getShell();
    }

    public void setFocus() {
        if (this.getTreeControl() != null) {
            this.getTreeControl().setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.createListControl(parent).setEnabled(enabled);
    }

    protected abstract String modelToString(Object var1);

    protected void createControl(Composite parent) {
        GridLayout ly = (GridLayout)parent.getLayout();
        this.doFillIntoGrid(parent, ly.numColumns);
    }

    public void setEnabled(boolean b) {
        this.setEnabled(b, this.listParent);
    }

    public Composite getTreeParent() {
        return this.listParent;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    protected boolean checkState() {
        Object[] checkedElements;
        if (!this.emptySelectionAllowed && (checkedElements = this.getTreeViewer().getCheckedElements()).length == 0) {
            this.showErrorMessage(CodanUIMessages.CheckedTreeEditor_SelectionCannotBeEmpty);
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public final boolean isEmptySelectionAllowed() {
        return this.emptySelectionAllowed;
    }

    public final void setEmptySelectionAllowed(boolean emptySelectionAllowed) {
        this.emptySelectionAllowed = emptySelectionAllowed;
    }
}

