/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.OutputStream;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeBuilderUtil;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ScannerInfoConsoleParserFactory {
    public static ConsoleOutputSniffer getESIProviderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, String providerId, IScannerConfigBuilderInfo2 scBuildInfo, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        return ScannerInfoConsoleParserFactory.getESIProviderOutputSniffer(outputStream, errorStream, currentProject, new InfoContext(currentProject), providerId, scBuildInfo, collector, markerGenerator);
    }

    public static ConsoleOutputSniffer getESIProviderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, InfoContext context, String providerId, IScannerConfigBuilderInfo2 scBuildInfo, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        if (scBuildInfo.isProviderOutputParserEnabled(providerId)) {
            SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(currentProject, context, scBuildInfo.getSelectedProfileId());
            IScannerInfoConsoleParser clParser = profileInstance.createExternalScannerInfoParser(providerId);
            IPath buildDirectory = MakeBuilderUtil.getBuildDirectory(currentProject, MakeBuilder.BUILDER_ID);
            clParser.startup(currentProject, buildDirectory, collector, markerGenerator);
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])new IScannerInfoConsoleParser[]{clParser});
        }
        return null;
    }

    public static ConsoleOutputSniffer getMakeBuilderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, IPath workingDirectory, IScannerConfigBuilderInfo2 scBuildInfo, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        return ScannerInfoConsoleParserFactory.getMakeBuilderOutputSniffer(outputStream, errorStream, currentProject, new InfoContext(currentProject), workingDirectory, scBuildInfo, markerGenerator, collector);
    }

    public static ConsoleOutputSniffer getMakeBuilderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, InfoContext context, IPath workingDirectory, IScannerConfigBuilderInfo2 scBuildInfo, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        if (scBuildInfo == null) {
            try {
                IScannerConfigBuilderInfo2Set container = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set(currentProject);
                scBuildInfo = container.getInfo(context);
            }
            catch (CoreException coreException) {}
        }
        if (scBuildInfo != null && scBuildInfo.isAutoDiscoveryEnabled() && scBuildInfo.isBuildOutputParserEnabled()) {
            SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(currentProject, context, scBuildInfo.getSelectedProfileId());
            IScannerInfoConsoleParser clParser = profileInstance.createBuildOutputParser();
            if (collector == null) {
                collector = profileInstance.getScannerInfoCollector();
            }
            if (clParser != null) {
                clParser.startup(currentProject, workingDirectory, collector, (IMarkerGenerator)(scBuildInfo.isProblemReportingEnabled() ? markerGenerator : null));
                return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])new IScannerInfoConsoleParser[]{clParser});
            }
        }
        return null;
    }
}

